/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core;

import org.pkl.core.EvaluatorImpl;
import org.pkl.core.FileOutput;
import org.pkl.core.PklBugException;
import org.pkl.core.PklException;
import org.pkl.core.runtime.VmTyped;
import org.pkl.thirdparty.graalvm.polyglot.PolyglotException;

final class FileOutputImpl
implements FileOutput {
    private final VmTyped fileOutput;
    private final EvaluatorImpl evaluator;

    FileOutputImpl(EvaluatorImpl evaluator, VmTyped fileOutput) {
        this.evaluator = evaluator;
        this.fileOutput = fileOutput;
    }

    @Override
    public String getText() {
        try {
            return this.evaluator.evaluateOutputText(this.fileOutput);
        }
        catch (PolyglotException e2) {
            if (e2.isCancelled()) {
                throw new PklException("The evaluator is no longer available", e2);
            }
            throw new PklBugException(e2);
        }
    }
}

