/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core;

import java.io.File;
import java.net.URI;
import java.nio.file.Path;
import org.pkl.core.runtime.VmUtils;
import org.pkl.core.util.Nullable;

public final class ModuleSource {
    private final URI uri;
    @Nullable
    private final String contents;

    public static ModuleSource create(URI uri, @Nullable String text) {
        return new ModuleSource(uri, text);
    }

    public static ModuleSource path(Path path) {
        return new ModuleSource(path.toUri(), null);
    }

    public static ModuleSource path(String path) {
        return ModuleSource.path(Path.of(path, new String[0]));
    }

    public static ModuleSource text(String text) {
        return new ModuleSource(VmUtils.REPL_TEXT_URI, text);
    }

    public static ModuleSource file(String file) {
        return ModuleSource.file(new File(file));
    }

    public static ModuleSource file(File file) {
        return new ModuleSource(file.toPath().toUri(), null);
    }

    public static ModuleSource uri(String uri) {
        return ModuleSource.uri(URI.create(uri));
    }

    public static ModuleSource uri(URI uri) {
        return new ModuleSource(uri, null);
    }

    public static ModuleSource modulePath(String path) {
        URI uri = path.charAt(0) == '/' ? URI.create("modulepath:" + path) : URI.create("modulepath:/" + path);
        return ModuleSource.uri(uri);
    }

    private ModuleSource(URI uri, @Nullable String contents) {
        this.uri = uri;
        this.contents = contents;
    }

    public URI getUri() {
        return this.uri;
    }

    @Nullable
    public String getContents() {
        return this.contents;
    }
}

