/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.pkl.core.Composite;
import org.pkl.core.DataSize;
import org.pkl.core.Duration;
import org.pkl.core.PClass;
import org.pkl.core.PModule;
import org.pkl.core.PNull;
import org.pkl.core.PObject;
import org.pkl.core.Pair;
import org.pkl.core.RendererException;
import org.pkl.core.TypeAlias;
import org.pkl.core.ValueRenderer;
import org.pkl.core.ValueVisitor;
import org.pkl.core.util.ArrayCharEscaper;

final class PListRenderer
implements ValueRenderer {
    private static final String LINE_BREAK = "\n";
    private static final ArrayCharEscaper charEscaper = ArrayCharEscaper.builder().withEscape('\"', "&quot;").withEscape('\'', "&apos;").withEscape('<', "&lt;").withEscape('>', "&gt;").withEscape('&', "&amp;").build();
    private final Writer writer;
    private final String indent;

    public PListRenderer(Writer writer, String indent) {
        this.writer = writer;
        this.indent = indent;
    }

    @Override
    public void renderDocument(Object value2) {
        if (!(value2 instanceof Collection || value2 instanceof Map || value2 instanceof Composite)) {
            throw new RendererException(String.format("The top-level value of an XML property list must have type `Collection`, `Map`, or `Composite`, but got type `%s`.", value2.getClass().getTypeName()));
        }
        this.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        this.write(LINE_BREAK);
        this.write("<!DOCTYPE plist PUBLIC \"-//Apple//DTD PLIST 1.0//EN\" \"http://www.apple.com/DTDs/PropertyList-1.0.dtd\">");
        this.write(LINE_BREAK);
        this.write("<plist version=\"1.0\">");
        this.write(LINE_BREAK);
        new Visitor().visit(value2);
        this.write(LINE_BREAK);
        this.write("</plist>");
        this.write(LINE_BREAK);
    }

    @Override
    public void renderValue(Object value2) {
        new Visitor().visit(value2);
    }

    private void write(String str) {
        try {
            this.writer.write(str);
        }
        catch (IOException e2) {
            throw new UncheckedIOException(e2);
        }
    }

    private class Visitor
    implements ValueVisitor {
        private String currIndent = "";

        private Visitor() {
        }

        @Override
        public void visitString(String value2) {
            PListRenderer.this.write("<string>");
            PListRenderer.this.write(charEscaper.escape(value2));
            PListRenderer.this.write("</string>");
        }

        @Override
        public void visitInt(Long value2) {
            PListRenderer.this.write("<integer>");
            PListRenderer.this.write(value2.toString());
            PListRenderer.this.write("</integer>");
        }

        @Override
        public void visitFloat(Double value2) {
            PListRenderer.this.write("<real>");
            if (value2.isNaN()) {
                PListRenderer.this.write("nan");
            } else if (value2 == Double.POSITIVE_INFINITY) {
                PListRenderer.this.write("+infinity");
            } else if (value2 == Double.NEGATIVE_INFINITY) {
                PListRenderer.this.write("-infinity");
            } else {
                PListRenderer.this.write(value2.toString());
            }
            PListRenderer.this.write("</real>");
        }

        @Override
        public void visitBoolean(Boolean value2) {
            PListRenderer.this.write(value2 != false ? "<true/>" : "<false/>");
        }

        @Override
        public void visitDuration(Duration value2) {
            throw new RendererException(String.format("Values of type `Duration` cannot be rendered as XML property list. Value: %s", value2));
        }

        @Override
        public void visitDataSize(DataSize value2) {
            throw new RendererException(String.format("Values of type `DataSize` cannot be rendered as XML property list. Value: %s", value2));
        }

        @Override
        public void visitPair(Pair<?, ?> value2) {
            this.doVisitIterable(value2, false);
        }

        @Override
        public void visitList(List<?> value2) {
            this.doVisitIterable(value2, value2.isEmpty());
        }

        @Override
        public void visitSet(Set<?> value2) {
            this.doVisitIterable(value2, value2.isEmpty());
        }

        @Override
        public void visitMap(Map<?, ?> map2) {
            boolean renderedAtLeastOneEntry = false;
            for (Map.Entry<?, ?> entry : map2.entrySet()) {
                Object key2 = entry.getKey();
                if (!(key2 instanceof String)) {
                    throw new RendererException(String.format("Maps with non-String keys cannot be rendered as XML property list. Key: %s", key2));
                }
                Object value2 = entry.getValue();
                if (value2 instanceof PNull) continue;
                if (!renderedAtLeastOneEntry) {
                    PListRenderer.this.write("<dict>");
                    PListRenderer.this.write(PListRenderer.LINE_BREAK);
                    this.currIndent = this.currIndent + PListRenderer.this.indent;
                    renderedAtLeastOneEntry = true;
                }
                PListRenderer.this.write(this.currIndent);
                PListRenderer.this.write("<key>");
                PListRenderer.this.write(charEscaper.escape((String)key2));
                PListRenderer.this.write("</key>");
                PListRenderer.this.write(PListRenderer.LINE_BREAK);
                PListRenderer.this.write(this.currIndent);
                this.visit(value2);
                PListRenderer.this.write(PListRenderer.LINE_BREAK);
            }
            if (renderedAtLeastOneEntry) {
                this.currIndent = this.currIndent.substring(0, this.currIndent.length() - PListRenderer.this.indent.length());
                PListRenderer.this.write(this.currIndent);
                PListRenderer.this.write("</dict>");
            } else {
                PListRenderer.this.write("<dict/>");
            }
        }

        @Override
        public void visitObject(PObject value2) {
            this.doVisitComposite(value2);
        }

        @Override
        public void visitModule(PModule value2) {
            this.doVisitComposite(value2);
        }

        @Override
        public void visitNull() {
            throw new RendererException("`null` values cannot be rendered as XML property list.");
        }

        @Override
        public void visitClass(PClass value2) {
            throw new RendererException(String.format("Values of type `Class` cannot be rendered as XML property list. Value: %s", value2));
        }

        @Override
        public void visitTypeAlias(TypeAlias value2) {
            throw new RendererException(String.format("Values of type `TypeAlias` cannot be rendered as XML property list. Value: %s", value2.getSimpleName()));
        }

        @Override
        public void visitRegex(Pattern value2) {
            throw new RendererException(String.format("Values of type `Regex` cannot be rendered as XML property list. Value: %s", value2));
        }

        private void doVisitIterable(Iterable<?> iterable, boolean isEmpty2) {
            if (isEmpty2) {
                PListRenderer.this.write("<array/>");
                return;
            }
            PListRenderer.this.write("<array>");
            PListRenderer.this.write(PListRenderer.LINE_BREAK);
            this.currIndent = this.currIndent + PListRenderer.this.indent;
            for (Object elem : iterable) {
                PListRenderer.this.write(this.currIndent);
                this.visit(elem);
                PListRenderer.this.write(PListRenderer.LINE_BREAK);
            }
            this.currIndent = this.currIndent.substring(0, this.currIndent.length() - PListRenderer.this.indent.length());
            PListRenderer.this.write(this.currIndent);
            PListRenderer.this.write("</array>");
        }

        private void doVisitComposite(Composite composite) {
            boolean renderedAtLeastOneProperty = false;
            for (Map.Entry<String, Object> entry : composite.getProperties().entrySet()) {
                Object value2 = entry.getValue();
                if (value2 instanceof PNull) continue;
                if (!renderedAtLeastOneProperty) {
                    PListRenderer.this.write("<dict>");
                    PListRenderer.this.write(PListRenderer.LINE_BREAK);
                    this.currIndent = this.currIndent + PListRenderer.this.indent;
                    renderedAtLeastOneProperty = true;
                }
                PListRenderer.this.write(this.currIndent);
                PListRenderer.this.write("<key>");
                PListRenderer.this.write(charEscaper.escape(entry.getKey()));
                PListRenderer.this.write("</key>");
                PListRenderer.this.write(PListRenderer.LINE_BREAK);
                PListRenderer.this.write(this.currIndent);
                this.visit(value2);
                PListRenderer.this.write(PListRenderer.LINE_BREAK);
            }
            if (renderedAtLeastOneProperty) {
                this.currIndent = this.currIndent.substring(0, this.currIndent.length() - PListRenderer.this.indent.length());
                PListRenderer.this.write(this.currIndent);
                PListRenderer.this.write("</dict>");
            } else {
                PListRenderer.this.write("<dict/>");
            }
        }
    }
}

