/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.ServiceLoader;
import java.util.stream.StreamSupport;
import org.pkl.core.PklBugException;
import org.pkl.core.Release;
import org.pkl.core.SecurityManagerException;
import org.pkl.core.StackFrame;
import org.pkl.core.StackFrameTransformer;
import org.pkl.core.packages.DependencyMetadata;
import org.pkl.core.packages.PackageAssetUri;
import org.pkl.core.packages.PackageResolver;
import org.pkl.core.runtime.VmContext;
import org.pkl.core.settings.PklSettings;
import org.pkl.core.util.IoUtils;

public final class StackFrameTransformers {
    public static final StackFrameTransformer empty = s2 -> s2;
    public static final StackFrameTransformer convertStdLibUrlToExternalUrl = frame -> {
        String uri = frame.getModuleUri();
        if (uri.startsWith("pkl:")) {
            String moduleName = uri.substring(4);
            return frame.withModuleUri(Release.current().sourceCode().getFilePage("stdlib/" + moduleName + ".pkl#L" + frame.getStartLine()));
        }
        return frame;
    };
    public static final StackFrameTransformer replacePackageUriWithSourceCodeUrl = frame -> {
        URI uri = URI.create(frame.getModuleUri());
        if (!uri.getScheme().equalsIgnoreCase("package")) {
            return frame;
        }
        try {
            PackageAssetUri assetUri = new PackageAssetUri(uri);
            PackageResolver packageResolver = VmContext.get(null).getPackageResolver();
            assert (packageResolver != null);
            DependencyMetadata pkg = packageResolver.getDependencyMetadata(assetUri.getPackageUri(), null);
            String sourceCode = pkg.getSourceCodeUrlScheme();
            if (sourceCode == null) {
                return frame;
            }
            return StackFrameTransformers.transformUri(frame, uri.getFragment(), sourceCode);
        }
        catch (IOException | URISyntaxException | SecurityManagerException e2) {
            throw PklBugException.unreachableCode();
        }
    };
    public static final StackFrameTransformer fromServiceProviders = StackFrameTransformers.loadFromServiceProviders();
    public static final StackFrameTransformer defaultTransformer = fromServiceProviders.andThen(convertStdLibUrlToExternalUrl).andThen(replacePackageUriWithSourceCodeUrl);

    private StackFrameTransformers() {
    }

    private static StackFrame transformUri(StackFrame frame, String path, String format) {
        String uri = frame.getModuleUri();
        String newUri = format.replace("%{path}", path).replace("%{url}", uri).replace("%{line}", String.valueOf(frame.getStartLine())).replace("%{endLine}", String.valueOf(frame.getEndLine())).replace("%{column}", String.valueOf(frame.getStartColumn())).replace("%{endColumn}", String.valueOf(frame.getEndColumn()));
        return frame.withModuleUri(newUri);
    }

    public static StackFrameTransformer convertFilePathToUriScheme(String scheme) {
        return frame -> {
            String uri = frame.getModuleUri();
            if (!uri.startsWith("file:")) {
                return frame;
            }
            return StackFrameTransformers.transformUri(frame, Path.of(URI.create(uri)).toString(), scheme);
        };
    }

    public static StackFrameTransformer relativizeModuleUri(URI baseUri) {
        return frame -> {
            URI uri = URI.create(frame.getModuleUri());
            URI relativized = baseUri.relativize(uri);
            return frame.withModuleUri(relativized.toString());
        };
    }

    public static StackFrameTransformer createDefault(PklSettings settings) {
        return defaultTransformer.andThen(StackFrameTransformers.convertFilePathToUriScheme(settings.editor().urlScheme()));
    }

    private static StackFrameTransformer loadFromServiceProviders() {
        ServiceLoader<StackFrameTransformer> loader = IoUtils.createServiceLoader(StackFrameTransformer.class);
        return StreamSupport.stream(loader.spliterator(), false).reduce((t1, t2) -> t1.andThen((StackFrameTransformer)t2)).orElse(t -> t);
    }
}

