/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.builder;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.function.Function;
import org.pkl.core.TypeParameter;
import org.pkl.core.ast.ConstantNode;
import org.pkl.core.ast.ExpressionNode;
import org.pkl.core.ast.builder.ConstLevel;
import org.pkl.core.ast.member.ObjectMember;
import org.pkl.core.parser.Lexer;
import org.pkl.core.parser.antlr.PklParser;
import org.pkl.core.runtime.Identifier;
import org.pkl.core.runtime.ModuleInfo;
import org.pkl.core.runtime.VmDataSize;
import org.pkl.core.runtime.VmDuration;
import org.pkl.core.util.Nullable;
import org.pkl.thirdparty.truffle.api.frame.FrameDescriptor;
import org.pkl.thirdparty.truffle.api.frame.FrameSlotKind;

public final class SymbolTable {
    private Scope currentScope;
    public static Object FOR_GENERATOR_VARIABLE = new Object();

    public SymbolTable(ModuleInfo moduleInfo) {
        this.currentScope = new ModuleScope(moduleInfo);
    }

    public Scope getCurrentScope() {
        return this.currentScope;
    }

    @Nullable
    public TypeParameter findTypeParameter(String name) {
        for (Scope scope = this.currentScope; scope != null; scope = scope.getParent()) {
            TypeParameter result = scope.getTypeParameter(name);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public ObjectMember enterClass(Identifier name, List<TypeParameter> typeParameters, Function<ClassScope, ObjectMember> nodeFactory) {
        return this.doEnter(new ClassScope(this.currentScope, name, this.toQualifiedName(name), FrameDescriptor.newBuilder(), typeParameters), nodeFactory);
    }

    public ObjectMember enterTypeAlias(Identifier name, List<TypeParameter> typeParameters, Function<TypeAliasScope, ObjectMember> nodeFactory) {
        return this.doEnter(new TypeAliasScope(this.currentScope, name, this.toQualifiedName(name), FrameDescriptor.newBuilder(), typeParameters), nodeFactory);
    }

    public <T> T enterMethod(Identifier name, ConstLevel constLevel, FrameDescriptor.Builder frameDescriptorBuilder, List<TypeParameter> typeParameters, Function<MethodScope, T> nodeFactory) {
        return this.doEnter(new MethodScope(this.currentScope, name, this.toQualifiedName(name), constLevel, frameDescriptorBuilder, typeParameters), nodeFactory);
    }

    public <T> T enterLambda(FrameDescriptor.Builder frameDescriptorBuilder, Function<LambdaScope, T> nodeFactory) {
        Scope parentScope = this.currentScope;
        while (parentScope instanceof LambdaScope) {
            parentScope = parentScope.getParent();
        }
        assert (parentScope != null);
        String qualifiedName = parentScope.qualifiedName + "." + parentScope.getNextLambdaName();
        return this.doEnter(new LambdaScope(this.currentScope, qualifiedName, frameDescriptorBuilder), nodeFactory);
    }

    public <T> T enterProperty(Identifier name, ConstLevel constLevel, Function<PropertyScope, T> nodeFactory) {
        return this.doEnter(new PropertyScope(this.currentScope, name, this.toQualifiedName(name), constLevel, FrameDescriptor.newBuilder()), nodeFactory);
    }

    public <T> T enterEntry(@Nullable ExpressionNode keyNode, Function<EntryScope, T> nodeFactory) {
        String qualifiedName = this.currentScope.getQualifiedName() + this.currentScope.getNextEntryName(keyNode);
        return this.doEnter(new EntryScope(this.currentScope, qualifiedName, FrameDescriptor.newBuilder()), nodeFactory);
    }

    public <T> T enterCustomThisScope(Function<CustomThisScope, T> nodeFactory) {
        return this.doEnter(new CustomThisScope(this.currentScope, this.currentScope.frameDescriptorBuilder), nodeFactory);
    }

    public <T> T enterAnnotationScope(Function<AnnotationScope, T> nodeFactory) {
        return this.doEnter(new AnnotationScope(this.currentScope, this.currentScope.frameDescriptorBuilder), nodeFactory);
    }

    public <T> T enterObjectScope(Function<ObjectScope, T> nodeFactory) {
        return this.doEnter(new ObjectScope(this.currentScope, this.currentScope.frameDescriptorBuilder), nodeFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T, S extends Scope> T doEnter(S scope, Function<S, T> nodeFactory) {
        Scope parentScope = this.currentScope;
        this.currentScope = scope;
        try {
            T t = nodeFactory.apply(scope);
            return t;
        }
        finally {
            this.currentScope = parentScope;
        }
    }

    private String toQualifiedName(Identifier name) {
        String separator = this.currentScope instanceof ModuleScope ? "#" : ".";
        return this.currentScope.qualifiedName + separator + Lexer.maybeQuoteIdentifier(name.toString());
    }

    public static final class ModuleScope
    extends Scope
    implements LexicalScope {
        private final ModuleInfo moduleInfo;

        public ModuleScope(ModuleInfo moduleInfo) {
            super(null, null, moduleInfo.getModuleName(), ConstLevel.NONE, FrameDescriptor.newBuilder());
            this.moduleInfo = moduleInfo;
        }
    }

    public static abstract class Scope {
        @Nullable
        private final Scope parent;
        @Nullable
        private final Identifier name;
        private final String qualifiedName;
        private final Deque<Identifier> forGeneratorVariables = new ArrayDeque<Identifier>();
        private int lambdaCount = 0;
        private int entryCount = 0;
        private final FrameDescriptor.Builder frameDescriptorBuilder;
        private final ConstLevel constLevel;

        private Scope(@Nullable Scope parent, @Nullable Identifier name, String qualifiedName, ConstLevel constLevel, FrameDescriptor.Builder frameDescriptorBuilder) {
            this.parent = parent;
            this.name = name;
            this.qualifiedName = qualifiedName;
            this.frameDescriptorBuilder = frameDescriptorBuilder;
            this.constLevel = parent != null && parent.constLevel.biggerOrEquals(constLevel) ? parent.constLevel : constLevel;
        }

        @Nullable
        public final Scope getParent() {
            return this.parent;
        }

        public final Identifier getName() {
            assert (this.name != null);
            return this.name;
        }

        @Nullable
        public final Identifier getNameOrNull() {
            return this.name;
        }

        public final String getQualifiedName() {
            return this.qualifiedName;
        }

        public FrameDescriptor buildFrameDescriptor() {
            return this.frameDescriptorBuilder.build();
        }

        @Nullable
        public TypeParameter getTypeParameter(String name) {
            return null;
        }

        public final Scope getLexicalScope() {
            Scope scope = this;
            while (!scope.isLexicalScope()) {
                scope = scope.parent;
                assert (scope != null);
            }
            return scope;
        }

        public int getConstDepth() {
            int depth = -1;
            Scope lexicalScope = this.getLexicalScope();
            while (lexicalScope.getConstLevel() == ConstLevel.ALL) {
                ++depth;
                Scope parent = lexicalScope.getParent();
                if (parent == null) {
                    return depth;
                }
                lexicalScope = parent.getLexicalScope();
            }
            return depth;
        }

        public int pushForGeneratorVariableContext(PklParser.ParameterContext ctx) {
            Identifier variable = Identifier.localProperty(ctx.typedIdentifier().Identifier().getText());
            if (this.forGeneratorVariables.contains(variable)) {
                return -1;
            }
            int slot = this.frameDescriptorBuilder.addSlot(FrameSlotKind.Illegal, variable, FOR_GENERATOR_VARIABLE);
            this.forGeneratorVariables.addLast(variable);
            return slot;
        }

        public void popForGeneratorVariable() {
            this.forGeneratorVariables.removeLast();
        }

        public Deque<Identifier> getForGeneratorVariables() {
            return this.forGeneratorVariables;
        }

        private String getNextLambdaName() {
            return "<function#" + ++this.skipLambdaScopes().lambdaCount + ">";
        }

        private String getNextEntryName(@Nullable ExpressionNode keyNode) {
            if (keyNode instanceof ConstantNode) {
                ConstantNode constantNode = (ConstantNode)((Object)keyNode);
                Object value2 = constantNode.getValue();
                if (value2 instanceof String) {
                    return "[\"" + value2 + "\"]";
                }
                if (value2 instanceof Long || value2 instanceof Double || value2 instanceof Boolean || value2 instanceof VmDuration || value2 instanceof VmDataSize) {
                    return "[" + value2 + "]";
                }
            }
            return "[#" + ++this.entryCount + "]";
        }

        public final Scope skipLambdaScopes() {
            Scope curr = this;
            while (curr.isLambdaScope()) {
                curr = curr.getParent();
                assert (curr != null) : "Lambda scope always has a parent";
            }
            return curr;
        }

        public final boolean isModuleScope() {
            return this instanceof ModuleScope;
        }

        public final boolean isClassScope() {
            return this instanceof ClassScope;
        }

        public final boolean isClassMemberScope() {
            if (this.parent == null) {
                return false;
            }
            return this.parent.isClassScope() || this.parent.isModuleScope() && !((ModuleScope)this.parent).moduleInfo.isAmend();
        }

        public final boolean isLambdaScope() {
            return this instanceof LambdaScope;
        }

        public final boolean isCustomThisScope() {
            return this instanceof CustomThisScope;
        }

        public final boolean isLexicalScope() {
            return this instanceof LexicalScope;
        }

        public ConstLevel getConstLevel() {
            return this.constLevel;
        }
    }

    public static final class ClassScope
    extends TypeParameterizableScope
    implements LexicalScope {
        public ClassScope(Scope parent, Identifier name, String qualifiedName, FrameDescriptor.Builder frameDescriptorBuilder, List<TypeParameter> typeParameters) {
            super(parent, name, qualifiedName, ConstLevel.MODULE, frameDescriptorBuilder, typeParameters);
        }
    }

    public static final class TypeAliasScope
    extends TypeParameterizableScope {
        public TypeAliasScope(Scope parent, Identifier name, String qualifiedName, FrameDescriptor.Builder frameDescriptorBuilder, List<TypeParameter> typeParameters) {
            super(parent, name, qualifiedName, ConstLevel.MODULE, frameDescriptorBuilder, typeParameters);
        }
    }

    public static final class MethodScope
    extends TypeParameterizableScope {
        public MethodScope(Scope parent, Identifier name, String qualifiedName, ConstLevel constLevel, FrameDescriptor.Builder frameDescriptorBuilder, List<TypeParameter> typeParameters) {
            super(parent, name, qualifiedName, constLevel, frameDescriptorBuilder, typeParameters);
        }
    }

    public static final class LambdaScope
    extends Scope
    implements LexicalScope {
        public LambdaScope(Scope parent, String qualifiedName, FrameDescriptor.Builder frameDescriptorBuilder) {
            super(parent, null, qualifiedName, ConstLevel.NONE, frameDescriptorBuilder);
        }
    }

    public static final class PropertyScope
    extends Scope {
        public PropertyScope(Scope parent, Identifier name, String qualifiedName, ConstLevel constLevel, FrameDescriptor.Builder frameDescriptorBuilder) {
            super(parent, name, qualifiedName, constLevel, frameDescriptorBuilder);
        }
    }

    public static final class EntryScope
    extends Scope {
        public EntryScope(Scope parent, String qualifiedName, FrameDescriptor.Builder frameDescriptorBuilder) {
            super(parent, null, qualifiedName, ConstLevel.NONE, frameDescriptorBuilder);
        }
    }

    public static final class CustomThisScope
    extends Scope {
        public static final Object FRAME_SLOT_ID = new Object(){

            public String toString() {
                return "customThisSlot";
            }
        };

        public CustomThisScope(Scope parent, FrameDescriptor.Builder frameDescriptorBuilder) {
            super(parent, parent.getNameOrNull(), parent.getQualifiedName(), ConstLevel.NONE, frameDescriptorBuilder);
        }
    }

    public static final class AnnotationScope
    extends Scope
    implements LexicalScope {
        public AnnotationScope(Scope parent, FrameDescriptor.Builder frameDescriptorBuilder) {
            super(parent, parent.getNameOrNull(), parent.getQualifiedName(), ConstLevel.MODULE, frameDescriptorBuilder);
        }
    }

    public static class ObjectScope
    extends Scope
    implements LexicalScope {
        private ObjectScope(Scope parent, FrameDescriptor.Builder frameDescriptorBuilder) {
            super(parent, parent.getNameOrNull(), parent.getQualifiedName(), ConstLevel.NONE, frameDescriptorBuilder);
        }
    }

    public static abstract class TypeParameterizableScope
    extends Scope {
        private final List<TypeParameter> typeParameters;

        public TypeParameterizableScope(Scope parent, Identifier name, String qualifiedName, ConstLevel constLevel, FrameDescriptor.Builder frameDescriptorBuilder, List<TypeParameter> typeParameters) {
            super(parent, name, qualifiedName, constLevel, frameDescriptorBuilder);
            this.typeParameters = typeParameters;
        }

        @Override
        @Nullable
        public TypeParameter getTypeParameter(String name) {
            for (TypeParameter param : this.typeParameters) {
                if (!name.equals(param.getName())) continue;
                return param;
            }
            return null;
        }
    }

    private static interface LexicalScope {
    }
}

