/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.expression.generator;

import java.util.Arrays;
import org.pkl.core.ast.PklNode;
import org.pkl.core.ast.member.ObjectMember;
import org.pkl.core.runtime.Identifier;
import org.pkl.core.runtime.VmClass;
import org.pkl.core.runtime.VmException;
import org.pkl.core.util.EconomicMaps;
import org.pkl.core.util.Nullable;
import org.pkl.thirdparty.graalvm.collections.EconomicMap;
import org.pkl.thirdparty.truffle.api.CompilerDirectives;
import org.pkl.thirdparty.truffle.api.dsl.Idempotent;
import org.pkl.thirdparty.truffle.api.frame.VirtualFrame;
import org.pkl.thirdparty.truffle.api.source.SourceSection;

public abstract class GeneratorMemberNode
extends PklNode {
    protected GeneratorMemberNode(SourceSection sourceSection) {
        super(sourceSection);
    }

    public abstract void execute(VirtualFrame var1, Object var2, ObjectData var3);

    protected VmException duplicateDefinition(Object key2, ObjectMember member) {
        return this.exceptionBuilder().evalError("duplicateDefinition", key2 instanceof Identifier ? key2 : new VmException.ProgramValue("", key2)).withSourceSection(member.getHeaderSection()).build();
    }

    @Idempotent
    protected static boolean isTypedObjectClass(VmClass clazz) {
        assert (clazz.isInstantiable());
        return !clazz.isListingClass() && !clazz.isMappingClass() && !clazz.isDynamicClass();
    }

    @Idempotent
    protected boolean checkIsValidTypedProperty(VmClass clazz, ObjectMember member) {
        if (member.isLocal() || clazz.hasProperty(member.getName())) {
            return true;
        }
        CompilerDirectives.transferToInterpreter();
        throw this.exceptionBuilder().cannotFindProperty(clazz.getPrototype(), member.getName(), false, false).withSourceSection(member.getHeaderSection()).build();
    }

    @CompilerDirectives.ValueType
    public static final class ObjectData {
        final EconomicMap<Object, ObjectMember> members;
        final EconomicMap<Object, Object[]> forBindings = EconomicMap.create();
        int length;
        private Object @Nullable [] currentForBindings;

        ObjectData(int minMemberCount, int length2) {
            this.members = EconomicMaps.create(minMemberCount);
            this.length = length2;
        }

        @CompilerDirectives.TruffleBoundary
        Object @Nullable [] addForBinding(Object value2) {
            Object[] result = this.currentForBindings;
            if (this.currentForBindings == null) {
                this.currentForBindings = new Object[]{value2};
            } else {
                this.currentForBindings = Arrays.copyOf(this.currentForBindings, this.currentForBindings.length + 1);
                this.currentForBindings[this.currentForBindings.length - 1] = value2;
            }
            return result;
        }

        @CompilerDirectives.TruffleBoundary
        Object @Nullable [] addForBinding(Object key2, Object value2) {
            Object[] result = this.currentForBindings;
            if (this.currentForBindings == null) {
                this.currentForBindings = new Object[]{key2, value2};
            } else {
                this.currentForBindings = Arrays.copyOf(this.currentForBindings, this.currentForBindings.length + 2);
                this.currentForBindings[this.currentForBindings.length - 2] = key2;
                this.currentForBindings[this.currentForBindings.length - 1] = value2;
            }
            return result;
        }

        void persistForBindings(Object key2) {
            EconomicMaps.put(this.forBindings, key2, this.currentForBindings);
        }

        void resetForBindings(Object @Nullable [] bindings) {
            this.currentForBindings = bindings;
        }
    }
}

