/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.expression.generator;

import org.pkl.core.ast.ExpressionNode;
import org.pkl.core.runtime.VmUtils;
import org.pkl.core.util.EconomicMaps;
import org.pkl.thirdparty.graalvm.collections.UnmodifiableEconomicMap;
import org.pkl.thirdparty.truffle.api.frame.VirtualFrame;
import org.pkl.thirdparty.truffle.api.nodes.ExplodeLoop;
import org.pkl.thirdparty.truffle.api.nodes.Node;

public final class WriteForVariablesNode
extends ExpressionNode {
    private final int[] auxiliarySlots;
    @Node.Child
    private ExpressionNode childNode;

    public WriteForVariablesNode(int[] auxiliarySlots, ExpressionNode childNode) {
        this.auxiliarySlots = auxiliarySlots;
        this.childNode = childNode;
    }

    @Override
    @ExplodeLoop
    public Object executeGeneric(VirtualFrame frame) {
        Object extraStorage = VmUtils.getOwner(frame).getExtraStorage();
        assert (extraStorage instanceof UnmodifiableEconomicMap);
        UnmodifiableEconomicMap forBindings = (UnmodifiableEconomicMap)extraStorage;
        Object[] bindings = (Object[])EconomicMaps.get(forBindings, VmUtils.getMemberKey(frame));
        assert (bindings != null);
        assert (bindings.length == this.auxiliarySlots.length);
        for (int i = 0; i < this.auxiliarySlots.length; ++i) {
            frame.setAuxiliarySlot(this.auxiliarySlots[i], bindings[i]);
        }
        return this.childNode.executeGeneric(frame);
    }
}

