/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.expression.literal;

import org.pkl.core.ast.ExpressionNode;
import org.pkl.core.runtime.BaseModule;
import org.pkl.core.runtime.VmClass;
import org.pkl.core.runtime.VmDynamic;
import org.pkl.core.runtime.VmListing;
import org.pkl.core.runtime.VmMapping;
import org.pkl.core.runtime.VmNull;
import org.pkl.core.runtime.VmObjectLike;
import org.pkl.core.runtime.VmUtils;
import org.pkl.thirdparty.truffle.api.CompilerDirectives;
import org.pkl.thirdparty.truffle.api.dsl.Fallback;
import org.pkl.thirdparty.truffle.api.dsl.ImportStatic;
import org.pkl.thirdparty.truffle.api.dsl.NodeChild;
import org.pkl.thirdparty.truffle.api.dsl.Specialization;
import org.pkl.thirdparty.truffle.api.source.SourceSection;

@ImportStatic(value={BaseModule.class})
@NodeChild(value="parentNode", type=ExpressionNode.class)
public abstract class EmptyObjectLiteralNode
extends ExpressionNode {
    protected EmptyObjectLiteralNode(SourceSection sourceSection) {
        super(sourceSection);
    }

    protected abstract ExpressionNode getParentNode();

    @Specialization
    protected Object eval(VmClass parent) {
        if (parent.isListingClass()) {
            return VmListing.empty();
        }
        if (parent.isMappingClass()) {
            return VmMapping.empty();
        }
        if (parent.isDynamicClass()) {
            return VmDynamic.empty();
        }
        VmUtils.checkIsInstantiable(parent, this.getParentNode());
        return parent.getPrototype();
    }

    @Specialization
    protected Object eval(VmObjectLike parent) {
        return parent;
    }

    @Specialization
    protected Object eval(VmNull parent) {
        return parent.getDefaultValue();
    }

    @CompilerDirectives.TruffleBoundary
    @Fallback
    protected void fallback(Object parent) {
        assert (!(parent instanceof VmClass));
        VmUtils.checkIsInstantiable(VmUtils.getClass(parent), this.getParentNode());
        throw this.exceptionBuilder().unreachableCode().build();
    }
}

