/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.expression.member;

import org.pkl.core.ast.ExpressionNode;
import org.pkl.core.ast.member.ObjectMember;
import org.pkl.core.runtime.Identifier;
import org.pkl.core.runtime.VmDynamic;
import org.pkl.core.runtime.VmFunction;
import org.pkl.core.runtime.VmObjectLike;
import org.pkl.core.runtime.VmUtils;
import org.pkl.thirdparty.truffle.api.CompilerDirectives;
import org.pkl.thirdparty.truffle.api.frame.VirtualFrame;
import org.pkl.thirdparty.truffle.api.nodes.IndirectCallNode;
import org.pkl.thirdparty.truffle.api.nodes.Node;
import org.pkl.thirdparty.truffle.api.source.SourceSection;

public final class ReadSuperPropertyNode
extends ExpressionNode {
    private final Identifier propertyName;
    private final boolean needsConst;
    @Node.Child
    private IndirectCallNode callNode = IndirectCallNode.create();

    public ReadSuperPropertyNode(SourceSection sourceSection, Identifier propertyName, boolean needsConst) {
        super(sourceSection);
        this.propertyName = propertyName;
        this.needsConst = needsConst;
    }

    @Override
    public Object executeGeneric(VirtualFrame frame) {
        VmObjectLike receiver = VmUtils.getObjectReceiver(frame);
        VmObjectLike initialOwner = VmUtils.getOwner(frame);
        while (initialOwner instanceof VmFunction) {
            initialOwner = initialOwner.getEnclosingOwner();
        }
        assert (initialOwner != null) : "VmFunction always has a parent";
        for (VmObjectLike owner = initialOwner = initialOwner.getParent(); owner != null; owner = owner.getParent()) {
            ObjectMember property = owner.getMember(this.propertyName);
            if (property == null) continue;
            if (this.needsConst && !property.isConst()) {
                CompilerDirectives.transferToInterpreter();
                throw this.exceptionBuilder().evalError("propertyMustBeConst", this.propertyName.toString()).build();
            }
            Object constantValue = property.getConstantValue();
            if (constantValue != null) {
                return constantValue;
            }
            return this.callNode.call(property.getCallTarget(), receiver, owner, this.propertyName, VmUtils.SKIP_TYPECHECK_MARKER);
        }
        return VmDynamic.empty();
    }
}

