/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.expression.ternary;

import org.pkl.core.ast.ExpressionNode;
import org.pkl.core.runtime.BaseModule;
import org.pkl.thirdparty.truffle.api.CompilerDirectives;
import org.pkl.thirdparty.truffle.api.frame.VirtualFrame;
import org.pkl.thirdparty.truffle.api.nodes.Node;
import org.pkl.thirdparty.truffle.api.nodes.NodeInfo;
import org.pkl.thirdparty.truffle.api.nodes.UnexpectedResultException;
import org.pkl.thirdparty.truffle.api.source.SourceSection;

@NodeInfo(shortName="if")
public final class IfElseNode
extends ExpressionNode {
    @Node.Child
    private ExpressionNode conditionNode;
    @Node.Child
    private ExpressionNode thenNode;
    @Node.Child
    private ExpressionNode elseNode;

    public IfElseNode(SourceSection sourceSection, ExpressionNode conditionNode, ExpressionNode thenNode, ExpressionNode elseNode) {
        super(sourceSection);
        this.conditionNode = conditionNode;
        this.thenNode = thenNode;
        this.elseNode = elseNode;
    }

    @Override
    public Object executeGeneric(VirtualFrame frame) {
        return this.evaluateCondition(frame) ? this.thenNode.executeGeneric(frame) : this.elseNode.executeGeneric(frame);
    }

    private boolean evaluateCondition(VirtualFrame frame) {
        try {
            return this.conditionNode.executeBoolean(frame);
        }
        catch (UnexpectedResultException e2) {
            CompilerDirectives.transferToInterpreter();
            throw this.exceptionBuilder().typeMismatch(e2.getResult(), BaseModule.getBooleanClass()).withSourceSection(this.conditionNode.getSourceSection()).build();
        }
    }
}

