/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.expression.unary;

import java.net.URI;
import org.pkl.core.SecurityManagerException;
import org.pkl.core.ast.expression.unary.AbstractImportNode;
import org.pkl.core.http.HttpClientInitException;
import org.pkl.core.module.ModuleKey;
import org.pkl.core.module.ResolvedModuleKey;
import org.pkl.core.packages.PackageLoadError;
import org.pkl.core.runtime.VmContext;
import org.pkl.core.runtime.VmLanguage;
import org.pkl.core.runtime.VmTyped;
import org.pkl.core.util.LateInit;
import org.pkl.thirdparty.truffle.api.CompilerDirectives;
import org.pkl.thirdparty.truffle.api.frame.VirtualFrame;
import org.pkl.thirdparty.truffle.api.nodes.NodeInfo;
import org.pkl.thirdparty.truffle.api.source.SourceSection;

@NodeInfo(shortName="import")
public final class ImportNode
extends AbstractImportNode {
    private final VmLanguage language;
    @CompilerDirectives.CompilationFinal
    @LateInit
    private VmTyped importedModule;

    public ImportNode(VmLanguage language, SourceSection sourceSection, ResolvedModuleKey currentModule, URI importUri) {
        super(sourceSection, currentModule, importUri);
        this.language = language;
        assert (importUri.isAbsolute());
    }

    @Override
    public Object executeGeneric(VirtualFrame frame) {
        if (this.importedModule == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            VmContext context = VmContext.get(this);
            try {
                context.getSecurityManager().checkImportModule(this.currentModule.getUri(), this.importUri);
                ModuleKey moduleToImport = context.getModuleResolver().resolve(this.importUri, this);
                this.importedModule = this.language.loadModule(moduleToImport, this);
            }
            catch (SecurityManagerException | HttpClientInitException | PackageLoadError e2) {
                throw this.exceptionBuilder().withCause(e2).build();
            }
        }
        return this.importedModule;
    }
}

