/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.member;

import org.pkl.core.ast.ExpressionNode;
import org.pkl.core.ast.member.ObjectMember;
import org.pkl.core.ast.member.RegularMemberNode;
import org.pkl.core.ast.type.TypeNode;
import org.pkl.core.ast.type.UnresolvedTypeNode;
import org.pkl.core.ast.type.VmTypeMismatchException;
import org.pkl.core.runtime.VmException;
import org.pkl.core.runtime.VmLanguage;
import org.pkl.core.util.LateInit;
import org.pkl.core.util.Nullable;
import org.pkl.thirdparty.truffle.api.CompilerDirectives;
import org.pkl.thirdparty.truffle.api.frame.FrameDescriptor;
import org.pkl.thirdparty.truffle.api.frame.VirtualFrame;
import org.pkl.thirdparty.truffle.api.nodes.Node;

public final class LocalTypedPropertyNode
extends RegularMemberNode {
    private final VmLanguage language;
    @Node.Child
    private UnresolvedTypeNode unresolvedTypeNode;
    @Node.Child
    @LateInit
    private TypeNode typeNode;
    @Nullable
    private Object defaultValue;
    private boolean defaultValueInitialized;

    public LocalTypedPropertyNode(VmLanguage language, FrameDescriptor descriptor, ObjectMember member, ExpressionNode bodyNode, UnresolvedTypeNode unresolvedTypeNode) {
        super(language, descriptor, member, bodyNode);
        this.language = language;
        this.unresolvedTypeNode = unresolvedTypeNode;
    }

    @Nullable
    public Object getDefaultValue() {
        if (!this.defaultValueInitialized) {
            this.defaultValue = this.typeNode.createDefaultValue(this.language, this.member.getHeaderSection(), this.member.getQualifiedName());
            this.defaultValueInitialized = true;
        }
        return this.defaultValue;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        try {
            if (this.typeNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.typeNode = this.insert(this.unresolvedTypeNode.execute(frame));
                this.unresolvedTypeNode = null;
            }
            Object result = this.bodyNode.executeGeneric(frame);
            this.typeNode.execute(frame, result);
            return result;
        }
        catch (VmTypeMismatchException e2) {
            CompilerDirectives.transferToInterpreter();
            throw e2.toVmException();
        }
        catch (Exception e3) {
            CompilerDirectives.transferToInterpreter();
            if (e3 instanceof VmException) {
                throw e3;
            }
            throw this.exceptionBuilder().bug(e3.getMessage(), new Object[0]).withCause(e3).build();
        }
    }
}

