/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.http;

import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.concurrent.ThreadSafe;
import org.pkl.core.http.HttpClient;
import org.pkl.core.util.HttpUtils;

@ThreadSafe
final class RequestRewritingClient
implements HttpClient {
    final String userAgent;
    final Duration requestTimeout;
    final int testPort;
    final HttpClient delegate;
    private final AtomicBoolean closed = new AtomicBoolean();

    RequestRewritingClient(String userAgent, Duration requestTimeout, int testPort, HttpClient delegate) {
        this.userAgent = userAgent;
        this.requestTimeout = requestTimeout;
        this.testPort = testPort;
        this.delegate = delegate;
    }

    @Override
    public <T> HttpResponse<T> send(HttpRequest request, HttpResponse.BodyHandler<T> responseBodyHandler) throws IOException {
        this.checkNotClosed(request);
        return this.delegate.send(this.rewriteRequest(request), responseBodyHandler);
    }

    @Override
    public void close() {
        if (!this.closed.getAndSet(true)) {
            this.delegate.close();
        }
    }

    private HttpRequest rewriteRequest(HttpRequest original) {
        HttpRequest.Builder builder = HttpRequest.newBuilder();
        builder.uri(this.rewriteUri(original.uri())).expectContinue(original.expectContinue()).timeout(original.timeout().orElse(this.requestTimeout)).version(original.version().orElse(HttpClient.Version.HTTP_2));
        original.headers().map().forEach((name, values2) -> values2.forEach(value2 -> builder.header((String)name, (String)value2)));
        builder.setHeader("User-Agent", this.userAgent);
        String method = original.method();
        original.bodyPublisher().ifPresentOrElse(publisher -> builder.method(method, (HttpRequest.BodyPublisher)publisher), () -> {
            switch (method) {
                case "GET": {
                    builder.GET();
                    break;
                }
                case "DELETE": {
                    builder.DELETE();
                    break;
                }
                default: {
                    builder.method(method, HttpRequest.BodyPublishers.noBody());
                }
            }
        });
        return builder.build();
    }

    private URI rewriteUri(URI uri) {
        if (this.testPort != -1 && uri.getPort() == 0) {
            return HttpUtils.setPort(uri, this.testPort);
        }
        return uri;
    }

    private void checkNotClosed(HttpRequest request) {
        if (this.closed.get()) {
            throw new IllegalStateException("Cannot send request " + request + " because this client has already been closed.");
        }
    }
}

