/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.module;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import org.pkl.core.SecurityManager;
import org.pkl.core.SecurityManagerException;
import org.pkl.core.http.HttpClient;
import org.pkl.core.module.FileResolver;
import org.pkl.core.module.ModuleKey;
import org.pkl.core.module.ModulePathResolver;
import org.pkl.core.module.PathElement;
import org.pkl.core.module.ProjectDependenciesManager;
import org.pkl.core.module.ResolvedModuleKey;
import org.pkl.core.module.ResolvedModuleKeys;
import org.pkl.core.packages.Dependency;
import org.pkl.core.packages.DependencyMetadata;
import org.pkl.core.packages.PackageAssetUri;
import org.pkl.core.packages.PackageLoadError;
import org.pkl.core.packages.PackageResolver;
import org.pkl.core.packages.PackageUri;
import org.pkl.core.runtime.VmContext;
import org.pkl.core.util.ErrorMessages;
import org.pkl.core.util.HttpUtils;
import org.pkl.core.util.IoUtils;
import org.pkl.core.util.Nullable;
import org.pkl.core.util.Pair;
import org.pkl.thirdparty.truffle.api.CompilerDirectives;

public final class ModuleKeys {
    private ModuleKeys() {
    }

    public static boolean isStdLibModule(ModuleKey module) {
        return module instanceof StandardLibrary;
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean isBaseModule(ModuleKey module) {
        return ModuleKeys.isStdLibModule(module) && module.getUri().getSchemeSpecificPart().equals("base");
    }

    public static ModuleKey synthetic(URI uri, String sourceText) {
        return new Synthetic(uri, uri, uri, sourceText, false);
    }

    public static ModuleKey synthetic(URI uri, URI importBaseUri, URI resolvedUri, String sourceText, boolean isCached) {
        return new Synthetic(uri, importBaseUri, resolvedUri, sourceText, isCached);
    }

    public static ModuleKey standardLibrary(URI uri) {
        return new StandardLibrary(uri);
    }

    public static ModuleKey file(URI uri) {
        return new File(uri);
    }

    public static ModuleKey modulePath(URI uri, ModulePathResolver resolver) {
        return new ModulePath(uri, resolver);
    }

    public static ModuleKey classPath(URI uri, ClassLoader classLoader) {
        return new ClassPath(uri, classLoader);
    }

    public static ModuleKey genericUrl(URI url) {
        return new GenericUrl(url);
    }

    public static ModuleKey http(URI url) {
        return new Http(url);
    }

    public static ModuleKey pkg(URI uri) throws URISyntaxException {
        PackageAssetUri assetUri = new PackageAssetUri(uri);
        return new Package(assetUri);
    }

    public static ModuleKey projectpackage(URI uri) throws URISyntaxException {
        PackageAssetUri assetUri = new PackageAssetUri(uri);
        return new ProjectPackage(assetUri);
    }

    public static ModuleKey cached(ModuleKey delegate, String text) {
        return new CachedModuleKey(delegate, text);
    }

    private static class StandardLibrary
    implements ModuleKey,
    ResolvedModuleKey {
        final URI uri;

        StandardLibrary(URI uri) {
            if (!uri.getScheme().equals("pkl")) {
                throw new IllegalArgumentException("Expected URI with scheme `pkl`, but got: " + uri);
            }
            this.uri = uri;
        }

        @Override
        public URI getUri() {
            return this.uri;
        }

        @Override
        public boolean hasHierarchicalUris() {
            return false;
        }

        @Override
        public boolean isLocal() {
            return true;
        }

        @Override
        public boolean isGlobbable() {
            return false;
        }

        @Override
        public ResolvedModuleKey resolve(SecurityManager securityManager) throws SecurityManagerException {
            securityManager.checkResolveModule(this.uri);
            return this;
        }

        @Override
        public ModuleKey getOriginal() {
            return this;
        }

        @Override
        public String loadSource() throws IOException {
            return IoUtils.readClassPathResourceAsString(this.getClass(), "/org/pkl/core/stdlib/" + this.uri.getSchemeSpecificPart() + ".pkl");
        }
    }

    private static class Synthetic
    implements ModuleKey {
        final URI uri;
        final URI importBaseUri;
        final boolean isCached;
        final ResolvedModuleKey resolvedKey;

        Synthetic(URI uri, URI importBaseUri, URI resolvedUri, String sourceText, boolean isCached) {
            this.uri = uri;
            this.importBaseUri = importBaseUri;
            this.isCached = isCached;
            this.resolvedKey = ResolvedModuleKeys.virtual(this, resolvedUri, sourceText, isCached);
        }

        @Override
        public URI getUri() {
            return this.uri;
        }

        @Override
        public boolean hasHierarchicalUris() {
            return false;
        }

        @Override
        public boolean isLocal() {
            return true;
        }

        @Override
        public boolean isGlobbable() {
            return false;
        }

        @Override
        public ResolvedModuleKey resolve(SecurityManager securityManager) throws SecurityManagerException {
            securityManager.checkResolveModule(this.uri);
            return this.resolvedKey;
        }

        @Override
        public boolean isCached() {
            return this.isCached;
        }
    }

    private static class File
    implements ModuleKey {
        final URI uri;

        File(URI uri) {
            this.uri = uri;
        }

        @Override
        public URI getUri() {
            return this.uri;
        }

        @Override
        public boolean hasElement(SecurityManager securityManager, URI uri) throws SecurityManagerException {
            securityManager.checkResolveModule(uri);
            return FileResolver.hasElement(uri);
        }

        @Override
        public List<PathElement> listElements(SecurityManager securityManager, URI baseUri) throws IOException, SecurityManagerException {
            securityManager.checkResolveModule(baseUri);
            return FileResolver.listElements(baseUri);
        }

        @Override
        public ResolvedModuleKey resolve(SecurityManager securityManager) throws IOException, SecurityManagerException {
            securityManager.checkResolveModule(this.uri);
            String uriPath = this.uri.getPath();
            if (java.io.File.separatorChar == '\\' && uriPath != null && uriPath.contains("\\")) {
                throw new FileNotFoundException();
            }
            Path realPath = Path.of(this.uri).toRealPath(new LinkOption[0]);
            URI resolvedUri = realPath.toUri();
            securityManager.checkResolveModule(resolvedUri);
            return ResolvedModuleKeys.file(this, resolvedUri, realPath);
        }

        @Override
        public boolean isGlobbable() {
            return true;
        }

        @Override
        public boolean isLocal() {
            return true;
        }

        @Override
        public boolean hasHierarchicalUris() {
            return true;
        }
    }

    private static final class ModulePath
    implements ModuleKey {
        final URI uri;
        final ModulePathResolver resolver;

        ModulePath(URI uri, ModulePathResolver resolver) {
            if (uri.getPath() == null) {
                throw new IllegalArgumentException(ErrorMessages.create("invalidModuleUriMissingSlash", uri, "modulepath"));
            }
            this.uri = uri;
            this.resolver = resolver;
        }

        @Override
        public URI getUri() {
            return this.uri;
        }

        @Override
        public boolean hasHierarchicalUris() {
            return true;
        }

        @Override
        public boolean isLocal() {
            return true;
        }

        @Override
        public boolean isGlobbable() {
            return false;
        }

        @Override
        public boolean hasElement(SecurityManager securityManager, URI uri) throws SecurityManagerException {
            securityManager.checkResolveModule(uri);
            return this.resolver.hasElement(uri);
        }

        @Override
        public ResolvedModuleKey resolve(SecurityManager securityManager) throws IOException, SecurityManagerException {
            securityManager.checkResolveModule(this.uri);
            Path path = this.resolver.resolve(this.uri).toRealPath(new LinkOption[0]);
            return ResolvedModuleKeys.file(this, path.toUri(), path);
        }
    }

    private static final class ClassPath
    implements ModuleKey {
        final URI uri;
        final ClassLoader classLoader;

        ClassPath(URI uri, ClassLoader classLoader) {
            if (uri.getPath() == null) {
                throw new IllegalArgumentException(ErrorMessages.create("invalidModuleUriMissingSlash", uri, "modulepath"));
            }
            this.uri = uri;
            this.classLoader = classLoader;
        }

        @Override
        public URI getUri() {
            return this.uri;
        }

        @Override
        public boolean hasHierarchicalUris() {
            return true;
        }

        @Override
        public boolean isLocal() {
            return true;
        }

        @Override
        public boolean isGlobbable() {
            return false;
        }

        @Override
        public boolean hasElement(SecurityManager manager, URI uri) throws SecurityManagerException {
            manager.checkResolveModule(uri);
            String uriPath = uri.getPath();
            assert (uriPath.charAt(0) == '/');
            return this.classLoader.getResource(uriPath.substring(1)) != null;
        }

        @Override
        public ResolvedModuleKey resolve(SecurityManager securityManager) throws IOException, SecurityManagerException {
            securityManager.checkResolveModule(this.uri);
            URL url = this.classLoader.getResource(this.getResourcePath());
            if (url == null) {
                throw new FileNotFoundException();
            }
            try {
                return ResolvedModuleKeys.url(this, url.toURI(), url);
            }
            catch (URISyntaxException e2) {
                throw new AssertionError((Object)e2);
            }
        }

        private String getResourcePath() {
            String path = this.uri.getPath();
            assert (path.charAt(0) == '/');
            return path.substring(1);
        }
    }

    private static class GenericUrl
    implements ModuleKey {
        final URI uri;

        GenericUrl(URI uri) {
            this.uri = uri;
        }

        @Override
        public URI getUri() {
            return this.uri;
        }

        @Override
        public boolean hasHierarchicalUris() {
            return true;
        }

        @Override
        public boolean isGlobbable() {
            return false;
        }

        @Override
        public ResolvedModuleKey resolve(SecurityManager securityManager) throws IOException, SecurityManagerException {
            securityManager.checkResolveModule(this.uri);
            URL url = IoUtils.toUrl(this.uri);
            URLConnection conn = url.openConnection();
            conn.connect();
            if (conn instanceof JarURLConnection && IoUtils.isWindows().booleanValue()) {
                conn.setUseCaches(false);
            }
            try (InputStream stream = conn.getInputStream();){
                URI redirected;
                try {
                    redirected = conn.getURL().toURI();
                }
                catch (URISyntaxException e1) {
                    throw new AssertionError((Object)e1);
                }
                securityManager.checkResolveModule(redirected);
                String text = IoUtils.readString(stream);
                ResolvedModuleKey resolvedModuleKey = ResolvedModuleKeys.virtual(this, this.uri, text, true);
                return resolvedModuleKey;
            }
        }
    }

    private static class Http
    implements ModuleKey {
        private final URI uri;

        Http(URI uri) {
            this.uri = uri;
        }

        @Override
        public URI getUri() {
            return this.uri;
        }

        @Override
        public boolean hasHierarchicalUris() {
            return true;
        }

        @Override
        public boolean isGlobbable() {
            return false;
        }

        @Override
        public ResolvedModuleKey resolve(SecurityManager securityManager) throws IOException, SecurityManagerException {
            HttpClient httpClient = VmContext.get(null).getHttpClient();
            HttpRequest request = HttpRequest.newBuilder(this.uri).build();
            HttpResponse<InputStream> response = httpClient.send(request, HttpResponse.BodyHandlers.ofInputStream());
            try (InputStream body = response.body();){
                HttpUtils.checkHasStatusCode200(response);
                securityManager.checkResolveModule(response.uri());
                String text = IoUtils.readString(body);
                ResolvedModuleKey resolvedModuleKey = ResolvedModuleKeys.virtual(this, this.uri, text, true);
                return resolvedModuleKey;
            }
        }
    }

    private static class Package
    extends AbstractPackage {
        Package(PackageAssetUri packageAssetUri) {
            super(packageAssetUri);
        }

        private PackageResolver getPackageResolver() {
            PackageResolver packageResolver = VmContext.get(null).getPackageResolver();
            assert (packageResolver != null);
            return packageResolver;
        }

        @Override
        public ResolvedModuleKey resolve(SecurityManager securityManager) throws IOException, SecurityManagerException {
            URI uri = this.packageAssetUri.getUri();
            securityManager.checkResolveModule(uri);
            byte[] bytes = this.getPackageResolver().getBytes(this.packageAssetUri, false, this.packageAssetUri.getPackageUri().getChecksums());
            return ResolvedModuleKeys.virtual(this, uri, new String(bytes, StandardCharsets.UTF_8), true);
        }

        @Override
        public List<PathElement> listElements(SecurityManager securityManager, URI baseUri) throws IOException, SecurityManagerException {
            securityManager.checkResolveModule(baseUri);
            PackageAssetUri assetUri = PackageAssetUri.create(baseUri);
            return this.getPackageResolver().listElements(assetUri, assetUri.getPackageUri().getChecksums());
        }

        @Override
        public boolean hasElement(SecurityManager securityManager, URI elementUri) throws IOException, SecurityManagerException {
            securityManager.checkResolveModule(elementUri);
            PackageAssetUri assetUri = PackageAssetUri.create(elementUri);
            return this.getPackageResolver().hasElement(assetUri, assetUri.getPackageUri().getChecksums());
        }

        @Override
        protected Map<String, ? extends Dependency> getDependencies() throws IOException, SecurityManagerException {
            return this.getPackageResolver().getDependencyMetadata(this.packageAssetUri.getPackageUri(), this.packageAssetUri.getPackageUri().getChecksums()).getDependencies();
        }
    }

    public static class ProjectPackage
    extends AbstractPackage {
        ProjectPackage(PackageAssetUri packageAssetUri) {
            super(packageAssetUri);
        }

        private PackageResolver getPackageResolver() {
            PackageResolver packageResolver = VmContext.get(null).getPackageResolver();
            assert (packageResolver != null);
            return packageResolver;
        }

        private ProjectDependenciesManager getProjectDependenciesManager() {
            ProjectDependenciesManager projectDepsManager = VmContext.get(null).getProjectDependenciesManager();
            assert (projectDepsManager != null);
            return projectDepsManager;
        }

        @Nullable
        private URI getLocalUri(Dependency dependency) {
            return this.getLocalUri(dependency, this.packageAssetUri);
        }

        @Nullable
        private URI getLocalUri(Dependency dependency, PackageAssetUri assetUri) {
            if (!(dependency instanceof Dependency.LocalDependency)) {
                return null;
            }
            Dependency.LocalDependency localDependency = (Dependency.LocalDependency)dependency;
            return localDependency.resolveAssetUri(this.getProjectDependenciesManager().getProjectBaseUri(), assetUri);
        }

        @Override
        public ResolvedModuleKey resolve(SecurityManager securityManager) throws IOException, SecurityManagerException {
            URI uri = this.packageAssetUri.getUri();
            securityManager.checkResolveModule(uri);
            Dependency dependency = this.getProjectDependenciesManager().getResolvedDependency(this.packageAssetUri.getPackageUri());
            URI local = this.getLocalUri(dependency);
            if (local != null) {
                ResolvedModuleKey resolved = VmContext.get(null).getModuleResolver().resolve(local).resolve(securityManager);
                return ResolvedModuleKeys.delegated(resolved, this);
            }
            Dependency.RemoteDependency dep = (Dependency.RemoteDependency)dependency;
            assert (dep.getChecksums() != null);
            byte[] bytes = this.getPackageResolver().getBytes(this.packageAssetUri, false, dep.getChecksums());
            return ResolvedModuleKeys.virtual(this, uri, new String(bytes, StandardCharsets.UTF_8), true);
        }

        @Override
        public List<PathElement> listElements(SecurityManager securityManager, URI baseUri) throws IOException, SecurityManagerException {
            securityManager.checkResolveModule(baseUri);
            PackageAssetUri packageAssetUri = PackageAssetUri.create(baseUri);
            Dependency dependency = this.getProjectDependenciesManager().getResolvedDependency(packageAssetUri.getPackageUri());
            URI local = this.getLocalUri(dependency, packageAssetUri);
            if (local != null) {
                ModuleKey moduleKey = VmContext.get(null).getModuleResolver().resolve(local);
                if (!moduleKey.isGlobbable()) {
                    throw new PackageLoadError("cannotResolveInLocalDependencyNotGlobbable", local.getScheme());
                }
                return moduleKey.listElements(securityManager, local);
            }
            Dependency.RemoteDependency dep = (Dependency.RemoteDependency)dependency;
            assert (dep.getChecksums() != null);
            return this.getPackageResolver().listElements(packageAssetUri, dep.getChecksums());
        }

        @Override
        public boolean hasElement(SecurityManager securityManager, URI elementUri) throws IOException, SecurityManagerException {
            securityManager.checkResolveModule(elementUri);
            PackageAssetUri packageAssetUri = PackageAssetUri.create(elementUri);
            Dependency dependency = this.getProjectDependenciesManager().getResolvedDependency(packageAssetUri.getPackageUri());
            URI local = this.getLocalUri(dependency, packageAssetUri);
            if (local != null) {
                ModuleKey moduleKey = VmContext.get(null).getModuleResolver().resolve(local);
                if (!moduleKey.isGlobbable() && !moduleKey.isLocal()) {
                    throw new PackageLoadError("cannotResolveInLocalDependencyNotGlobbableNorLocal", local.getScheme());
                }
                return moduleKey.hasElement(securityManager, local);
            }
            Dependency.RemoteDependency dep = (Dependency.RemoteDependency)dependency;
            assert (dep.getChecksums() != null);
            return this.getPackageResolver().hasElement(packageAssetUri, dep.getChecksums());
        }

        @Override
        protected Map<String, ? extends Dependency> getDependencies() throws IOException, SecurityManagerException {
            PackageUri packageUri = this.packageAssetUri.getPackageUri();
            ProjectDependenciesManager projectResolver = this.getProjectDependenciesManager();
            if (projectResolver.isLocalPackage(packageUri)) {
                return projectResolver.getLocalPackageDependencies(packageUri);
            }
            Dependency.RemoteDependency dep = (Dependency.RemoteDependency)this.getProjectDependenciesManager().getResolvedDependency(packageUri);
            assert (dep.getChecksums() != null);
            DependencyMetadata dependencyMetadata = this.getPackageResolver().getDependencyMetadata(packageUri, dep.getChecksums());
            return projectResolver.getResolvedDependenciesForPackage(packageUri, dependencyMetadata);
        }
    }

    private static class CachedModuleKey
    implements ModuleKey,
    ResolvedModuleKey {
        private final ModuleKey delegate;
        private final String text;

        public CachedModuleKey(ModuleKey delegate, String text) {
            this.delegate = delegate;
            this.text = text;
        }

        @Override
        public ModuleKey getOriginal() {
            return this;
        }

        @Override
        public URI getUri() {
            return this.delegate.getUri();
        }

        @Override
        public String loadSource() {
            return this.text;
        }

        @Override
        public ResolvedModuleKey resolve(SecurityManager securityManager) {
            return this;
        }

        @Override
        public boolean hasHierarchicalUris() {
            return this.delegate.hasHierarchicalUris();
        }

        @Override
        public boolean isLocal() {
            return this.delegate.isLocal();
        }

        @Override
        public boolean isGlobbable() {
            return this.delegate.isGlobbable();
        }

        @Override
        public boolean hasElement(SecurityManager securityManager, URI uri) throws IOException, SecurityManagerException {
            return this.delegate.hasElement(securityManager, uri);
        }

        @Override
        public List<PathElement> listElements(SecurityManager securityManager, URI baseUri) throws IOException, SecurityManagerException {
            return this.delegate.listElements(securityManager, baseUri);
        }
    }

    private static abstract class AbstractPackage
    implements ModuleKey {
        protected final PackageAssetUri packageAssetUri;

        AbstractPackage(PackageAssetUri packageAssetUri) {
            this.packageAssetUri = packageAssetUri;
        }

        protected abstract Map<String, ? extends Dependency> getDependencies() throws IOException, SecurityManagerException;

        @Override
        public boolean hasHierarchicalUris() {
            return true;
        }

        @Override
        public boolean hasFragmentPaths() {
            return true;
        }

        @Override
        public boolean isLocal() {
            return true;
        }

        @Override
        public boolean isGlobbable() {
            return true;
        }

        @Override
        public URI getUri() {
            return this.packageAssetUri.getUri();
        }

        @Override
        public URI resolveUri(URI baseUri, URI importUri) throws IOException, SecurityManagerException {
            String ssp = importUri.getSchemeSpecificPart();
            if (importUri.isAbsolute() || !ssp.startsWith("@")) {
                return ModuleKey.super.resolveUri(baseUri, importUri);
            }
            Pair<String, String> parsed = IoUtils.parseDependencyNotation(ssp);
            String name = parsed.getFirst();
            String path = parsed.getSecond();
            Dependency dependency = this.getDependencies().get(name);
            if (dependency == null) {
                throw new PackageLoadError("cannotFindDependencyInPackage", name, this.packageAssetUri.getPackageUri().getDisplayName());
            }
            return dependency.getPackageUri().toPackageAssetUri(path).getUri();
        }
    }
}

