/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.module;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.concurrent.GuardedBy;
import org.pkl.core.module.PathElement;
import org.pkl.core.runtime.FileSystemManager;
import org.pkl.core.util.IoUtils;
import org.pkl.core.util.LateInit;

public final class ModulePathResolver
implements AutoCloseable {
    private final Iterable<Path> modulePath;
    private final Object lock = new Object();
    @LateInit
    @GuardedBy(value="lock")
    private Map<String, Path> fileCache;
    @LateInit
    @GuardedBy(value="lock")
    private List<FileSystem> zipFileSystems;
    @LateInit
    @GuardedBy(value="lock")
    private PathElement.TreePathElement cachedPathElementRoot;
    @GuardedBy(value="lock")
    private boolean isClosed = false;
    private static final ModulePathResolver EMPTY = new ModulePathResolver(Collections.emptyList());

    public static ModulePathResolver empty() {
        return EMPTY;
    }

    public ModulePathResolver(Iterable<Path> modulePath) {
        this.modulePath = modulePath;
    }

    private void populateCaches() throws IOException {
        this.fileCache = new HashMap<String, Path>();
        this.zipFileSystems = new ArrayList<FileSystem>();
        this.cachedPathElementRoot = new PathElement.TreePathElement("", false);
        for (Path entry : this.modulePath) {
            if (Files.isDirectory(entry, new LinkOption[0])) {
                this.populateFileCache(entry);
                continue;
            }
            if (!ModulePathResolver.isJarOrZipFile(entry)) continue;
            FileSystem zipFileSystem = FileSystemManager.getFileSystem(URI.create("jar:" + entry.toUri()));
            this.zipFileSystems.add(zipFileSystem);
            for (Path root : zipFileSystem.getRootDirectories()) {
                this.populateFileCache(root);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Path> getFileCache() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isClosed) {
                throw new IllegalStateException("Module path loader has already been closed.");
            }
            if (this.fileCache == null) {
                this.populateCaches();
            }
            return this.fileCache;
        }
    }

    public Path resolve(URI uri) throws IOException {
        String modulePath = ModulePathResolver.getModulePath(uri);
        Path result = this.getFileCache().get(modulePath);
        if (result != null) {
            return result;
        }
        throw new FileNotFoundException();
    }

    public boolean hasElement(URI elementUri) {
        String path = elementUri.getPath();
        try {
            assert (path.charAt(0) == '/');
            return this.getFileCache().containsKey(path.substring(1));
        }
        catch (IOException e2) {
            throw new UncheckedIOException(e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            if (this.isClosed || this.fileCache == null) {
                return;
            }
            for (FileSystem fileSystem : this.zipFileSystems) {
                try {
                    fileSystem.close();
                }
                catch (IOException iOException) {}
            }
            this.fileCache = null;
            this.cachedPathElementRoot = null;
            this.zipFileSystems = null;
            this.isClosed = true;
        }
    }

    private void populateFileCache(Path basePath) throws IOException {
        try (Stream<Path> stream = Files.find(basePath, Integer.MAX_VALUE, (path, attributes) -> attributes.isRegularFile() && !path.toString().endsWith(".class"), new FileVisitOption[0]);){
            stream.forEach(path -> {
                Path relativized = IoUtils.relativize(path, basePath);
                this.fileCache.putIfAbsent(IoUtils.toNormalizedPathString(relativized), (Path)path);
                PathElement.TreePathElement element = this.cachedPathElementRoot;
                for (int i = 0; i < relativized.getNameCount(); ++i) {
                    String name = relativized.getName(i).toString();
                    boolean isDirectory = i < relativized.getNameCount() - 1;
                    element = element.putIfAbsent(name, new PathElement.TreePathElement(name, isDirectory));
                }
            });
        }
    }

    private static boolean isJarOrZipFile(Path path) {
        byte[] buffer;
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            return false;
        }
        if (path.endsWith(".jar") || path.endsWith(".zip")) {
            return true;
        }
        try (InputStream fis = Files.newInputStream(path, new OpenOption[0]);){
            buffer = fis.readNBytes(39);
        }
        catch (IOException e2) {
            return false;
        }
        if (buffer[0] == 80 && buffer[1] == 75 && buffer[2] == 3 && buffer[3] == 4) {
            return true;
        }
        return Arrays.equals(buffer, "#!/bin/sh\n      exec java  -jar $0 \"$@\"".getBytes(StandardCharsets.UTF_8));
    }

    private static String getModulePath(URI moduleUri) {
        String path = moduleUri.getPath();
        assert (path.charAt(0) == '/');
        return path.substring(1);
    }
}

