/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.module;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.pkl.core.util.EconomicMaps;
import org.pkl.core.util.Nullable;
import org.pkl.thirdparty.graalvm.collections.EconomicMap;

public class PathElement {
    public static final Comparator<PathElement> comparator = (o1, o2) -> {
        if (o1.isDirectory && !o2.isDirectory) {
            return 1;
        }
        if (!o1.isDirectory && o2.isDirectory) {
            return -1;
        }
        return o1.name.compareTo(o2.name);
    };
    private final String name;
    private final boolean isDirectory;

    public static PathElement opaque(String name) {
        return new PathElement(name, false);
    }

    public PathElement(String name, boolean isDirectory) {
        this.name = name;
        this.isDirectory = isDirectory;
    }

    public String getName() {
        return this.name;
    }

    public PathElement withName(String name) {
        if (name.equals(this.name)) {
            return this;
        }
        return new PathElement(name, this.isDirectory);
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PathElement)) {
            return false;
        }
        PathElement other = (PathElement)obj;
        return this.isDirectory == other.isDirectory && this.name.equals(other.name);
    }

    public int hashCode() {
        return Objects.hash(this.getName(), this.isDirectory());
    }

    public String toString() {
        return "PathElement{name='" + this.name + "', isDirectory=" + this.isDirectory + "}";
    }

    public static final class TreePathElement
    extends PathElement {
        private final EconomicMap<String, TreePathElement> children = EconomicMaps.create();

        public TreePathElement(String name, boolean isDirectory) {
            super(name, isDirectory);
        }

        public TreePathElement putIfAbsent(String name, TreePathElement child) {
            this.children.putIfAbsent(name, child);
            return (TreePathElement)this.children.get(name);
        }

        @Nullable
        public TreePathElement getElement(Path basePath) {
            Path path = basePath.normalize();
            TreePathElement element = this;
            for (int i = 0; i < path.getNameCount(); ++i) {
                String part = path.getName(i).toString();
                if ((element = (TreePathElement)element.getChildren().get(part)) != null) continue;
                return null;
            }
            return element;
        }

        @Nullable
        public TreePathElement getElement(String basePath) {
            return this.getElement(Path.of(basePath, new String[0]));
        }

        public EconomicMap<String, TreePathElement> getChildren() {
            return this.children;
        }

        public List<PathElement> getChildrenValues() {
            ArrayList<PathElement> ret = new ArrayList<PathElement>(this.children.size());
            for (TreePathElement elem : EconomicMaps.getValues(this.children)) {
                ret.add(elem);
            }
            return ret;
        }
    }
}

