/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.packages;

import java.net.URI;
import java.nio.file.Path;
import java.util.Objects;
import org.pkl.core.Version;
import org.pkl.core.packages.Checksums;
import org.pkl.core.packages.PackageAssetUri;
import org.pkl.core.packages.PackageUri;
import org.pkl.core.util.IoUtils;
import org.pkl.core.util.Nullable;

public abstract class Dependency {
    protected final PackageUri packageUri;

    Dependency(PackageUri packageUri) {
        this.packageUri = packageUri;
    }

    public PackageUri getPackageUri() {
        return this.packageUri;
    }

    public Version getVersion() {
        return this.packageUri.getVersion();
    }

    public static final class RemoteDependency
    extends Dependency {
        @Nullable
        private Checksums checksums;

        public RemoteDependency(PackageUri packageUri, @Nullable Checksums checksums) {
            super(packageUri);
            this.checksums = checksums;
        }

        @Nullable
        public Checksums getChecksums() {
            return this.checksums;
        }

        public void setChecksums(Checksums checksums) {
            this.checksums = checksums;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RemoteDependency that = (RemoteDependency)o;
            return this.packageUri.equals(that.packageUri) && Objects.equals(this.checksums, that.checksums);
        }

        public int hashCode() {
            return Objects.hash(this.packageUri, this.checksums);
        }

        public String toString() {
            return "RemoteDependency{checksums=" + this.checksums + ", packageUri=" + this.packageUri + "}";
        }
    }

    public static final class LocalDependency
    extends Dependency {
        private final Path path;

        public LocalDependency(PackageUri packageUri, Path path) {
            super(packageUri);
            this.path = path;
        }

        public Path getPath() {
            return this.path;
        }

        public URI resolveAssetUri(URI projectBaseUri, PackageAssetUri packageAssetUri) {
            String assetPath = packageAssetUri.getAssetPath().substring(1);
            return projectBaseUri.resolve(IoUtils.toNormalizedPathString(this.path.resolve(assetPath)));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LocalDependency that = (LocalDependency)o;
            return this.packageUri.equals(that.packageUri) && this.path.equals(that.path);
        }

        public int hashCode() {
            return Objects.hash(this.packageUri, this.path);
        }

        public String toString() {
            return "LocalDependency{path=" + this.path + ", packageUri=" + this.packageUri + "}";
        }
    }
}

