/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.runtime;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.pkl.core.SecurityManager;
import org.pkl.core.SecurityManagerException;
import org.pkl.core.http.HttpClientInitException;
import org.pkl.core.packages.PackageLoadError;
import org.pkl.core.resource.Resource;
import org.pkl.core.resource.ResourceReader;
import org.pkl.core.runtime.BaseModule;
import org.pkl.core.runtime.VmExceptionBuilder;
import org.pkl.core.stdlib.VmObjectFactory;
import org.pkl.core.util.Nullable;
import org.pkl.thirdparty.truffle.api.CompilerDirectives;
import org.pkl.thirdparty.truffle.api.nodes.Node;

public final class ResourceManager {
    private final Map<String, ResourceReader> resourceReaders = new HashMap<String, ResourceReader>();
    private final SecurityManager securityManager;
    private final VmObjectFactory<Resource> resourceFactory;
    private final Map<URI, Optional<Object>> resources = new HashMap<URI, Optional<Object>>();

    public ResourceManager(SecurityManager securityManager, Collection<ResourceReader> readers) {
        this.securityManager = securityManager;
        for (ResourceReader reader : readers) {
            this.resourceReaders.put(reader.getUriScheme(), reader);
        }
        this.resourceFactory = new VmObjectFactory<Resource>(BaseModule::getResourceClass).addProperty("uri", resource -> resource.getUri().toString()).addProperty("text", Resource::getText).addProperty("base64", Resource::getBase64);
    }

    @CompilerDirectives.TruffleBoundary
    public ResourceReader getReader(URI resourceUri, Node readNode) {
        ResourceReader reader = this.resourceReaders.get(resourceUri.getScheme());
        if (reader == null) {
            throw new VmExceptionBuilder().withLocation(readNode).evalError("noResourceReaderRegistered", resourceUri.getScheme()).build();
        }
        return reader;
    }

    @CompilerDirectives.TruffleBoundary
    public Optional<Object> read(URI resourceUri, @Nullable Node readNode) {
        return this.resources.computeIfAbsent(resourceUri.normalize(), uri -> {
            Optional<Object> resource;
            try {
                this.securityManager.checkReadResource((URI)uri);
            }
            catch (SecurityManagerException e2) {
                throw new VmExceptionBuilder().withCause(e2).withOptionalLocation(readNode).build();
            }
            ResourceReader reader = this.resourceReaders.get(uri.getScheme());
            if (reader == null) {
                throw new VmExceptionBuilder().withOptionalLocation(readNode).evalError("noResourceReaderRegistered", resourceUri.getScheme()).build();
            }
            try {
                resource = reader.read((URI)uri);
            }
            catch (IOException e3) {
                throw new VmExceptionBuilder().evalError("ioErrorReadingResource", uri).withCause(e3).withOptionalLocation(readNode).build();
            }
            catch (URISyntaxException e4) {
                throw new VmExceptionBuilder().evalError("invalidResourceUri", resourceUri).withHint(e4.getReason()).withOptionalLocation(readNode).build();
            }
            catch (SecurityManagerException | HttpClientInitException | PackageLoadError e5) {
                throw new VmExceptionBuilder().withCause(e5).withOptionalLocation(readNode).build();
            }
            if (resource.isEmpty()) {
                return resource;
            }
            Object res = resource.get();
            if (res instanceof String) {
                return resource;
            }
            if (res instanceof Resource) {
                Resource r = (Resource)res;
                return Optional.of(this.resourceFactory.create(r));
            }
            throw new VmExceptionBuilder().evalError("unsupportedResourceType", reader.getClass().getName(), res.getClass()).withOptionalLocation(readNode).build();
        });
    }

    @Nullable
    public ResourceReader getResourceReader(URI baseUri) {
        return this.resourceReaders.get(baseUri.getScheme());
    }
}

