/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.runtime;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.pkl.core.ast.ConstantNode;
import org.pkl.core.ast.ExpressionNode;
import org.pkl.core.runtime.BaseModule;
import org.pkl.core.runtime.Iterators;
import org.pkl.core.runtime.VmClass;
import org.pkl.core.runtime.VmCollection;
import org.pkl.core.runtime.VmDynamic;
import org.pkl.core.runtime.VmListing;
import org.pkl.core.runtime.VmNull;
import org.pkl.core.runtime.VmObjectBuilder;
import org.pkl.core.runtime.VmPair;
import org.pkl.core.runtime.VmSet;
import org.pkl.core.runtime.VmValue;
import org.pkl.core.runtime.VmValueConverter;
import org.pkl.core.runtime.VmValueVisitor;
import org.pkl.core.util.Nullable;
import org.pkl.thirdparty.paguro.collections.BaseList;
import org.pkl.thirdparty.paguro.collections.RrbTree;
import org.pkl.thirdparty.paguro.collections.UnmodCollection;
import org.pkl.thirdparty.paguro.collections.UnmodIterable;
import org.pkl.thirdparty.paguro.tuple.Tuple2;
import org.pkl.thirdparty.truffle.api.CompilerDirectives;

public final class VmList
extends VmCollection {
    public static final VmList EMPTY = new VmList(RrbTree.empty());
    private final RrbTree.ImRrbt<Object> rrbt;
    private boolean forced;

    private VmList(RrbTree.ImRrbt<Object> rrbt) {
        this.rrbt = rrbt;
    }

    @CompilerDirectives.TruffleBoundary
    public static VmList of(Object value2) {
        return new VmList((RrbTree.ImRrbt<Object>)((RrbTree.MutRrbt)RrbTree.emptyMutable().append(value2)).immutable());
    }

    @CompilerDirectives.TruffleBoundary
    public static VmList of(Object value1, Object value2) {
        return new VmList((RrbTree.ImRrbt<Object>)((RrbTree.MutRrbt)((RrbTree.MutRrbt)RrbTree.emptyMutable().append(value1)).append(value2)).immutable());
    }

    static VmList create(RrbTree.ImRrbt<?> rrbt) {
        if (rrbt.isEmpty()) {
            return EMPTY;
        }
        return new VmList(rrbt);
    }

    @CompilerDirectives.TruffleBoundary
    static VmList create(RrbTree.MutRrbt<?> rrbt) {
        if (rrbt.isEmpty()) {
            return EMPTY;
        }
        return new VmList((RrbTree.ImRrbt<Object>)rrbt.immutable());
    }

    @CompilerDirectives.TruffleBoundary
    public static VmList create(Iterable<?> iterable) {
        return VmList.create(((RrbTree.MutRrbt)RrbTree.emptyMutable().concat(iterable)).immutable());
    }

    static VmList create(UnmodIterable<?> iterable) {
        return VmList.create(iterable);
    }

    @CompilerDirectives.TruffleBoundary
    static VmList create(UnmodCollection<?> collection) {
        if (collection.isEmpty()) {
            return EMPTY;
        }
        return new VmList((RrbTree.ImRrbt<Object>)((RrbTree.MutRrbt)RrbTree.emptyMutable().concat(collection)).immutable());
    }

    @CompilerDirectives.TruffleBoundary
    public static VmList create(Object[] elements) {
        if (elements.length == 0) {
            return EMPTY;
        }
        RrbTree.MutRrbt vector = RrbTree.emptyMutable();
        for (Object elem : elements) {
            vector.append(elem);
        }
        return new VmList((RrbTree.ImRrbt<Object>)vector.immutable());
    }

    @CompilerDirectives.TruffleBoundary
    public static VmList create(Object[] elements, int length2) {
        if (elements.length == 0) {
            return EMPTY;
        }
        RrbTree.MutRrbt vector = RrbTree.emptyMutable();
        for (int i = 0; i < length2; ++i) {
            vector.append(elements[i]);
        }
        return new VmList((RrbTree.ImRrbt<Object>)vector.immutable());
    }

    @CompilerDirectives.TruffleBoundary
    public static VmList createFromConstantNodes(ExpressionNode[] elements) {
        if (elements.length == 0) {
            return EMPTY;
        }
        RrbTree.MutRrbt vector = RrbTree.emptyMutable();
        for (ExpressionNode elem : elements) {
            assert (elem instanceof ConstantNode);
            vector.append(((ConstantNode)((Object)elem)).getValue());
        }
        return new VmList((RrbTree.ImRrbt<Object>)vector.immutable());
    }

    @Override
    public VmClass getVmClass() {
        return BaseModule.getListClass();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int getLength() {
        return this.rrbt.size();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean isEmpty() {
        return this.rrbt.isEmpty();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean isLengthOne() {
        return this.rrbt.size() == 1;
    }

    public long getLastIndex() {
        return this.rrbt.size() - 1;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public VmList add(Object element) {
        return VmList.create(this.rrbt.append(element));
    }

    @CompilerDirectives.TruffleBoundary
    public VmList replace(long index, Object element) {
        return VmList.create(this.rrbt.replace((int)index, element));
    }

    @CompilerDirectives.TruffleBoundary
    public Object replaceOrNull(long index, Object element) {
        if (index < 0L || index >= (long)this.getLength()) {
            return VmNull.withoutDefault();
        }
        return VmList.create(this.rrbt.replace((int)index, element));
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public VmList concatenate(VmCollection other) {
        return other.isEmpty() ? this : VmList.create(this.rrbt.concat((Iterable)other));
    }

    @CompilerDirectives.TruffleBoundary
    public Object get(long index) {
        return this.rrbt.get((int)index);
    }

    @CompilerDirectives.TruffleBoundary
    public Object getOrNull(long index) {
        if (index < 0L || index >= (long)this.getLength()) {
            return VmNull.withoutDefault();
        }
        return this.rrbt.get((int)index);
    }

    @CompilerDirectives.TruffleBoundary
    public VmList subList(long start2, long exclusiveEnd) {
        return VmList.create(this.rrbt.subList((int)start2, (int)exclusiveEnd));
    }

    @CompilerDirectives.TruffleBoundary
    public Object subListOrNull(long start2, long exclusiveEnd) {
        int length2 = this.getLength();
        if (start2 < 0L || start2 > (long)length2) {
            return VmNull.withoutDefault();
        }
        if (exclusiveEnd < start2 || exclusiveEnd > (long)length2) {
            return VmNull.withoutDefault();
        }
        return VmList.create(this.rrbt.subList((int)start2, (int)exclusiveEnd));
    }

    @Override
    public Iterator<Object> iterator() {
        if (this.rrbt.isEmpty()) {
            return Iterators.emptyTruffleIterator();
        }
        return new Iterators.TruffleIterator<Object>(this.rrbt);
    }

    @Override
    public Iterator<Object> reverseIterator() {
        if (this.rrbt.isEmpty()) {
            return Iterators.emptyTruffleIterator();
        }
        return new Iterators.ReverseTruffleIterator<Object>(this.rrbt);
    }

    @CompilerDirectives.TruffleBoundary
    public VmCollection.Builder<VmList> builder() {
        return new Builder();
    }

    @CompilerDirectives.TruffleBoundary
    public Object getFirst() {
        this.checkNonEmpty();
        return this.rrbt.get(0);
    }

    @CompilerDirectives.TruffleBoundary
    public Object getFirstOrNull() {
        if (this.rrbt.isEmpty()) {
            return VmNull.withoutDefault();
        }
        return this.rrbt.get(0);
    }

    @CompilerDirectives.TruffleBoundary
    public VmList getRest() {
        this.checkNonEmpty();
        return VmList.create(this.rrbt.drop(1L));
    }

    @CompilerDirectives.TruffleBoundary
    public Object getRestOrNull() {
        if (this.rrbt.isEmpty()) {
            return VmNull.withoutDefault();
        }
        return VmList.create(this.rrbt.drop(1L));
    }

    @CompilerDirectives.TruffleBoundary
    public Object getLast() {
        this.checkNonEmpty();
        return this.rrbt.get(this.rrbt.size() - 1);
    }

    @CompilerDirectives.TruffleBoundary
    public Object getLastOrNull() {
        if (this.isEmpty()) {
            return VmNull.withoutDefault();
        }
        return this.rrbt.get(this.rrbt.size() - 1);
    }

    @CompilerDirectives.TruffleBoundary
    public Object getSingle() {
        this.checkLengthOne();
        return this.rrbt.get(0);
    }

    @CompilerDirectives.TruffleBoundary
    public Object getSingleOrNull() {
        if (!this.isLengthOne()) {
            return VmNull.withoutDefault();
        }
        return this.rrbt.get(0);
    }

    @CompilerDirectives.TruffleBoundary
    public boolean contains(Object element) {
        return this.rrbt.contains(element);
    }

    @CompilerDirectives.TruffleBoundary
    public long indexOf(Object elem) {
        return this.rrbt.indexOf(elem);
    }

    @CompilerDirectives.TruffleBoundary
    public Object indexOfOrNull(Object elem) {
        long result = this.rrbt.indexOf(elem);
        if (result == -1L) {
            return VmNull.withoutDefault();
        }
        return result;
    }

    @CompilerDirectives.TruffleBoundary
    public long lastIndexOf(Object elem) {
        return this.rrbt.lastIndexOf(elem);
    }

    @CompilerDirectives.TruffleBoundary
    public Object lastIndexOfOrNull(Object elem) {
        long result = this.rrbt.lastIndexOf(elem);
        if (result == -1L) {
            return VmNull.withoutDefault();
        }
        return result;
    }

    @CompilerDirectives.TruffleBoundary
    public VmPair split(long index) {
        Tuple2<RrbTree.ImRrbt<Object>, RrbTree.ImRrbt<Object>> tuple = this.rrbt.split((int)index);
        return new VmPair(VmList.create(tuple._1()), VmList.create(tuple._2()));
    }

    @CompilerDirectives.TruffleBoundary
    public Object splitOrNull(long index) {
        if (index < 0L || index > (long)this.getLength()) {
            return VmNull.withoutDefault();
        }
        return this.split(index);
    }

    @CompilerDirectives.TruffleBoundary
    public VmList take(long n) {
        if (n == 0L) {
            return EMPTY;
        }
        if (n >= (long)this.rrbt.size()) {
            return this;
        }
        VmList.checkPositive(n);
        return VmList.create(this.rrbt.take(n));
    }

    @CompilerDirectives.TruffleBoundary
    public VmList takeLast(long n) {
        if (n == 0L) {
            return EMPTY;
        }
        if (n >= (long)this.rrbt.size()) {
            return this;
        }
        VmList.checkPositive(n);
        return VmList.create(this.rrbt.drop((long)this.rrbt.size() - n));
    }

    @CompilerDirectives.TruffleBoundary
    public VmList drop(long n) {
        if (n == 0L) {
            return this;
        }
        if (n >= (long)this.rrbt.size()) {
            return EMPTY;
        }
        VmList.checkPositive(n);
        return VmList.create(this.rrbt.drop(n));
    }

    @CompilerDirectives.TruffleBoundary
    public VmList dropLast(long n) {
        if (n == 0L) {
            return this;
        }
        if (n >= (long)this.rrbt.size()) {
            return EMPTY;
        }
        VmList.checkPositive(n);
        return VmList.create(this.rrbt.take((long)this.rrbt.size() - n));
    }

    @CompilerDirectives.TruffleBoundary
    public VmList repeat(long n) {
        if (n == 0L) {
            return EMPTY;
        }
        if (n == 1L) {
            return this;
        }
        VmList.checkPositive(n);
        BaseList result = this.rrbt.mutable();
        int i = 1;
        while ((long)i < n) {
            result = ((RrbTree.MutRrbt)result).concat(this.rrbt);
            ++i;
        }
        return VmList.create(result);
    }

    @CompilerDirectives.TruffleBoundary
    public VmList reverse() {
        return VmList.create(this.rrbt.reverse());
    }

    @CompilerDirectives.TruffleBoundary
    public Object[] toArray() {
        return this.rrbt.toArray();
    }

    public VmList toList() {
        return this;
    }

    @CompilerDirectives.TruffleBoundary
    public VmSet toSet() {
        if (this.rrbt.isEmpty()) {
            return VmSet.EMPTY;
        }
        return VmSet.create(this.rrbt);
    }

    @CompilerDirectives.TruffleBoundary
    public VmListing toListing() {
        VmObjectBuilder builder = new VmObjectBuilder(this.rrbt.size());
        for (Object e2 : this.rrbt) {
            builder.addElement(e2);
        }
        return builder.toListing();
    }

    @CompilerDirectives.TruffleBoundary
    public VmDynamic toDynamic() {
        VmObjectBuilder builder = new VmObjectBuilder(this.rrbt.size());
        for (Object e2 : this.rrbt) {
            builder.addElement(e2);
        }
        return builder.toDynamic();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public void force(boolean allowUndefinedValues) {
        if (this.forced) {
            return;
        }
        this.forced = true;
        try {
            for (Object e2 : this.rrbt) {
                VmValue.force(e2, allowUndefinedValues);
            }
        }
        catch (Throwable t) {
            this.forced = false;
            throw t;
        }
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public List<Object> export() {
        ArrayList<Object> result = new ArrayList<Object>(this.rrbt.size());
        for (Object e2 : this.rrbt) {
            result.add(VmValue.export(e2));
        }
        return result;
    }

    @Override
    public void accept(VmValueVisitor visitor) {
        visitor.visitList(this);
    }

    @Override
    public <T> T accept(VmValueConverter<T> converter, Iterable<Object> path) {
        return converter.convertList(this, path);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof VmList)) {
            return false;
        }
        VmList list = (VmList)other;
        return this.rrbt.equals(list.rrbt);
    }

    @CompilerDirectives.TruffleBoundary
    public int hashCode() {
        return this.rrbt.hashCode();
    }

    private static final class Builder
    implements VmCollection.Builder<VmList> {
        private final RrbTree.MutRrbt<Object> list = RrbTree.emptyMutable();

        private Builder() {
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void add(Object element) {
            this.list.append(element);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void addAll(Iterable<?> elements) {
            this.list.concat((Iterable)elements);
        }

        @Override
        public VmList build() {
            return VmList.create(this.list);
        }
    }
}

