/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.runtime;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.pkl.core.ast.ConstantNode;
import org.pkl.core.ast.ExpressionNode;
import org.pkl.core.runtime.BaseModule;
import org.pkl.core.runtime.Identifier;
import org.pkl.core.runtime.Iterators;
import org.pkl.core.runtime.VmClass;
import org.pkl.core.runtime.VmCollection;
import org.pkl.core.runtime.VmDynamic;
import org.pkl.core.runtime.VmList;
import org.pkl.core.runtime.VmMapping;
import org.pkl.core.runtime.VmNull;
import org.pkl.core.runtime.VmObjectBuilder;
import org.pkl.core.runtime.VmPair;
import org.pkl.core.runtime.VmSet;
import org.pkl.core.runtime.VmUtils;
import org.pkl.core.runtime.VmValue;
import org.pkl.core.runtime.VmValueConverter;
import org.pkl.core.runtime.VmValueRenderer;
import org.pkl.core.runtime.VmValueVisitor;
import org.pkl.core.util.CollectionUtils;
import org.pkl.core.util.Nullable;
import org.pkl.thirdparty.paguro.collections.ImMap;
import org.pkl.thirdparty.paguro.collections.ImSet;
import org.pkl.thirdparty.paguro.collections.MutList;
import org.pkl.thirdparty.paguro.collections.MutMap;
import org.pkl.thirdparty.paguro.collections.PersistentHashMap;
import org.pkl.thirdparty.paguro.collections.RrbTree;
import org.pkl.thirdparty.paguro.collections.UnmodMap;
import org.pkl.thirdparty.truffle.api.CompilerDirectives;

public final class VmMap
extends VmValue
implements Iterable<Map.Entry<Object, Object>> {
    public static final VmMap EMPTY = new VmMap(PersistentHashMap.empty(), RrbTree.empty());
    private final ImMap<Object, Object> map;
    private final RrbTree.ImRrbt<Object> keyOrder;
    private boolean forced;

    @CompilerDirectives.TruffleBoundary
    private VmMap(ImMap<Object, Object> map2, RrbTree.ImRrbt<Object> keyOrder) {
        assert (map2.size() == keyOrder.size());
        assert (map2.keySet().equals(keyOrder.toImSet()));
        this.map = map2;
        this.keyOrder = keyOrder;
    }

    @CompilerDirectives.TruffleBoundary
    public static VmMap create(ImMap<Object, Object> map2, RrbTree.ImRrbt<Object> keyOrder) {
        if (map2.isEmpty()) {
            return EMPTY;
        }
        return new VmMap(map2, keyOrder);
    }

    @CompilerDirectives.TruffleBoundary
    public static VmMap createFromConstantNodes(ExpressionNode[] constantNodes) {
        Builder builder = new Builder();
        for (int i = 0; i < constantNodes.length; i += 2) {
            ExpressionNode key2 = constantNodes[i];
            ExpressionNode value2 = constantNodes[i + 1];
            assert (key2 instanceof ConstantNode);
            assert (value2 instanceof ConstantNode);
            builder.add(((ConstantNode)((Object)key2)).getValue(), ((ConstantNode)((Object)value2)).getValue());
        }
        return builder.build();
    }

    @CompilerDirectives.TruffleBoundary
    public static Builder builder(VmMap map2) {
        return new Builder(map2);
    }

    @CompilerDirectives.TruffleBoundary
    public static Builder builder() {
        return new Builder();
    }

    @Override
    public VmClass getVmClass() {
        return BaseModule.getMapClass();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public Iterator<Map.Entry<Object, Object>> iterator() {
        if (this.keyOrder.isEmpty()) {
            return Iterators.emptyTruffleIterator();
        }
        return new Iterator<Map.Entry<Object, Object>>(){
            final Iterator<Object> keyIterator;
            {
                this.keyIterator = VmMap.this.keyOrder.iterator();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean hasNext() {
                return this.keyIterator.hasNext();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Map.Entry<Object, Object> next() {
                Object key2 = this.keyIterator.next();
                Object value2 = VmMap.this.map.get(key2);
                assert (value2 != null);
                return Map.entry(key2, value2);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void remove() {
                throw new UnsupportedOperationException("remove");
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void forEachRemaining(Consumer<? super Map.Entry<Object, Object>> action) {
                throw new UnsupportedOperationException("forEachRemaining");
            }
        };
    }

    @CompilerDirectives.TruffleBoundary
    @Nullable
    public Object getOrNull(Object key2) {
        return this.map.get(key2);
    }

    @CompilerDirectives.TruffleBoundary
    public Object getOrVmNull(Object key2) {
        Object result = this.map.get(key2);
        return result != null ? result : VmNull.withoutDefault();
    }

    @CompilerDirectives.TruffleBoundary
    public int getLength() {
        return this.keyOrder.size();
    }

    @CompilerDirectives.TruffleBoundary
    public boolean isEmpty() {
        return this.keyOrder.isEmpty();
    }

    @CompilerDirectives.TruffleBoundary
    public VmMap concatenate(VmMap other) {
        if (other.isEmpty()) {
            return this;
        }
        MutMap<Object, Object> mapBuilder = this.map.mutable();
        MutList keyOrderBuilder = this.keyOrder.mutable();
        for (Object e2 : other.keyOrder) {
            Object value2 = other.map.get(e2);
            if (!this.map.containsKey(e2)) {
                ((RrbTree.MutRrbt)keyOrderBuilder).append(e2);
            }
            mapBuilder.assoc(e2, value2);
        }
        return VmMap.create(mapBuilder.immutable(), (RrbTree.ImRrbt<Object>)((RrbTree.MutRrbt)keyOrderBuilder).immutable());
    }

    @CompilerDirectives.TruffleBoundary
    public boolean containsKey(Object key2) {
        return this.map.containsKey(key2);
    }

    @CompilerDirectives.TruffleBoundary
    public boolean containsValue(Object value2) {
        return this.map.containsValue(value2);
    }

    @CompilerDirectives.TruffleBoundary
    public VmMap put(Object key2, Object value2) {
        RrbTree.ImRrbt<Object> newKeyOrder = this.map.containsKey(key2) ? this.keyOrder : this.keyOrder.append(key2);
        return new VmMap((ImMap<Object, Object>)this.map.assoc(key2, value2), newKeyOrder);
    }

    @CompilerDirectives.TruffleBoundary
    public VmMap remove(Object key2) {
        if (!this.map.containsKey(key2)) {
            return this;
        }
        return new VmMap((ImMap<Object, Object>)this.map.without(key2), (RrbTree.ImRrbt<Object>)this.keyOrder.without(this.keyOrder.indexOf(key2)));
    }

    @CompilerDirectives.TruffleBoundary
    public VmSet keys() {
        return VmSet.create((ImSet<Object>)this.map.keySet(), this.keyOrder);
    }

    @CompilerDirectives.TruffleBoundary
    public VmList values() {
        VmCollection.Builder<VmList> builder = VmList.EMPTY.builder();
        for (Object e2 : this.keyOrder) {
            Object value2 = this.map.get(e2);
            assert (value2 != null);
            builder.add(value2);
        }
        return builder.build();
    }

    @CompilerDirectives.TruffleBoundary
    public VmList entries() {
        VmCollection.Builder<VmList> builder = VmList.EMPTY.builder();
        for (Object e2 : this.keyOrder) {
            Object value2 = this.map.get(e2);
            assert (value2 != null);
            builder.add(new VmPair(e2, value2));
        }
        return builder.build();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public void force(boolean allowUndefinedValues) {
        if (this.forced) {
            return;
        }
        this.forced = true;
        try {
            for (UnmodMap.UnEntry unEntry : this.map) {
                VmValue.force(unEntry.getKey(), allowUndefinedValues);
                VmValue.force(unEntry.getValue(), allowUndefinedValues);
            }
        }
        catch (Throwable t) {
            this.forced = false;
            throw t;
        }
    }

    public VmMapping toMapping() {
        VmObjectBuilder builder = new VmObjectBuilder(this.getLength());
        for (Map.Entry<Object, Object> entry : this) {
            builder.addEntry(VmUtils.getKey(entry), VmUtils.getValue(entry));
        }
        return builder.toMapping();
    }

    public VmDynamic toDynamic() {
        VmObjectBuilder builder = new VmObjectBuilder(this.getLength());
        for (Map.Entry<Object, Object> entry : this) {
            Object key2 = VmUtils.getKey(entry);
            Object value2 = VmUtils.getValue(entry);
            if (key2 instanceof String) {
                builder.addProperty(Identifier.get((String)key2), value2);
                continue;
            }
            builder.addEntry(key2, value2);
        }
        return builder.toDynamic();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public Map<Object, Object> export() {
        LinkedHashMap<Object, Object> result = CollectionUtils.newLinkedHashMap(this.keyOrder.size());
        for (Object e2 : this.keyOrder) {
            Object value2 = this.map.get(e2);
            assert (value2 != null);
            result.put(VmValue.export(e2), VmValue.export(value2));
        }
        return result;
    }

    @Override
    public void accept(VmValueVisitor visitor) {
        visitor.visitMap(this);
    }

    @Override
    public <T> T accept(VmValueConverter<T> converter, Iterable<Object> path) {
        return converter.convertMap(this, path);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof VmMap)) {
            return false;
        }
        VmMap vmMap = (VmMap)other;
        return this.map.equals(vmMap.map);
    }

    @CompilerDirectives.TruffleBoundary
    public int hashCode() {
        return this.map.hashCode();
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        return VmValueRenderer.singleLine(Integer.MAX_VALUE).render(this);
    }

    public static final class Builder {
        private final MutMap<Object, Object> mapBuilder;
        private final RrbTree.MutRrbt<Object> keyOrderBuilder;

        @CompilerDirectives.TruffleBoundary
        private Builder(VmMap map2) {
            this.mapBuilder = map2.map.mutable();
            this.keyOrderBuilder = map2.keyOrder.mutable();
        }

        @CompilerDirectives.TruffleBoundary
        private Builder() {
            this.mapBuilder = PersistentHashMap.emptyMutable();
            this.keyOrderBuilder = RrbTree.emptyMutable();
        }

        @CompilerDirectives.TruffleBoundary
        public void add(Object key2, Object value2) {
            if (!this.mapBuilder.containsKey(key2)) {
                this.keyOrderBuilder.append(key2);
            }
            this.mapBuilder.assoc(key2, value2);
        }

        @CompilerDirectives.TruffleBoundary
        @Nullable
        public Object get(Object key2) {
            return this.mapBuilder.get(key2);
        }

        @CompilerDirectives.TruffleBoundary
        public VmMap build() {
            if (this.mapBuilder.isEmpty()) {
                return EMPTY;
            }
            return VmMap.create(this.mapBuilder.immutable(), (RrbTree.ImRrbt<Object>)this.keyOrderBuilder.immutable());
        }
    }
}

