/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.stdlib.base;

import java.math.RoundingMode;
import java.text.DecimalFormat;
import org.pkl.core.DataSizeUnit;
import org.pkl.core.DurationUnit;
import org.pkl.core.runtime.VmDataSize;
import org.pkl.core.runtime.VmDuration;
import org.pkl.core.runtime.VmException;
import org.pkl.core.runtime.VmSafeMath;
import org.pkl.core.runtime.VmUtils;
import org.pkl.core.stdlib.ExternalMethod0Node;
import org.pkl.core.stdlib.ExternalMethod1Node;
import org.pkl.core.stdlib.ExternalMethod2Node;
import org.pkl.core.stdlib.ExternalPropertyNode;
import org.pkl.core.util.MathUtils;
import org.pkl.thirdparty.truffle.api.CompilerDirectives;
import org.pkl.thirdparty.truffle.api.dsl.Specialization;

public final class FloatNodes {
    private FloatNodes() {
    }

    public static abstract class isBetween
    extends ExternalMethod2Node {
        @Specialization
        protected boolean evalIntInt(double self, long start2, long inclusiveEnd) {
            return self >= (double)start2 && self <= (double)inclusiveEnd;
        }

        @Specialization
        protected boolean evalIntFloat(double self, long start2, double inclusiveEnd) {
            return self >= (double)start2 && self <= inclusiveEnd;
        }

        @Specialization
        protected boolean evalFloatInt(double self, double start2, long inclusiveEnd) {
            return self >= start2 && self <= (double)inclusiveEnd;
        }

        @Specialization
        protected boolean evalFloatFloat(double self, double start2, double inclusiveEnd) {
            return self >= start2 && self <= inclusiveEnd;
        }
    }

    public static abstract class isNonZero
    extends ExternalPropertyNode {
        @Specialization
        protected boolean eval(double self) {
            return self != 0.0;
        }
    }

    public static abstract class isNaN
    extends ExternalPropertyNode {
        @Specialization
        protected boolean eval(double self) {
            return Double.isNaN(self);
        }
    }

    public static abstract class isInfinite
    extends ExternalPropertyNode {
        @Specialization
        protected boolean eval(double self) {
            return Double.isInfinite(self);
        }
    }

    public static abstract class isFinite
    extends ExternalPropertyNode {
        @Specialization
        protected boolean eval(double self) {
            return Double.isFinite(self);
        }
    }

    public static abstract class isPositive
    extends ExternalPropertyNode {
        @Specialization
        protected boolean eval(double self) {
            return self >= 0.0;
        }
    }

    public static abstract class toDataSize
    extends ExternalMethod1Node {
        @Specialization
        protected VmDataSize eval(double self, String str) {
            DataSizeUnit unit2 = DataSizeUnit.parse(str);
            assert (unit2 != null);
            return new VmDataSize(self, unit2);
        }
    }

    public static abstract class toDuration
    extends ExternalMethod1Node {
        @Specialization
        protected VmDuration eval(double self, String str) {
            DurationUnit unit2 = DurationUnit.parse(str);
            assert (unit2 != null);
            return new VmDuration(self, unit2);
        }
    }

    public static abstract class toFixed
    extends ExternalMethod1Node {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        protected String eval(double self, long fractionDigits) {
            assert (fractionDigits >= 0L && fractionDigits <= 20L);
            if (Double.isFinite(self)) {
                DecimalFormat format = VmUtils.createDecimalFormat((int)fractionDigits);
                return format.format(self);
            }
            return Double.toString(self);
        }
    }

    public static abstract class toString
    extends ExternalMethod0Node {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        protected String eval(double self) {
            return Double.toString(self);
        }
    }

    public static abstract class toFloat
    extends ExternalMethod0Node {
        @Specialization
        protected double eval(double self) {
            return self;
        }
    }

    public static abstract class toInt
    extends ExternalMethod0Node {
        @Specialization
        protected long eval(double self) {
            try {
                return MathUtils.roundToLong(self, RoundingMode.DOWN);
            }
            catch (ArithmeticException e2) {
                CompilerDirectives.transferToInterpreter();
                throw this.exceptionBuilder().evalError(Double.isFinite(self) ? "cannotConvertLargeFloat" : "cannotConvertNonFiniteFloat", new VmException.ProgramValue("Float", self)).build();
            }
        }
    }

    public static abstract class truncate
    extends ExternalMethod0Node {
        @Specialization
        protected double eval(double self) {
            return VmSafeMath.truncate(self);
        }
    }

    public static abstract class round
    extends ExternalMethod0Node {
        @Specialization
        protected double eval(double self) {
            return StrictMath.rint(self);
        }
    }

    public static abstract class floor
    extends ExternalPropertyNode {
        @Specialization
        protected double eval(double self) {
            return StrictMath.floor(self);
        }
    }

    public static abstract class ceil
    extends ExternalPropertyNode {
        @Specialization
        protected double eval(double self) {
            return StrictMath.ceil(self);
        }
    }

    public static abstract class abs
    extends ExternalPropertyNode {
        @Specialization
        protected double eval(double self) {
            return StrictMath.abs(self);
        }
    }

    public static abstract class sign
    extends ExternalPropertyNode {
        @Specialization
        protected double eval(double self) {
            return StrictMath.signum(self);
        }
    }

    public static abstract class pib
    extends ExternalPropertyNode {
        @Specialization
        protected VmDataSize eval(double self) {
            return new VmDataSize(self, DataSizeUnit.PEBIBYTES);
        }
    }

    public static abstract class pb
    extends ExternalPropertyNode {
        @Specialization
        protected VmDataSize eval(double self) {
            return new VmDataSize(self, DataSizeUnit.PETABYTES);
        }
    }

    public static abstract class tib
    extends ExternalPropertyNode {
        @Specialization
        protected VmDataSize eval(double self) {
            return new VmDataSize(self, DataSizeUnit.TEBIBYTES);
        }
    }

    public static abstract class tb
    extends ExternalPropertyNode {
        @Specialization
        protected VmDataSize eval(double self) {
            return new VmDataSize(self, DataSizeUnit.TERABYTES);
        }
    }

    public static abstract class gib
    extends ExternalPropertyNode {
        @Specialization
        protected VmDataSize eval(double self) {
            return new VmDataSize(self, DataSizeUnit.GIBIBYTES);
        }
    }

    public static abstract class gb
    extends ExternalPropertyNode {
        @Specialization
        protected VmDataSize eval(double self) {
            return new VmDataSize(self, DataSizeUnit.GIGABYTES);
        }
    }

    public static abstract class mib
    extends ExternalPropertyNode {
        @Specialization
        protected VmDataSize eval(double self) {
            return new VmDataSize(self, DataSizeUnit.MEBIBYTES);
        }
    }

    public static abstract class mb
    extends ExternalPropertyNode {
        @Specialization
        protected VmDataSize eval(double self) {
            return new VmDataSize(self, DataSizeUnit.MEGABYTES);
        }
    }

    public static abstract class kib
    extends ExternalPropertyNode {
        @Specialization
        protected VmDataSize eval(double self) {
            return new VmDataSize(self, DataSizeUnit.KIBIBYTES);
        }
    }

    public static abstract class kb
    extends ExternalPropertyNode {
        @Specialization
        protected VmDataSize eval(double self) {
            return new VmDataSize(self, DataSizeUnit.KILOBYTES);
        }
    }

    public static abstract class b
    extends ExternalPropertyNode {
        @Specialization
        protected VmDataSize eval(double self) {
            return new VmDataSize(self, DataSizeUnit.BYTES);
        }
    }

    public static abstract class d
    extends ExternalPropertyNode {
        @Specialization
        protected VmDuration eval(double self) {
            return new VmDuration(self, DurationUnit.DAYS);
        }
    }

    public static abstract class h
    extends ExternalPropertyNode {
        @Specialization
        protected VmDuration eval(double self) {
            return new VmDuration(self, DurationUnit.HOURS);
        }
    }

    public static abstract class min
    extends ExternalPropertyNode {
        @Specialization
        protected VmDuration eval(double self) {
            return new VmDuration(self, DurationUnit.MINUTES);
        }
    }

    public static abstract class s
    extends ExternalPropertyNode {
        @Specialization
        protected VmDuration eval(double self) {
            return new VmDuration(self, DurationUnit.SECONDS);
        }
    }

    public static abstract class ms
    extends ExternalPropertyNode {
        @Specialization
        protected VmDuration eval(double self) {
            return new VmDuration(self, DurationUnit.MILLIS);
        }
    }

    public static abstract class us
    extends ExternalPropertyNode {
        @Specialization
        protected VmDuration eval(double self) {
            return new VmDuration(self, DurationUnit.MICROS);
        }
    }

    public static abstract class ns
    extends ExternalPropertyNode {
        @Specialization
        protected VmDuration eval(double self) {
            return new VmDuration(self, DurationUnit.NANOS);
        }
    }
}

