/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.stdlib.base;

import java.util.regex.Matcher;
import org.pkl.core.runtime.VmCollection;
import org.pkl.core.runtime.VmList;
import org.pkl.core.runtime.VmNull;
import org.pkl.core.runtime.VmRegex;
import org.pkl.core.runtime.VmValue;
import org.pkl.core.stdlib.ExternalMethod1Node;
import org.pkl.core.stdlib.ExternalPropertyNode;
import org.pkl.core.stdlib.base.RegexMatchFactory;
import org.pkl.core.util.Pair;
import org.pkl.thirdparty.truffle.api.CompilerDirectives;
import org.pkl.thirdparty.truffle.api.dsl.Specialization;

public final class RegexNodes {
    private RegexNodes() {
    }

    public static abstract class matchEntire
    extends ExternalMethod1Node {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        protected VmValue eval(VmRegex self, String str) {
            Matcher matcher = self.getPattern().matcher(str);
            if (!matcher.matches()) {
                return VmNull.withoutDefault();
            }
            return RegexMatchFactory.create(Pair.of(matcher.toMatchResult(), -1));
        }
    }

    public static abstract class findMatchesIn
    extends ExternalMethod1Node {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        protected VmList eval(VmRegex self, String str) {
            Matcher matcher = self.getPattern().matcher(str);
            VmCollection.Builder<VmList> builder = VmList.EMPTY.builder();
            while (matcher.find()) {
                builder.add(RegexMatchFactory.create(Pair.of(matcher.toMatchResult(), -1)));
            }
            return builder.build();
        }
    }

    public static abstract class groupCount
    extends ExternalPropertyNode {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        protected long eval(VmRegex self) {
            return self.getPattern().matcher("").groupCount();
        }
    }

    public static abstract class pattern
    extends ExternalPropertyNode {
        @Specialization
        protected String eval(VmRegex self) {
            return self.getPattern().pattern();
        }
    }
}

