/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.stdlib.benchmark;

import org.pkl.core.ast.ExpressionNode;
import org.pkl.core.ast.MemberNode;
import org.pkl.core.ast.PklRootNode;
import org.pkl.core.ast.internal.BlackholeNode;
import org.pkl.core.ast.internal.BlackholeNodeGen;
import org.pkl.core.ast.member.ObjectMember;
import org.pkl.core.runtime.Identifier;
import org.pkl.core.runtime.VmException;
import org.pkl.core.runtime.VmLanguage;
import org.pkl.core.runtime.VmTyped;
import org.pkl.core.runtime.VmUtils;
import org.pkl.core.stdlib.ExternalMethod0Node;
import org.pkl.core.stdlib.benchmark.BenchmarkUtils;
import org.pkl.core.util.Nullable;
import org.pkl.thirdparty.truffle.api.CompilerDirectives;
import org.pkl.thirdparty.truffle.api.RootCallTarget;
import org.pkl.thirdparty.truffle.api.dsl.Specialization;
import org.pkl.thirdparty.truffle.api.frame.FrameDescriptor;
import org.pkl.thirdparty.truffle.api.frame.VirtualFrame;
import org.pkl.thirdparty.truffle.api.nodes.LoopNode;
import org.pkl.thirdparty.truffle.api.nodes.Node;
import org.pkl.thirdparty.truffle.api.source.SourceSection;

public final class MicrobenchmarkNodes {

    public static final class RunIterationsNode
    extends PklRootNode {
        @Node.Child
        private BlackholeNode blackholeNode;

        public RunIterationsNode(VmLanguage language, FrameDescriptor descriptor, ExpressionNode iterationNode) {
            super(language, descriptor);
            this.blackholeNode = BlackholeNodeGen.create(iterationNode);
        }

        @Override
        public boolean isInternal() {
            return true;
        }

        @Override
        public SourceSection getSourceSection() {
            return VmUtils.unavailableSourceSection();
        }

        @Override
        @Nullable
        public String getName() {
            return null;
        }

        @Override
        @Nullable
        public Object execute(VirtualFrame frame) {
            try {
                long repetitions = (Long)frame.getArguments()[2];
                for (long i = 0L; i < repetitions; ++i) {
                    this.blackholeNode.executeGeneric(frame);
                }
                LoopNode.reportLoopCount(this, repetitions > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)repetitions);
                return null;
            }
            catch (Exception e2) {
                CompilerDirectives.transferToInterpreter();
                if (e2 instanceof VmException) {
                    throw e2;
                }
                throw this.exceptionBuilder().bug(e2.getMessage(), new Object[0]).withCause(e2).build();
            }
        }
    }

    public static abstract class run
    extends ExternalMethod0Node {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        protected VmTyped eval(VmTyped self) {
            ObjectMember codeMember = VmUtils.findMember(self, Identifier.EXPRESSION);
            assert (codeMember != null);
            MemberNode codeMemberNode = codeMember.getMemberNode();
            if (codeMemberNode == null) {
                throw this.exceptionBuilder().evalError("constantMicrobenchmark", new Object[0]).build();
            }
            RunIterationsNode runIterationsNode = new RunIterationsNode(VmLanguage.get(this), new FrameDescriptor(), (ExpressionNode)codeMemberNode.getBodyNode().deepCopy());
            RootCallTarget callTarget = runIterationsNode.getCallTarget();
            return BenchmarkUtils.runBenchmark(self, iterations -> callTarget.call(self, self, iterations));
        }
    }
}

