/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.stdlib.json;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import org.pkl.core.ast.member.ObjectMember;
import org.pkl.core.runtime.BaseModule;
import org.pkl.core.runtime.Identifier;
import org.pkl.core.runtime.VmDynamic;
import org.pkl.core.runtime.VmListing;
import org.pkl.core.runtime.VmMapping;
import org.pkl.core.runtime.VmNull;
import org.pkl.core.runtime.VmObject;
import org.pkl.core.runtime.VmTyped;
import org.pkl.core.runtime.VmUtils;
import org.pkl.core.runtime.VmValueConverter;
import org.pkl.core.stdlib.ExternalMethod1Node;
import org.pkl.core.stdlib.PklConverter;
import org.pkl.core.util.EconomicMaps;
import org.pkl.core.util.Nullable;
import org.pkl.core.util.json.JsonHandler;
import org.pkl.core.util.json.JsonParser;
import org.pkl.core.util.json.ParseException;
import org.pkl.thirdparty.graalvm.collections.EconomicMap;
import org.pkl.thirdparty.truffle.api.CompilerDirectives;
import org.pkl.thirdparty.truffle.api.dsl.Cached;
import org.pkl.thirdparty.truffle.api.dsl.Specialization;
import org.pkl.thirdparty.truffle.api.nodes.IndirectCallNode;

public final class ParserNodes {
    private ParserNodes() {
    }

    private static PklConverter createConverter(VmTyped self) {
        VmMapping converters = (VmMapping)VmUtils.readMember(self, Identifier.CONVERTERS);
        return new PklConverter(converters);
    }

    private static class Handler
    extends JsonHandler<EconomicMap<Object, ObjectMember>, EconomicMap<Object, ObjectMember>> {
        private final PklConverter converter;
        private final boolean useMapping;
        private final Deque<Object> currPath = new ArrayDeque<Object>();
        private Object value;

        public Handler(PklConverter converter, boolean useMapping) {
            this.converter = converter;
            this.useMapping = useMapping;
            this.currPath.push(VmValueConverter.TOP_LEVEL_VALUE);
        }

        @Override
        public void endNull() {
            this.value = VmNull.withoutDefault();
        }

        @Override
        public void endBoolean(boolean value2) {
            this.value = value2;
        }

        @Override
        public void endString(String string) {
            this.value = string;
        }

        @Override
        public void endNumber(String string) {
            try {
                this.value = Long.valueOf(string);
            }
            catch (NumberFormatException e2) {
                try {
                    this.value = Double.valueOf(string);
                }
                catch (NumberFormatException e22) {
                    throw new ParseException("Cannot parse `" + string + "` as number.", this.getLocation());
                }
            }
        }

        @Override
        public EconomicMap<Object, ObjectMember> startArray() {
            this.currPath.push(VmValueConverter.WILDCARD_ELEMENT);
            return EconomicMaps.create();
        }

        @Override
        public void endArray(@Nullable EconomicMap<Object, ObjectMember> members) {
            assert (members != null);
            this.value = new VmListing(VmUtils.createEmptyMaterializedFrame(), (VmObject)BaseModule.getListingClass().getPrototype(), members, EconomicMaps.size(members));
            this.currPath.pop();
        }

        @Override
        public void endArrayValue(@Nullable EconomicMap<Object, ObjectMember> members) {
            assert (members != null);
            int size = EconomicMaps.size(members);
            ObjectMember member = new ObjectMember(VmUtils.unavailableSourceSection(), VmUtils.unavailableSourceSection(), 2048, null, String.valueOf(size));
            member.initConstantValue(this.converter.convert(this.value, this.currPath));
            EconomicMaps.put(members, Long.valueOf(size), member);
        }

        @Override
        public EconomicMap<Object, ObjectMember> startObject() {
            return EconomicMaps.create();
        }

        @Override
        public void endObject(@Nullable EconomicMap<Object, ObjectMember> members) {
            assert (members != null);
            this.value = this.useMapping ? new VmMapping(VmUtils.createEmptyMaterializedFrame(), BaseModule.getMappingClass().getPrototype(), members) : new VmDynamic(VmUtils.createEmptyMaterializedFrame(), (VmObject)BaseModule.getDynamicClass().getPrototype(), members, 0);
        }

        @Override
        public void startObjectValue(@Nullable EconomicMap<Object, ObjectMember> members, String name) {
            this.currPath.push(Identifier.get(name));
        }

        @Override
        public void endObjectValue(@Nullable EconomicMap<Object, ObjectMember> members, String name) {
            assert (members != null);
            Object memberName = this.useMapping ? name : Identifier.get(name);
            ObjectMember member = new ObjectMember(VmUtils.unavailableSourceSection(), VmUtils.unavailableSourceSection(), this.useMapping ? 1024 : 0, this.useMapping ? null : (Identifier)memberName, "generated");
            member.initConstantValue(this.converter.convert(this.value, this.currPath));
            EconomicMaps.put(members, memberName, member);
            this.currPath.pop();
        }
    }

    public static abstract class parse
    extends ExternalMethod1Node {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        protected Object eval(VmTyped self, String text) {
            return this.doParse(self, text);
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        protected Object eval(VmTyped self, VmTyped resource, @Cached(value="create()") IndirectCallNode callNode) {
            String text = (String)VmUtils.readMember(resource, Identifier.TEXT, callNode);
            return this.doParse(self, text);
        }

        private Object doParse(VmTyped self, String text) {
            PklConverter converter = ParserNodes.createConverter(self);
            boolean useMapping = (Boolean)VmUtils.readMember(self, Identifier.USE_MAPPING);
            Handler handler = new Handler(converter, useMapping);
            JsonParser parser = new JsonParser(handler);
            try {
                parser.parse(text);
            }
            catch (ParseException e2) {
                throw this.exceptionBuilder().evalError("jsonParseError", new Object[0]).withHint(e2.getMessage()).build();
            }
            return converter.convert(handler.value, List.of(VmValueConverter.TOP_LEVEL_VALUE));
        }
    }
}

