/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.stdlib.registry;

import org.pkl.core.module.ModuleKey;
import org.pkl.core.module.ModuleKeys;
import org.pkl.core.stdlib.registry.BaseMemberRegistry;
import org.pkl.core.stdlib.registry.BenchmarkMemberRegistry;
import org.pkl.core.stdlib.registry.EmptyMemberRegistry;
import org.pkl.core.stdlib.registry.ExternalMemberRegistry;
import org.pkl.core.stdlib.registry.JsonMemberRegistry;
import org.pkl.core.stdlib.registry.JsonnetMemberRegistry;
import org.pkl.core.stdlib.registry.MathMemberRegistry;
import org.pkl.core.stdlib.registry.PlatformMemberRegistry;
import org.pkl.core.stdlib.registry.ProtobufMemberRegistry;
import org.pkl.core.stdlib.registry.ReflectMemberRegistry;
import org.pkl.core.stdlib.registry.ReleaseMemberRegistry;
import org.pkl.core.stdlib.registry.TestMemberRegistry;
import org.pkl.core.stdlib.registry.XmlMemberRegistry;
import org.pkl.core.stdlib.registry.YamlMemberRegistry;

public final class MemberRegistryFactory {
    private MemberRegistryFactory() {
    }

    public static ExternalMemberRegistry get(ModuleKey moduleKey) {
        if (!ModuleKeys.isStdLibModule(moduleKey)) {
            return EmptyMemberRegistry.INSTANCE;
        }
        switch (moduleKey.getUri().getSchemeSpecificPart()) {
            case "base": {
                return new BaseMemberRegistry();
            }
            case "reflect": {
                return new ReflectMemberRegistry();
            }
            case "math": {
                return new MathMemberRegistry();
            }
            case "Benchmark": {
                return new BenchmarkMemberRegistry();
            }
            case "yaml": {
                return new YamlMemberRegistry();
            }
            case "json": {
                return new JsonMemberRegistry();
            }
            case "platform": {
                return new PlatformMemberRegistry();
            }
            case "release": {
                return new ReleaseMemberRegistry();
            }
            case "jsonnet": {
                return new JsonnetMemberRegistry();
            }
            case "protobuf": {
                return new ProtobufMemberRegistry();
            }
            case "xml": {
                return new XmlMemberRegistry();
            }
            case "test": {
                return new TestMemberRegistry();
            }
        }
        return EmptyMemberRegistry.INSTANCE;
    }
}

