/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.util;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.stream.Collectors;

public final class ErrorMessages {
    private ErrorMessages() {
    }

    public static String create(String messageName, Object ... args) {
        Locale locale = Locale.getDefault();
        String errorMessage = ResourceBundle.getBundle("org.pkl.core.errorMessages", locale).getString(messageName);
        if (args.length == 0) {
            return errorMessage;
        }
        MessageFormat formatter = new MessageFormat(errorMessage, locale);
        return formatter.format(args);
    }

    public static String createIndented(String messageName, String indent, Object ... args) {
        return ErrorMessages.create(messageName, args).lines().map(msg -> indent + msg).collect(Collectors.joining("\n"));
    }
}

