/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.util.xml;

import java.util.Arrays;
import org.pkl.core.util.xml.XmlValidator;

final class Xml11Validator
extends XmlValidator {
    private static final byte[] CHARS = new byte[65536];
    private static final int MASK_NAME_START = 4;
    private static final int MASK_NAME = 8;

    Xml11Validator() {
    }

    @Override
    public boolean isValidName(String name) {
        char ch2;
        int length2 = name.length();
        if (length2 == 0) {
            return false;
        }
        int i = 1;
        char ch = name.charAt(0);
        if (!Xml11Validator.isNameStart(ch)) {
            if (length2 > 1 && Xml11Validator.isHighSurrogate(ch)) {
                ch2 = name.charAt(1);
                if (!Xml11Validator.isLowSurrogate(ch2) || !Xml11Validator.isNameStart(Xml11Validator.supplemental(ch, ch2))) {
                    return false;
                }
                i = 2;
            } else {
                return false;
            }
        }
        while (i < length2) {
            ch = name.charAt(i);
            if (!Xml11Validator.isName(ch)) {
                if (++i < length2 && Xml11Validator.isHighSurrogate(ch)) {
                    ch2 = name.charAt(i);
                    if (!Xml11Validator.isLowSurrogate(ch2) || !Xml11Validator.isName(Xml11Validator.supplemental(ch, ch2))) {
                        return false;
                    }
                } else {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    private static boolean isNameStart(int c) {
        return c < 65536 && (CHARS[c] & 4) != 0 || 65536 <= c && c < 983040;
    }

    private static boolean isName(int c) {
        return c < 65536 && (CHARS[c] & 8) != 0 || c >= 65536 && c < 983040;
    }

    private static boolean isHighSurrogate(int c) {
        return 55296 <= c && c <= 56191;
    }

    private static boolean isLowSurrogate(int c) {
        return 56320 <= c && c <= 57343;
    }

    private static int supplemental(char h2, char l) {
        return (h2 - 55296) * 1024 + (l - 56320) + 65536;
    }

    static {
        Arrays.fill(CHARS, 1, 9, (byte)17);
        Xml11Validator.CHARS[9] = 35;
        Xml11Validator.CHARS[10] = 3;
        Arrays.fill(CHARS, 11, 13, (byte)17);
        Xml11Validator.CHARS[13] = 3;
        Arrays.fill(CHARS, 14, 32, (byte)17);
        Xml11Validator.CHARS[32] = 35;
        Arrays.fill(CHARS, 33, 38, (byte)33);
        Xml11Validator.CHARS[38] = 1;
        Arrays.fill(CHARS, 39, 45, (byte)33);
        Arrays.fill(CHARS, 45, 47, (byte)-87);
        Xml11Validator.CHARS[47] = 33;
        Arrays.fill(CHARS, 48, 58, (byte)-87);
        Xml11Validator.CHARS[58] = 45;
        Xml11Validator.CHARS[59] = 33;
        Xml11Validator.CHARS[60] = 1;
        Arrays.fill(CHARS, 61, 65, (byte)33);
        Arrays.fill(CHARS, 65, 91, (byte)-19);
        Arrays.fill(CHARS, 91, 93, (byte)33);
        Xml11Validator.CHARS[93] = 1;
        Xml11Validator.CHARS[94] = 33;
        Xml11Validator.CHARS[95] = -19;
        Xml11Validator.CHARS[96] = 33;
        Arrays.fill(CHARS, 97, 123, (byte)-19);
        Arrays.fill(CHARS, 123, 127, (byte)33);
        Arrays.fill(CHARS, 127, 133, (byte)17);
        Xml11Validator.CHARS[133] = 35;
        Arrays.fill(CHARS, 134, 160, (byte)17);
        Arrays.fill(CHARS, 160, 183, (byte)33);
        Xml11Validator.CHARS[183] = -87;
        Arrays.fill(CHARS, 184, 192, (byte)33);
        Arrays.fill(CHARS, 192, 215, (byte)-19);
        Xml11Validator.CHARS[215] = 33;
        Arrays.fill(CHARS, 216, 247, (byte)-19);
        Xml11Validator.CHARS[247] = 33;
        Arrays.fill(CHARS, 248, 768, (byte)-19);
        Arrays.fill(CHARS, 768, 880, (byte)-87);
        Arrays.fill(CHARS, 880, 894, (byte)-19);
        Xml11Validator.CHARS[894] = 33;
        Arrays.fill(CHARS, 895, 8192, (byte)-19);
        Arrays.fill(CHARS, 8192, 8204, (byte)33);
        Arrays.fill(CHARS, 8204, 8206, (byte)-19);
        Arrays.fill(CHARS, 8206, 8232, (byte)33);
        Xml11Validator.CHARS[8232] = 35;
        Arrays.fill(CHARS, 8233, 8255, (byte)33);
        Arrays.fill(CHARS, 8255, 8257, (byte)-87);
        Arrays.fill(CHARS, 8257, 8304, (byte)33);
        Arrays.fill(CHARS, 8304, 8592, (byte)-19);
        Arrays.fill(CHARS, 8592, 11264, (byte)33);
        Arrays.fill(CHARS, 11264, 12272, (byte)-19);
        Arrays.fill(CHARS, 12272, 12289, (byte)33);
        Arrays.fill(CHARS, 12289, 55296, (byte)-19);
        Arrays.fill(CHARS, 57344, 63744, (byte)33);
        Arrays.fill(CHARS, 63744, 64976, (byte)-19);
        Arrays.fill(CHARS, 64976, 65008, (byte)33);
        Arrays.fill(CHARS, 65008, 65534, (byte)-19);
    }
}

