/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.util.yaml;

import org.pkl.core.util.AbstractCharEscaper;
import org.pkl.core.util.IoUtils;
import org.pkl.core.util.Nullable;

public final class YamlEscaper
extends AbstractCharEscaper {
    private static final String[] REPLACEMENTS = new String[35];

    @Override
    @Nullable
    protected String findReplacement(char ch) {
        return ch <= '\"' ? REPLACEMENTS[ch] : (ch == '\u2028' ? "\\L" : (ch == '\u2029' ? "\\P" : null));
    }

    static {
        for (int i = 0; i < 32; ++i) {
            YamlEscaper.REPLACEMENTS[i] = IoUtils.toHexEscape(i);
        }
        YamlEscaper.REPLACEMENTS[0] = "\\0";
        YamlEscaper.REPLACEMENTS[7] = "\\a";
        YamlEscaper.REPLACEMENTS[8] = "\\b";
        YamlEscaper.REPLACEMENTS[9] = "\\t";
        YamlEscaper.REPLACEMENTS[10] = "\\n";
        YamlEscaper.REPLACEMENTS[11] = "\\v";
        YamlEscaper.REPLACEMENTS[12] = "\\f";
        YamlEscaper.REPLACEMENTS[13] = "\\r";
        YamlEscaper.REPLACEMENTS[27] = "\\e";
        YamlEscaper.REPLACEMENTS[34] = "\\\"";
    }
}

