/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.paguro.collections;

import java.util.Collection;
import java.util.ListIterator;
import org.pkl.thirdparty.jetbrains.annotations.Contract;
import org.pkl.thirdparty.jetbrains.annotations.NotNull;
import org.pkl.thirdparty.jetbrains.annotations.Nullable;
import org.pkl.thirdparty.paguro.collections.BaseList;
import org.pkl.thirdparty.paguro.collections.ImList;
import org.pkl.thirdparty.paguro.collections.PersistentVector;
import org.pkl.thirdparty.paguro.function.Fn0;
import org.pkl.thirdparty.paguro.oneOf.Option;

public interface MutList<E>
extends BaseList<E> {
    @Override
    @Contract(mutates="this")
    @NotNull
    public MutList<E> append(E var1);

    @Override
    @Contract(mutates="this")
    @NotNull
    default public MutList<E> appendSome(@NotNull @NotNull Fn0<? extends @NotNull Option<E>> supplier) {
        return supplier.apply().match(it -> this.append(it), () -> this);
    }

    @Override
    @Contract(mutates="this")
    default public boolean add(E val) {
        this.append((Object)val);
        return true;
    }

    @Override
    @Contract(mutates="this")
    default public boolean addAll(@NotNull Collection<? extends E> c) {
        this.concat(c);
        return true;
    }

    public ImList<E> immutable();

    @Override
    @Contract(mutates="this")
    @NotNull
    default public MutList<E> concat(@Nullable Iterable<? extends E> es) {
        if (es != null) {
            for (E e2 : es) {
                this.append((Object)e2);
            }
        }
        return this;
    }

    @Override
    @Contract(mutates="this")
    @NotNull
    public MutList<E> replace(int var1, E var2);

    @Override
    @Contract(mutates="this")
    @NotNull
    default public MutList<E> reverse() {
        PersistentVector.MutVector ret = PersistentVector.emptyMutable();
        ListIterator iter = this.listIterator(this.size());
        while (iter.hasPrevious()) {
            ret.append(iter.previous());
        }
        return ret;
    }
}

