/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.paguro.collections;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicReference;
import org.pkl.thirdparty.jetbrains.annotations.Contract;
import org.pkl.thirdparty.jetbrains.annotations.NotNull;
import org.pkl.thirdparty.jetbrains.annotations.Nullable;
import org.pkl.thirdparty.paguro.collections.ImList;
import org.pkl.thirdparty.paguro.collections.MutList;
import org.pkl.thirdparty.paguro.collections.UnmodList;
import org.pkl.thirdparty.paguro.collections.UnmodListIterator;
import org.pkl.thirdparty.paguro.function.Fn0;
import org.pkl.thirdparty.paguro.oneOf.Option;

public class PersistentVector<E>
extends UnmodList.AbstractUnmodList<E>
implements ImList<E>,
Serializable {
    private static final int NODE_LENGTH_POW_2 = 5;
    private static final int MAX_NODE_LENGTH = 32;
    private static final int LOW_BITS = 31;
    private static final AtomicReference<Thread> NOEDIT = new AtomicReference<Object>(null);
    private static final Node EMPTY_NODE = new Node(NOEDIT, new Object[32]);
    public static final PersistentVector<?> EMPTY = new PersistentVector<Object>(0, 5, EMPTY_NODE, new Object[0]);
    private final int size;
    private final int shift;
    private final transient Node root;
    private final E[] tail;
    private static final long serialVersionUID = 20160904160500L;

    public static <T> PersistentVector<T> empty() {
        return EMPTY;
    }

    public static <T> MutVector<T> emptyMutable() {
        PersistentVector<T> e2 = PersistentVector.empty();
        return e2.mutable();
    }

    public static <T> PersistentVector<T> ofIter(Iterable<T> items) {
        MutVector<T> ret = PersistentVector.emptyMutable();
        for (T item : items) {
            ret.append((Object)item);
        }
        return ret.immutable();
    }

    private PersistentVector(int z, int shift, Node root, E[] tail) {
        this.size = z;
        this.shift = shift;
        this.root = root;
        this.tail = tail;
    }

    private Object writeReplace() {
        return new SerializationProxy(this);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        throw new InvalidObjectException("Proxy required");
    }

    @Override
    @NotNull
    public MutVector<E> mutable() {
        return new MutVector(this);
    }

    private int tailoff() {
        return this.size < 32 ? 0 : this.size - 1 >>> 5 << 5;
    }

    private E[] leafNodeArrayFor(int i) {
        if (i >= 0 && i < this.size) {
            if (i >= this.tailoff()) {
                return this.tail;
            }
            Node node = this.root;
            for (int level = this.shift; level > 0; level -= 5) {
                node = (Node)node.array[i >>> level & 0x1F];
            }
            return node.array;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public E get(int i) {
        E[] node = this.leafNodeArrayFor(i);
        return node[i & 0x1F];
    }

    @Override
    @NotNull
    public PersistentVector<E> replace(int i, E val) {
        if (i >= 0 && i < this.size) {
            if (i >= this.tailoff()) {
                Object[] newTail = new Object[this.tail.length];
                System.arraycopy(this.tail, 0, newTail, 0, this.tail.length);
                newTail[i & 0x1F] = val;
                return new PersistentVector<Object>(this.size, this.shift, this.root, newTail);
            }
            return new PersistentVector<E>(this.size, this.shift, PersistentVector.doAssoc(this.shift, this.root, i, val), this.tail);
        }
        if (i == this.size) {
            return this.append((Object)val);
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    @NotNull
    public PersistentVector<E> append(E val) {
        Node newroot;
        if (this.size - this.tailoff() < 32) {
            Object[] newTail = new Object[this.tail.length + 1];
            System.arraycopy(this.tail, 0, newTail, 0, this.tail.length);
            newTail[this.tail.length] = val;
            return new PersistentVector<Object>(this.size + 1, this.shift, this.root, newTail);
        }
        Node tailnode = new Node(this.root.edit, this.tail);
        int newshift = this.shift;
        if (this.size >>> 5 > 1 << this.shift) {
            newroot = new Node(this.root.edit);
            newroot.array[0] = this.root;
            newroot.array[1] = PersistentVector.newPath(this.root.edit, this.shift, tailnode);
            newshift += 5;
        } else {
            newroot = this.pushTail(this.shift, this.root, tailnode);
        }
        return new PersistentVector<Object>(this.size + 1, newshift, newroot, new Object[]{val});
    }

    @Override
    @NotNull
    public PersistentVector<E> appendSome(@NotNull @NotNull Fn0<? extends @NotNull Option<E>> supplier) {
        return supplier.apply().match(it -> this.append(it), () -> this);
    }

    @Override
    @NotNull
    public PersistentVector<E> concat(@Nullable Iterable<? extends E> items) {
        return (PersistentVector)ImList.super.concat((Iterable)items);
    }

    private Node pushTail(int level, Node parent, Node tailnode) {
        Node child;
        int subidx = this.size - 1 >>> level & 0x1F;
        Node ret = new Node(parent.edit, (Object[])parent.array.clone());
        Node nodeToInsert = level == 5 ? tailnode : ((child = (Node)parent.array[subidx]) == null ? PersistentVector.newPath(this.root.edit, level - 5, tailnode) : this.pushTail(level - 5, child, tailnode));
        ret.array[subidx] = nodeToInsert;
        return ret;
    }

    @Override
    @NotNull
    public UnmodListIterator<E> listIterator(final int index) {
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }
        return new UnmodListIterator<E>(){
            private int i;
            private int base;
            private E[] array;
            {
                this.i = index;
                this.base = this.i - this.i % 32;
                this.array = index < PersistentVector.this.size() ? PersistentVector.this.leafNodeArrayFor(this.i) : null;
            }

            @Override
            public boolean hasNext() {
                return this.i < PersistentVector.this.size();
            }

            @Override
            public boolean hasPrevious() {
                return this.i > 0;
            }

            @Override
            public E next() {
                if (this.i >= PersistentVector.this.size) {
                    throw new NoSuchElementException();
                }
                if (this.i - this.base == 32) {
                    this.array = PersistentVector.this.leafNodeArrayFor(this.i);
                    this.base += 32;
                }
                return this.array[this.i++ & 0x1F];
            }

            @Override
            public int nextIndex() {
                return this.i;
            }

            @Override
            public E previous() {
                if (this.i < 1) {
                    throw new NoSuchElementException();
                }
                if (this.i - this.base == 0) {
                    this.array = PersistentVector.this.leafNodeArrayFor(this.i - 1);
                    this.base -= 32;
                } else if (this.i == PersistentVector.this.size) {
                    this.array = PersistentVector.this.leafNodeArrayFor(this.i - 1);
                    this.base = this.i - this.i % 32;
                }
                return this.array[--this.i & 0x1F];
            }
        };
    }

    private static Node doAssoc(int level, Node node, int i, Object val) {
        Node ret = new Node(node.edit, (Object[])node.array.clone());
        if (level == 0) {
            ret.array[i & 0x1F] = val;
        } else {
            int subidx = i >>> level & 0x1F;
            ret.array[subidx] = PersistentVector.doAssoc(level - 5, (Node)node.array[subidx], i, val);
        }
        return ret;
    }

    private static Node newPath(AtomicReference<Thread> edit, int level, Node node) {
        if (level == 0) {
            return node;
        }
        Node ret = new Node(edit);
        ret.array[0] = PersistentVector.newPath(edit, level - 5, node);
        return ret;
    }

    public static final class MutVector<F>
    extends UnmodList.AbstractUnmodList<F>
    implements MutList<F> {
        private int size;
        private int shift;
        private Node root;
        private F[] tail;

        private MutVector(int c, int s2, Node r, F[] t) {
            this.size = c;
            this.shift = s2;
            this.root = r;
            this.tail = t;
        }

        private MutVector(PersistentVector<F> v) {
            this(v.size, v.shift, MutVector.editableRoot(v.root), MutVector.editableTail(v.tail));
        }

        private Node ensureEditable(Node node) {
            if (node.edit == this.root.edit) {
                return node;
            }
            return new Node(this.root.edit, (Object[])node.array.clone());
        }

        private void ensureEditable() {
            if (this.root.edit.get() == null) {
                throw new IllegalStateException("Mutable used after immutable! call");
            }
        }

        @Override
        public int size() {
            this.ensureEditable();
            return this.size;
        }

        @Override
        public PersistentVector<F> immutable() {
            this.ensureEditable();
            this.root.edit.set(null);
            Object[] trimmedTail = new Object[this.size - this.tailoff()];
            System.arraycopy(this.tail, 0, trimmedTail, 0, trimmedTail.length);
            return new PersistentVector<Object>(this.size, this.shift, this.root, trimmedTail);
        }

        @Override
        @Contract(mutates="this")
        @NotNull
        public MutList<F> append(F val) {
            Node newroot;
            this.ensureEditable();
            int i = this.size++;
            if (i - this.tailoff() < 32) {
                this.tail[i & 0x1F] = val;
                return this;
            }
            Node tailnode = new Node(this.root.edit, this.tail);
            this.tail = new Object[32];
            this.tail[0] = val;
            int newshift = this.shift;
            if (this.size >>> 5 > 1 << this.shift) {
                newroot = new Node(this.root.edit);
                newroot.array[0] = this.root;
                newroot.array[1] = PersistentVector.newPath(this.root.edit, this.shift, tailnode);
                newshift += 5;
            } else {
                newroot = this.pushTail(this.shift, this.root, tailnode);
            }
            this.root = newroot;
            this.shift = newshift;
            ++this.size;
            return this;
        }

        @Override
        @Contract(mutates="this")
        @NotNull
        public MutList<F> appendSome(@NotNull @NotNull Fn0<? extends @NotNull Option<F>> supplier) {
            return supplier.apply().match(it -> this.append(it), () -> this);
        }

        private Node pushTail(int level, Node parent, Node tailnode) {
            Node child;
            parent = this.ensureEditable(parent);
            int subidx = this.size - 1 >>> level & 0x1F;
            Node ret = parent;
            Node nodeToInsert = level == 5 ? tailnode : ((child = (Node)parent.array[subidx]) != null ? this.pushTail(level - 5, child, tailnode) : PersistentVector.newPath(this.root.edit, level - 5, tailnode));
            ret.array[subidx] = nodeToInsert;
            return ret;
        }

        private int tailoff() {
            return this.size < 32 ? 0 : this.size - 1 >>> 5 << 5;
        }

        private F[] editableArrayFor(int i) {
            if (i >= 0 && i < this.size) {
                if (i >= this.tailoff()) {
                    return this.tail;
                }
                Node node = this.root;
                for (int level = this.shift; level > 0; level -= 5) {
                    int idx = i >>> level & 0x1F;
                    node.array[idx] = this.ensureEditable((Node)node.array[idx]);
                    node = (Node)node.array[idx];
                }
                return node.array;
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public F get(int i) {
            this.ensureEditable();
            F[] node = this.editableArrayFor(i);
            return node[i & 0x1F];
        }

        @Override
        @Contract(mutates="this")
        @NotNull
        public MutList<F> replace(int idx, F e2) {
            this.ensureEditable();
            F[] node = this.editableArrayFor(idx);
            node[idx & 0x1F] = e2;
            return this;
        }

        private static Node editableRoot(Node node) {
            return new Node(new AtomicReference<Thread>(Thread.currentThread()), (Object[])node.array.clone());
        }

        private static <T> T[] editableTail(T[] tl) {
            Object[] ret = new Object[32];
            System.arraycopy(tl, 0, ret, 0, tl.length);
            return ret;
        }
    }

    private static class SerializationProxy<E>
    implements Serializable {
        private static final long serialVersionUID = 20160904155600L;
        private final int size;
        private transient ImList<E> vector;

        SerializationProxy(PersistentVector<E> v) {
            this.size = v.size();
            this.vector = v;
        }

        private void writeObject(ObjectOutputStream s2) throws IOException {
            s2.defaultWriteObject();
            for (Object entry : this.vector) {
                s2.writeObject(entry);
            }
        }

        private void readObject(ObjectInputStream s2) throws IOException, ClassNotFoundException {
            s2.defaultReadObject();
            MutVector temp = PersistentVector.emptyMutable();
            for (int i = 0; i < this.size; ++i) {
                temp.append(s2.readObject());
            }
            this.vector = temp.immutable();
        }

        private Object readResolve() {
            return this.vector;
        }
    }

    private static class Node {
        public final transient AtomicReference<Thread> edit;
        public final Object[] array;

        Node(AtomicReference<Thread> edit, Object[] array) {
            this.edit = edit;
            this.array = array;
        }

        Node(AtomicReference<Thread> edit) {
            this.edit = edit;
            this.array = new Object[32];
        }
    }
}

