/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.paguro.oneOf;

import java.util.Objects;
import org.pkl.thirdparty.jetbrains.annotations.NotNull;
import org.pkl.thirdparty.paguro.collections.ImList;
import org.pkl.thirdparty.paguro.function.Fn1;
import org.pkl.thirdparty.paguro.type.RuntimeTypes;

public class OneOf3<A, B, C> {
    @NotNull
    protected final Object item;
    private final int sel;
    @NotNull
    private final ImList<Class> types;

    protected OneOf3(@NotNull Object o, @NotNull Class<A> aClass, @NotNull Class<B> bClass, @NotNull Class<C> cClass, int index) {
        this.types = RuntimeTypes.registerClasses(aClass, bClass, cClass);
        this.sel = index;
        this.item = o;
        if (index < 0) {
            throw new IllegalArgumentException("Selected item index must be 0-2");
        }
        if (index > 2) {
            throw new IllegalArgumentException("Selected item index must be 0-2");
        }
        if (!((Class)this.types.get(index)).isInstance(o)) {
            throw new ClassCastException("You specified index " + index + ", indicating a(n) " + ((Class)this.types.get(index)).getCanonicalName() + ", but passed a " + o.getClass().getCanonicalName());
        }
    }

    public <R> R match(@NotNull Fn1<A, R> fa, @NotNull Fn1<B, R> fb, @NotNull Fn1<C, R> fc) {
        if (this.sel == 0) {
            return fa.apply(this.item);
        }
        if (this.sel == 1) {
            return fb.apply(this.item);
        }
        return fc.apply(this.item);
    }

    public int hashCode() {
        return Objects.hashCode(this.item) + this.sel;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof OneOf3)) {
            return false;
        }
        OneOf3 that = (OneOf3)other;
        return this.sel == that.sel && Objects.equals(this.item, that.item);
    }

    @NotNull
    public String toString() {
        return RuntimeTypes.union2Str(this.item, this.types);
    }
}

