/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.truffle.api.exception;

import org.pkl.thirdparty.truffle.api.interop.InteropLibrary;
import org.pkl.thirdparty.truffle.api.interop.InvalidArrayIndexException;
import org.pkl.thirdparty.truffle.api.interop.TruffleObject;
import org.pkl.thirdparty.truffle.api.library.ExportLibrary;
import org.pkl.thirdparty.truffle.api.library.ExportMessage;

@ExportLibrary(value=InteropLibrary.class)
final class InteropList
implements TruffleObject {
    private final Object[] items;

    InteropList(Object[] items) {
        this.items = items;
    }

    @ExportMessage
    boolean hasArrayElements() {
        return true;
    }

    @ExportMessage
    long getArraySize() {
        return this.items.length;
    }

    @ExportMessage
    boolean isArrayElementReadable(long index) {
        return index >= 0L && index < (long)this.items.length;
    }

    @ExportMessage
    Object readArrayElement(long index) throws InvalidArrayIndexException {
        if (index < 0L || index >= (long)this.items.length) {
            throw InvalidArrayIndexException.create(index);
        }
        return this.items[(int)index];
    }
}

