/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.truffle.api.interop;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.pkl.thirdparty.truffle.api.CompilerDirectives;
import org.pkl.thirdparty.truffle.api.TruffleLanguage;
import org.pkl.thirdparty.truffle.api.interop.InteropLibrary;
import org.pkl.thirdparty.truffle.api.interop.NumberUtils;
import org.pkl.thirdparty.truffle.api.interop.UnsupportedMessageException;
import org.pkl.thirdparty.truffle.api.library.ExportLibrary;
import org.pkl.thirdparty.truffle.api.library.ExportMessage;
import org.pkl.thirdparty.truffle.api.source.SourceSection;

@ExportLibrary(value=InteropLibrary.class, receiverType=Double.class)
final class DefaultDoubleExports {
    DefaultDoubleExports() {
    }

    @ExportMessage
    static boolean fitsInByte(Double receiver) {
        double d2 = receiver;
        byte b2 = (byte)d2;
        return (double)b2 == d2 && !NumberUtils.isNegativeZero(d2);
    }

    @ExportMessage
    static boolean fitsInInt(Double receiver) {
        double d2 = receiver;
        int i = (int)d2;
        return (double)i == d2 && !NumberUtils.isNegativeZero(d2);
    }

    @ExportMessage
    static boolean fitsInShort(Double receiver) {
        double d2 = receiver;
        short s2 = (short)d2;
        return (double)s2 == d2 && !NumberUtils.isNegativeZero(d2);
    }

    @ExportMessage
    static boolean fitsInLong(Double receiver) {
        long l;
        double d2 = receiver;
        return !NumberUtils.isNegativeZero(d2) && (l = (long)d2) != Long.MAX_VALUE && (double)l == d2;
    }

    @ExportMessage
    static boolean fitsInBigInteger(Double receiver) {
        return receiver % 1.0 == 0.0 && !NumberUtils.isNegativeZero(receiver);
    }

    @ExportMessage
    static boolean fitsInFloat(Double receiver) {
        double d2 = receiver;
        float f = (float)d2;
        return !Double.isFinite(d2) || (double)f == d2;
    }

    @ExportMessage
    static byte asByte(Double receiver) throws UnsupportedMessageException {
        double d2 = receiver;
        byte b2 = (byte)d2;
        if ((double)b2 == d2 && !NumberUtils.isNegativeZero(d2)) {
            return b2;
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    static short asShort(Double receiver) throws UnsupportedMessageException {
        double d2 = receiver;
        short s2 = (short)d2;
        if ((double)s2 == d2 && !NumberUtils.isNegativeZero(d2)) {
            return s2;
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    static int asInt(Double receiver) throws UnsupportedMessageException {
        double d2 = receiver;
        int i = (int)d2;
        if ((double)i == d2 && !NumberUtils.isNegativeZero(d2)) {
            return i;
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    static long asLong(Double receiver) throws UnsupportedMessageException {
        long l;
        double d2 = receiver;
        if (!NumberUtils.isNegativeZero(d2) && (l = (long)d2) != Long.MAX_VALUE && (double)l == d2) {
            return l;
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    static BigInteger asBigInteger(Double receiver) throws UnsupportedMessageException {
        if (!DefaultDoubleExports.fitsInBigInteger(receiver)) {
            throw UnsupportedMessageException.create();
        }
        return DefaultDoubleExports.toBigInteger(receiver);
    }

    @CompilerDirectives.TruffleBoundary
    private static BigInteger toBigInteger(double receiver) {
        try {
            return new BigDecimal(receiver).toBigIntegerExact();
        }
        catch (ArithmeticException e2) {
            throw CompilerDirectives.shouldNotReachHere(e2);
        }
    }

    @ExportMessage
    static float asFloat(Double receiver) throws UnsupportedMessageException {
        double d2 = receiver;
        float f = (float)d2;
        if (!Double.isFinite(d2) || (double)f == d2) {
            return f;
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    static boolean isNumber(Double receiver) {
        return true;
    }

    @ExportMessage
    static boolean fitsInDouble(Double receiver) {
        return true;
    }

    @ExportMessage
    static double asDouble(Double receiver) {
        return receiver;
    }

    @ExportMessage
    static boolean hasLanguage(Double receiver) {
        return false;
    }

    @ExportMessage
    static Class<? extends TruffleLanguage<?>> getLanguage(Double receiver) throws UnsupportedMessageException {
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    static boolean hasSourceLocation(Double receiver) {
        return false;
    }

    @ExportMessage
    static SourceSection getSourceLocation(Double receiver) throws UnsupportedMessageException {
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    static boolean hasMetaObject(Double receiver) {
        return false;
    }

    @ExportMessage
    static Object getMetaObject(Double receiver) throws UnsupportedMessageException {
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    static Object toDisplayString(Double receiver, boolean allowSideEffects) {
        return receiver.toString();
    }
}

