/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.truffle.api.profiles;

import org.pkl.thirdparty.truffle.api.CompilerDirectives;
import org.pkl.thirdparty.truffle.api.dsl.InlineSupport;
import org.pkl.thirdparty.truffle.api.nodes.Node;
import org.pkl.thirdparty.truffle.api.profiles.InlinedProfile;
import org.pkl.thirdparty.truffle.api.profiles.Profile;

public final class InlinedConditionProfile
extends InlinedProfile {
    private static final InlinedConditionProfile DISABLED;
    private static final int REQUIRED_STATE_BITS = 2;
    private final InlineSupport.StateField state;

    private InlinedConditionProfile() {
        this.state = null;
    }

    private InlinedConditionProfile(InlineSupport.InlineTarget target) {
        this.state = target.getState(0, 2);
    }

    public boolean profile(Node node, boolean value2) {
        if (this.state != null) {
            int s2 = this.state.get(node);
            if (value2) {
                if ((s2 & 1) == 0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.state.set(node, s2 | 1);
                }
                return true;
            }
            if ((s2 & 2) == 0) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.state.set(node, s2 | 2);
            }
            return false;
        }
        return value2;
    }

    public boolean wasTrue(Node node) {
        if (this.state == null) {
            return true;
        }
        return (this.state.get(node) & 1) == 1;
    }

    public boolean wasFalse(Node node) {
        if (this.state == null) {
            return true;
        }
        return (this.state.get(node) & 2) == 2;
    }

    @Override
    public void disable(Node node) {
        if (this.state == null) {
            return;
        }
        this.state.set(node, 3);
    }

    @Override
    public void reset(Node node) {
        if (this.state == null) {
            return;
        }
        this.state.set(node, 0);
    }

    boolean isGeneric(Node node) {
        if (this.state == null) {
            return true;
        }
        return this.wasTrue(node) && this.wasFalse(node);
    }

    boolean isUninitialized(Node node) {
        if (this.state == null) {
            return false;
        }
        return !this.wasTrue(node) && !this.wasFalse(node);
    }

    @Override
    public String toString(Node node) {
        if (this.state == null) {
            return this.toStringDisabled();
        }
        return String.format("%s(wasTrue=%s, wasFalse=%s)@%x", this.getClass().getSimpleName(), this.wasTrue(node), this.wasFalse(node), this.hashCode());
    }

    public static InlinedConditionProfile inline(@InlineSupport.RequiredField(value=InlineSupport.StateField.class, bits=2) InlineSupport.InlineTarget target) {
        if (Profile.isProfilingEnabled()) {
            return new InlinedConditionProfile(target);
        }
        return InlinedConditionProfile.getUncached();
    }

    public static InlinedConditionProfile getUncached() {
        return DISABLED;
    }

    static {
        InlinedConditionProfile profile;
        DISABLED = profile = new InlinedConditionProfile();
    }
}

