/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.truffle.api.strings;

import java.util.Arrays;
import org.pkl.thirdparty.truffle.api.CompilerAsserts;
import org.pkl.thirdparty.truffle.api.CompilerDirectives;
import org.pkl.thirdparty.truffle.api.dsl.Bind;
import org.pkl.thirdparty.truffle.api.dsl.Cached;
import org.pkl.thirdparty.truffle.api.dsl.ImportStatic;
import org.pkl.thirdparty.truffle.api.dsl.Specialization;
import org.pkl.thirdparty.truffle.api.nodes.ExplodeLoop;
import org.pkl.thirdparty.truffle.api.nodes.Node;
import org.pkl.thirdparty.truffle.api.profiles.InlinedBranchProfile;
import org.pkl.thirdparty.truffle.api.profiles.InlinedConditionProfile;
import org.pkl.thirdparty.truffle.api.strings.AbstractInternalNode;
import org.pkl.thirdparty.truffle.api.strings.AbstractTruffleString;
import org.pkl.thirdparty.truffle.api.strings.Encodings;
import org.pkl.thirdparty.truffle.api.strings.FastDoubleParser;
import org.pkl.thirdparty.truffle.api.strings.IndexOfCodePointSet;
import org.pkl.thirdparty.truffle.api.strings.InternalErrors;
import org.pkl.thirdparty.truffle.api.strings.JCodings;
import org.pkl.thirdparty.truffle.api.strings.NumberConversion;
import org.pkl.thirdparty.truffle.api.strings.Stride;
import org.pkl.thirdparty.truffle.api.strings.StringAttributes;
import org.pkl.thirdparty.truffle.api.strings.TSCodeRange;
import org.pkl.thirdparty.truffle.api.strings.TStringConstants;
import org.pkl.thirdparty.truffle.api.strings.TStringGuards;
import org.pkl.thirdparty.truffle.api.strings.TStringInternalNodesFactory;
import org.pkl.thirdparty.truffle.api.strings.TStringOps;
import org.pkl.thirdparty.truffle.api.strings.TStringOpsNodes;
import org.pkl.thirdparty.truffle.api.strings.TStringUnsafe;
import org.pkl.thirdparty.truffle.api.strings.TruffleString;
import org.pkl.thirdparty.truffle.api.strings.TruffleStringIterator;

final class TStringInternalNodes {
    TStringInternalNodes() {
    }

    private static long updateAttributes(Node node, AbstractTruffleString a, TruffleString.Encoding encoding, int impreciseCodeRange, TruffleString.ToIndexableNode toIndexableNode, CalcStringAttributesNode calcStringAttributesNode) {
        assert (!TSCodeRange.isPrecise(impreciseCodeRange));
        long attrs = calcStringAttributesNode.execute(node, a, toIndexableNode.execute(node, a, a.data()), a.offset(), a.length(), a.stride(), encoding, 0, impreciseCodeRange);
        a.updateAttributes(StringAttributes.getCodePointLength(attrs), StringAttributes.getCodeRange(attrs));
        return attrs;
    }

    static int indexOfFixedWidth(Node node, AbstractTruffleString a, Object arrayA, int codeRangeA, int codepoint, int fromIndex, int toIndex, TStringOpsNodes.RawIndexOfCodePointNode indexOfNode) {
        if (fromIndex == toIndex || !TSCodeRange.isInCodeRange(codepoint, codeRangeA)) {
            return -1;
        }
        return indexOfNode.execute(node, a, arrayA, codepoint, fromIndex, toIndex);
    }

    static int lastIndexOfFixedWidth(Node node, AbstractTruffleString a, Object arrayA, int codeRangeA, int codepoint, int fromIndex, int toIndex, TStringOpsNodes.RawLastIndexOfCodePointNode indexOfNode) {
        if (fromIndex == toIndex || !TSCodeRange.isInCodeRange(codepoint, codeRangeA)) {
            return -1;
        }
        return indexOfNode.execute(node, a, arrayA, codepoint, fromIndex, toIndex);
    }

    static abstract class CalcStringAttributesNode
    extends AbstractInternalNode {
        CalcStringAttributesNode() {
        }

        abstract long execute(Node var1, AbstractTruffleString var2, Object var3, int var4, int var5, int var6, TruffleString.Encoding var7, int var8, int var9);

        @Specialization(guards={"length == 0"})
        long empty(AbstractTruffleString a, Object array, int offset, int length2, int stride, TruffleString.Encoding encoding, int fromIndex, int knownCodeRange) {
            return StringAttributes.create(length2, TSCodeRange.getAsciiCodeRange(encoding));
        }

        @Specialization(guards={"is7Bit(knownCodeRange)", "length > 0"})
        long ascii(AbstractTruffleString a, Object array, int offset, int length2, int stride, TruffleString.Encoding encoding, int fromIndex, int knownCodeRange) {
            return StringAttributes.create(length2, TSCodeRange.get7Bit());
        }

        @Specialization(guards={"!is7Bit(knownCodeRange)", "length > 0"})
        static long notAscii(Node node, AbstractTruffleString a, Object array, int offset, int length2, int stride, TruffleString.Encoding encoding, int fromIndex, int knownCodeRange, @Cached CalcStringAttributesInnerNode calcNode) {
            return calcNode.execute(node, a, array, offset, length2, stride, encoding, fromIndex, knownCodeRange);
        }
    }

    static abstract class TransCodeIntlNode
    extends AbstractInternalNode {
        TransCodeIntlNode() {
        }

        abstract TruffleString execute(Node var1, AbstractTruffleString var2, Object var3, int var4, int var5, TruffleString.Encoding var6, TruffleString.Encoding var7);

        @Specialization(guards={"isSupportedEncoding(sourceEncoding)", "isAscii(targetEncoding) || isBytes(targetEncoding)"})
        static TruffleString targetAscii(Node node, AbstractTruffleString a, Object arrayA, int codePointLengthA, int codeRangeA, TruffleString.Encoding sourceEncoding, TruffleString.Encoding targetEncoding, @Cached @Cached.Shared(value="iteratorNextNode") TruffleStringIterator.InternalNextNode iteratorNextNode) {
            assert (!TStringGuards.is7Bit(codeRangeA));
            byte[] buffer = new byte[codePointLengthA];
            TruffleStringIterator it = AbstractTruffleString.forwardIterator(a, arrayA, codeRangeA, sourceEncoding);
            int i = 0;
            while (it.hasNext()) {
                int codepoint = iteratorNextNode.execute(node, it);
                buffer[i++] = (byte)(codepoint > 127 ? 63 : (byte)codepoint);
                TStringConstants.truffleSafePointPoll(node, i);
            }
            return TransCodeIntlNode.create(a, buffer, buffer.length, 0, targetEncoding, codePointLengthA, TSCodeRange.get7Bit(), true);
        }

        @Specialization(guards={"isSupportedEncoding(sourceEncoding)", "isLatin1(targetEncoding)"})
        static TruffleString latin1Transcode(Node node, AbstractTruffleString a, Object arrayA, int codePointLengthA, int codeRangeA, TruffleString.Encoding sourceEncoding, TruffleString.Encoding targetEncoding, @Cached @Cached.Shared(value="iteratorNextNode") TruffleStringIterator.InternalNextNode iteratorNextNode) {
            assert (!TStringGuards.is7Or8Bit(codeRangeA));
            byte[] buffer = new byte[codePointLengthA];
            TruffleStringIterator it = AbstractTruffleString.forwardIterator(a, arrayA, codeRangeA, sourceEncoding);
            int codeRange = TSCodeRange.get7Bit();
            int i = 0;
            while (it.hasNext()) {
                int codepoint = iteratorNextNode.execute(node, it);
                byte latin1 = (byte)(codepoint > 255 ? 63 : (byte)codepoint);
                buffer[i++] = latin1;
                if (latin1 < 0) {
                    codeRange = TSCodeRange.get8Bit();
                }
                TStringConstants.truffleSafePointPoll(node, i);
            }
            return TransCodeIntlNode.create(a, buffer, codePointLengthA, 0, TruffleString.Encoding.ISO_8859_1, codePointLengthA, codeRange, true);
        }

        @Specialization(guards={"isSupportedEncoding(sourceEncoding)", "!isLarge(codePointLengthA)", "isUTF8(targetEncoding)"})
        static TruffleString utf8TranscodeRegular(Node node, AbstractTruffleString a, Object arrayA, int codePointLengthA, int codeRangeA, TruffleString.Encoding sourceEncoding, TruffleString.Encoding targetEncoding, @Cached @Cached.Shared(value="iteratorNextNode") TruffleStringIterator.InternalNextNode iteratorNextNode, @Cached @Cached.Shared(value="brokenProfile") InlinedConditionProfile brokenProfile, @Cached @Cached.Shared(value="outOfMemoryProfile") InlinedBranchProfile outOfMemoryProfile) {
            return TransCodeIntlNode.utf8Transcode(node, a, arrayA, codePointLengthA, codeRangeA, sourceEncoding, iteratorNextNode, false, brokenProfile, outOfMemoryProfile);
        }

        @Specialization(guards={"isSupportedEncoding(sourceEncoding)", "isLarge(codePointLengthA)", "isUTF8(targetEncoding)"})
        static TruffleString utf8TranscodeLarge(Node node, AbstractTruffleString a, Object arrayA, int codePointLengthA, int codeRangeA, TruffleString.Encoding sourceEncoding, TruffleString.Encoding targetEncoding, @Cached @Cached.Shared(value="iteratorNextNode") TruffleStringIterator.InternalNextNode iteratorNextNode, @Cached @Cached.Shared(value="brokenProfile") InlinedConditionProfile brokenProfile, @Cached @Cached.Shared(value="outOfMemoryProfile") InlinedBranchProfile outOfMemoryProfile) {
            return TransCodeIntlNode.utf8Transcode(node, a, arrayA, codePointLengthA, codeRangeA, sourceEncoding, iteratorNextNode, true, brokenProfile, outOfMemoryProfile);
        }

        static boolean isLarge(int codePointLengthA) {
            return codePointLengthA > 0x1FFFFFFD;
        }

        private static TruffleString utf8Transcode(Node node, AbstractTruffleString a, Object arrayA, int codePointLengthA, int codeRangeA, TruffleString.Encoding sourceEncoding, TruffleStringIterator.InternalNextNode iteratorNextNode, boolean isLarge, InlinedConditionProfile brokenProfile, InlinedBranchProfile outOfMemoryProfile) {
            int codePointLength;
            assert (!TStringGuards.is7Bit(codeRangeA));
            TruffleStringIterator it = AbstractTruffleString.forwardIterator(a, arrayA, codeRangeA, sourceEncoding);
            byte[] buffer = new byte[isLarge ? 0x7FFFFFF7 : codePointLengthA * 4];
            int codeRange = TSCodeRange.getValidMultiByte();
            int length2 = 0;
            int loopCount = 0;
            while (it.hasNext()) {
                int codepoint = iteratorNextNode.execute(node, it);
                if (Encodings.isUTF16Surrogate(codepoint) || Integer.toUnsignedLong(codepoint) > 0x10FFFFL) {
                    codeRange = TSCodeRange.getBrokenMultiByte();
                    codepoint = Encodings.invalidCodepoint();
                }
                int n = Encodings.utf8EncodedSize(codepoint);
                assert (isLarge || length2 + n <= buffer.length);
                if (isLarge && length2 > 0x7FFFFFF7 - n) {
                    outOfMemoryProfile.enter(node);
                    throw InternalErrors.outOfMemory();
                }
                Encodings.utf8Encode(codepoint, buffer, length2, n);
                length2 += n;
                TStringConstants.truffleSafePointPoll(node, ++loopCount);
            }
            if (TStringGuards.isBrokenMultiByte(codeRange)) {
                long attrs = TStringOps.calcStringAttributesUTF8(node, buffer, 0, length2, false, false, brokenProfile);
                codePointLength = StringAttributes.getCodePointLength(attrs);
                codeRange = StringAttributes.getCodeRange(attrs);
            } else {
                codePointLength = codePointLengthA;
            }
            return TransCodeIntlNode.create(a, Arrays.copyOf(buffer, length2), length2, 0, TruffleString.Encoding.UTF_8, codePointLength, codeRange, TStringGuards.isBrokenMultiByte(codeRange));
        }

        @Specialization(guards={"isUTF32(sourceEncoding)", "isUTF16(targetEncoding)"})
        TruffleString utf16Fixed32Bit(AbstractTruffleString a, Object arrayA, int codePointLengthA, int codeRangeA, TruffleString.Encoding sourceEncoding, TruffleString.Encoding targetEncoding) {
            int codePointLength;
            assert (TStringGuards.isValidFixedWidth(codeRangeA) || TStringGuards.isBrokenFixedWidth(codeRangeA));
            assert (TStringGuards.isStride2(a));
            byte[] buffer = new byte[codePointLengthA * 4];
            int length2 = 0;
            int codeRange = TStringGuards.isValidFixedWidth(codeRangeA) ? TSCodeRange.getValidMultiByte() : TSCodeRange.getBrokenMultiByte();
            for (int i = 0; i < a.length(); ++i) {
                int codepoint = TStringOps.readS2(a, arrayA, i);
                length2 += Encodings.utf16Encode(codepoint, buffer, length2);
                TStringConstants.truffleSafePointPoll(this, i + 1);
            }
            if (TStringGuards.isBrokenMultiByte(codeRange)) {
                long attrs = TStringOps.calcStringAttributesUTF16(this, buffer, 0, length2, false);
                codePointLength = StringAttributes.getCodePointLength(attrs);
                codeRange = StringAttributes.getCodeRange(attrs);
            } else {
                codePointLength = codePointLengthA;
            }
            return TransCodeIntlNode.create(a, Arrays.copyOf(buffer, length2 * 2), length2, 1, TruffleString.Encoding.UTF_16, codePointLength, codeRange, TStringGuards.isBrokenMultiByte(codeRange));
        }

        @Specialization(guards={"isSupportedEncoding(sourceEncoding)", "!isFixedWidth(codeRangeA)", "!isLarge(codePointLengthA)", "isUTF16(targetEncoding)"})
        static TruffleString utf16TranscodeRegular(Node node, AbstractTruffleString a, Object arrayA, int codePointLengthA, int codeRangeA, TruffleString.Encoding sourceEncoding, TruffleString.Encoding targetEncoding, @Cached @Cached.Shared(value="iteratorNextNode") TruffleStringIterator.InternalNextNode iteratorNextNode, @Cached @Cached.Shared(value="outOfMemoryProfile") InlinedBranchProfile outOfMemoryProfile) {
            return TransCodeIntlNode.utf16Transcode(node, a, arrayA, codePointLengthA, codeRangeA, sourceEncoding, iteratorNextNode, false, outOfMemoryProfile);
        }

        @Specialization(guards={"isSupportedEncoding(sourceEncoding)", "!isFixedWidth(codeRangeA)", "isLarge(codePointLengthA)", "isUTF16(targetEncoding)"})
        static TruffleString utf16TranscodeLarge(Node node, AbstractTruffleString a, Object arrayA, int codePointLengthA, int codeRangeA, TruffleString.Encoding sourceEncoding, TruffleString.Encoding targetEncoding, @Cached @Cached.Shared(value="iteratorNextNode") TruffleStringIterator.InternalNextNode iteratorNextNode, @Cached @Cached.Shared(value="outOfMemoryProfile") InlinedBranchProfile outOfMemoryProfile) {
            return TransCodeIntlNode.utf16Transcode(node, a, arrayA, codePointLengthA, codeRangeA, sourceEncoding, iteratorNextNode, true, outOfMemoryProfile);
        }

        private static TruffleString utf16Transcode(Node node, AbstractTruffleString a, Object arrayA, int codePointLengthA, int codeRangeA, TruffleString.Encoding sourceEncoding, TruffleStringIterator.InternalNextNode iteratorNextNode, boolean isLarge, InlinedBranchProfile outOfMemoryProfile) {
            int codepoint;
            int curIndex;
            assert (TStringGuards.isValidOrBrokenMultiByte(codeRangeA));
            TruffleStringIterator it = AbstractTruffleString.forwardIterator(a, arrayA, codeRangeA, sourceEncoding);
            byte[] buffer = new byte[codePointLengthA];
            int codePointLength = codePointLengthA;
            int length2 = 0;
            int codeRange = TSCodeRange.get7Bit();
            while (it.hasNext()) {
                curIndex = it.getRawIndex();
                codepoint = iteratorNextNode.execute(node, it);
                if (codepoint > 255) {
                    buffer = TStringOps.arraycopyOfWithStride(node, buffer, 0, length2, 0, codePointLengthA, 1);
                    codeRange = TSCodeRange.get16Bit();
                    it.setRawIndex(curIndex);
                    break;
                }
                if (codepoint > 127) {
                    codeRange = TSCodeRange.get8Bit();
                }
                buffer[length2++] = (byte)codepoint;
                TStringConstants.truffleSafePointPoll(node, length2);
            }
            if (!it.hasNext()) {
                assert (length2 == codePointLengthA);
                return TransCodeIntlNode.create(a, buffer, length2, 0, TruffleString.Encoding.UTF_16, codePointLengthA, codeRange, false);
            }
            while (it.hasNext()) {
                curIndex = it.getRawIndex();
                codepoint = iteratorNextNode.execute(node, it);
                if (codepoint > 65535) {
                    buffer = Arrays.copyOf(buffer, isLarge ? 0x7FFFFFF7 : buffer.length * 2);
                    codeRange = TSCodeRange.commonCodeRange(codeRange, TSCodeRange.getValidMultiByte());
                    it.setRawIndex(curIndex);
                    break;
                }
                if (Encodings.isUTF16Surrogate(codepoint)) {
                    codeRange = TSCodeRange.getBrokenMultiByte();
                }
                TStringOps.writeToByteArray(buffer, 1, length2++, codepoint);
                TStringConstants.truffleSafePointPoll(node, length2);
            }
            if (!it.hasNext()) {
                assert (length2 == codePointLengthA);
                if (TStringGuards.isBrokenMultiByte(codeRange)) {
                    long attrs = TStringOps.calcStringAttributesUTF16(node, buffer, 0, length2, false);
                    codePointLength = StringAttributes.getCodePointLength(attrs);
                    codeRange = StringAttributes.getCodeRange(attrs);
                }
                return TransCodeIntlNode.create(a, buffer, length2, 1, TruffleString.Encoding.UTF_16, codePointLength, codeRange, TStringGuards.isBrokenMultiByte(codeRange));
            }
            int loopCount = 0;
            while (it.hasNext()) {
                codepoint = iteratorNextNode.execute(node, it);
                if (Encodings.isUTF16Surrogate(codepoint) || Integer.toUnsignedLong(codepoint) > 0x10FFFFL) {
                    codeRange = TSCodeRange.getBrokenMultiByte();
                }
                if (isLarge && length2 + Encodings.utf16EncodedSize(codepoint) > 0x3FFFFFFB) {
                    outOfMemoryProfile.enter(node);
                    throw InternalErrors.outOfMemory();
                }
                length2 += Encodings.utf16Encode(codepoint, buffer, length2);
                TStringConstants.truffleSafePointPoll(node, ++loopCount);
            }
            if (TStringGuards.isBrokenMultiByte(codeRange)) {
                long attrs = TStringOps.calcStringAttributesUTF16(node, buffer, 0, length2, false);
                codePointLength = StringAttributes.getCodePointLength(attrs);
                codeRange = StringAttributes.getCodeRange(attrs);
            }
            return TransCodeIntlNode.create(a, Arrays.copyOf(buffer, length2 * 2), length2, 1, TruffleString.Encoding.UTF_16, codePointLength, codeRange, TStringGuards.isBrokenMultiByte(codeRange));
        }

        @Specialization(guards={"!isUTF16(sourceEncoding)", "isSupportedEncoding(sourceEncoding)", "!isFixedWidth(codeRangeA)", "!isLarge(codePointLengthA)", "isUTF32(targetEncoding)"})
        static TruffleString utf32TranscodeRegular(Node node, AbstractTruffleString a, Object arrayA, int codePointLengthA, int codeRangeA, TruffleString.Encoding sourceEncoding, TruffleString.Encoding targetEncoding, @Cached @Cached.Shared(value="iteratorNextNode") TruffleStringIterator.InternalNextNode iteratorNextNode) {
            return TransCodeIntlNode.utf32Transcode(node, a, arrayA, codePointLengthA, codeRangeA, sourceEncoding, iteratorNextNode);
        }

        @Specialization(guards={"isSupportedEncoding(sourceEncoding)", "!isFixedWidth(codeRangeA)", "isLarge(codePointLengthA)", "isUTF32(targetEncoding)"})
        static TruffleString utf32TranscodeLarge(AbstractTruffleString a, Object arrayA, int codePointLengthA, int codeRangeA, TruffleString.Encoding sourceEncoding, TruffleString.Encoding targetEncoding) {
            throw InternalErrors.outOfMemory();
        }

        @Specialization(guards={"isUTF16(sourceEncoding)", "!isFixedWidth(codeRangeA)", "!isLarge(codePointLengthA)", "isUTF32(targetEncoding)"})
        static TruffleString utf32TranscodeUTF16(Node node, AbstractTruffleString a, Object arrayA, int codePointLengthA, int codeRangeA, TruffleString.Encoding sourceEncoding, TruffleString.Encoding targetEncoding, @Cached @Cached.Shared(value="iteratorNextNode") TruffleStringIterator.InternalNextNode iteratorNextNode) {
            assert (TransCodeIntlNode.containsSurrogates(a));
            TruffleStringIterator it = AbstractTruffleString.forwardIterator(a, arrayA, codeRangeA, sourceEncoding);
            byte[] buffer = new byte[codePointLengthA << 2];
            int length2 = 0;
            while (it.hasNext()) {
                TStringOps.writeToByteArray(buffer, 2, length2++, iteratorNextNode.execute(node, it));
                TStringConstants.truffleSafePointPoll(node, length2);
            }
            assert (length2 == codePointLengthA);
            boolean isBroken = TStringGuards.isBrokenMultiByte(codeRangeA);
            return TransCodeIntlNode.create(a, buffer, length2, 2, TruffleString.Encoding.UTF_32, codePointLengthA, isBroken ? TSCodeRange.getBrokenFixedWidth() : TSCodeRange.getValidFixedWidth(), isBroken);
        }

        private static TruffleString utf32Transcode(Node node, AbstractTruffleString a, Object arrayA, int codePointLengthA, int codeRangeA, TruffleString.Encoding sourceEncoding, TruffleStringIterator.InternalNextNode iteratorNextNode) {
            int curIndex;
            assert (TStringGuards.isValidOrBrokenMultiByte(codeRangeA));
            TruffleStringIterator it = AbstractTruffleString.forwardIterator(a, arrayA, codeRangeA, sourceEncoding);
            byte[] buffer = new byte[codePointLengthA];
            int length2 = 0;
            int codeRange = TSCodeRange.get7Bit();
            int codepoint = 0;
            while (it.hasNext()) {
                curIndex = it.getRawIndex();
                codepoint = iteratorNextNode.execute(node, it);
                if (codepoint > 255) {
                    if (Encodings.isUTF16Surrogate(codepoint)) {
                        buffer = TStringOps.arraycopyOfWithStride(node, buffer, 0, length2, 0, codePointLengthA, 2);
                        codeRange = TSCodeRange.getBrokenFixedWidth();
                    } else {
                        buffer = TStringOps.arraycopyOfWithStride(node, buffer, 0, length2, 0, codePointLengthA, 1);
                        codeRange = TSCodeRange.get16Bit();
                    }
                    it.setRawIndex(curIndex);
                    break;
                }
                if (codepoint > 127) {
                    codeRange = TSCodeRange.get8Bit();
                }
                buffer[length2++] = (byte)codepoint;
                TStringConstants.truffleSafePointPoll(node, length2);
            }
            if (!it.hasNext()) {
                assert (length2 == codePointLengthA);
                return TransCodeIntlNode.create(a, buffer, length2, 0, TruffleString.Encoding.UTF_32, codePointLengthA, codeRange, TStringGuards.isBrokenFixedWidth(codeRange));
            }
            if (TStringGuards.is16Bit(codeRange)) {
                while (it.hasNext()) {
                    curIndex = it.getRawIndex();
                    codepoint = iteratorNextNode.execute(node, it);
                    if (codepoint > 65535 || Encodings.isUTF16Surrogate(codepoint)) {
                        buffer = TStringOps.arraycopyOfWithStride(node, buffer, 0, length2, 1, codePointLengthA, 2);
                        codeRange = Encodings.isValidUnicodeCodepoint(codepoint) ? TSCodeRange.getValidFixedWidth() : TSCodeRange.getBrokenFixedWidth();
                        it.setRawIndex(curIndex);
                        break;
                    }
                    TStringOps.writeToByteArray(buffer, 1, length2++, codepoint);
                    TStringConstants.truffleSafePointPoll(node, length2);
                }
            }
            if (!it.hasNext()) {
                assert (length2 == codePointLengthA);
                return TransCodeIntlNode.create(a, buffer, length2, 1, TruffleString.Encoding.UTF_32, codePointLengthA, codeRange, TStringGuards.isBrokenFixedWidth(codeRange));
            }
            while (it.hasNext()) {
                codepoint = iteratorNextNode.execute(node, it);
                if (!Encodings.isValidUnicodeCodepoint(codepoint)) {
                    codeRange = TSCodeRange.getBrokenFixedWidth();
                }
                TStringOps.writeToByteArray(buffer, 2, length2++, codepoint);
                TStringConstants.truffleSafePointPoll(node, length2);
            }
            return TransCodeIntlNode.create(a, buffer, length2, 2, TruffleString.Encoding.UTF_32, codePointLengthA, codeRange, TStringGuards.isBrokenFixedWidth(codeRange));
        }

        @Specialization(guards={"isUnsupportedEncoding(sourceEncoding) || isUnsupportedEncoding(targetEncoding)"})
        static TruffleString unsupported(Node node, AbstractTruffleString a, Object arrayA, int codePointLengthA, int codeRangeA, TruffleString.Encoding sourceEncoding, TruffleString.Encoding targetEncoding, @Cached.Shared(value="outOfMemoryProfile") @Cached InlinedBranchProfile outOfMemoryProfile, @Cached.Exclusive @Cached InlinedConditionProfile nativeProfile, @Cached FromBufferWithStringCompactionNode fromBufferWithStringCompactionNode) {
            return JCodings.getInstance().transcode(node, a, arrayA, codePointLengthA, targetEncoding, outOfMemoryProfile, nativeProfile, fromBufferWithStringCompactionNode);
        }

        private static TruffleString create(AbstractTruffleString a, byte[] buffer, int length2, int stride, TruffleString.Encoding encoding, int codePointLength, int codeRange, boolean isCacheHead) {
            return TruffleString.createFromByteArray(buffer, length2, stride, encoding, codePointLength, codeRange, isCacheHead || a.isMutable());
        }

        @CompilerDirectives.TruffleBoundary
        private static boolean containsSurrogates(AbstractTruffleString a) {
            CompilerAsserts.neverPartOfCompilation();
            for (int i = 0; i < a.length(); ++i) {
                if (!Encodings.isUTF16Surrogate(a.readCharUTF16Uncached(i))) continue;
                return true;
            }
            return false;
        }
    }

    static abstract class TransCodeNode
    extends AbstractInternalNode {
        TransCodeNode() {
        }

        abstract TruffleString execute(Node var1, AbstractTruffleString var2, Object var3, int var4, int var5, TruffleString.Encoding var6);

        @Specialization
        static TruffleString transcode(Node node, AbstractTruffleString a, Object arrayA, int codePointLengthA, int codeRangeA, TruffleString.Encoding targetEncoding, @Cached InlinedConditionProfile asciiBytesInvalidProfile, @Cached TransCodeIntlNode transCodeIntlNode) {
            if (AbstractTruffleString.DEBUG_STRICT_ENCODING_CHECKS && a.isImmutable() && TSCodeRange.isMoreRestrictiveThan(codeRangeA, targetEncoding.maxCompatibleCodeRange)) {
                if (a.stride() == 0) {
                    return TruffleString.createFromArray(arrayA, a.offset(), a.length(), 0, targetEncoding, codePointLengthA, codeRangeA, false);
                }
                int targetStride = Stride.fromCodeRange(codeRangeA, targetEncoding);
                byte[] array = TStringOps.arraycopyOfWithStride(node, arrayA, a.offset(), a.length(), a.stride(), a.length(), targetStride);
                return TruffleString.createFromArray(array, 0, a.length(), targetStride, targetEncoding, codePointLengthA, codeRangeA, false);
            }
            assert (a.length() > 0);
            if (asciiBytesInvalidProfile.profile(node, (TStringGuards.isAscii(a.encoding()) || TStringGuards.isBytes(a.encoding())) && TStringGuards.isSupportedEncoding(targetEncoding))) {
                assert ((TStringGuards.isBrokenFixedWidth(codeRangeA) || TStringGuards.isValidFixedWidth(codeRangeA)) && TStringGuards.isStride0(a) && codePointLengthA == a.length());
                byte[] buffer = new byte[codePointLengthA];
                for (int i = 0; i < buffer.length; ++i) {
                    int c = TStringOps.readS0(a, arrayA, i);
                    buffer[i] = (byte)(c > 127 ? 63 : c);
                    TStringConstants.truffleSafePointPoll(node, i + 1);
                }
                return TransCodeIntlNode.create(a, buffer, buffer.length, 0, targetEncoding, codePointLengthA, TSCodeRange.get7Bit(), true);
            }
            return transCodeIntlNode.execute(node, a, arrayA, codePointLengthA, codeRangeA, TruffleString.Encoding.get(a.encoding()), targetEncoding);
        }
    }

    static abstract class CreateJavaStringNode
    extends AbstractInternalNode {
        CreateJavaStringNode() {
        }

        abstract String execute(Node var1, AbstractTruffleString var2, Object var3);

        @Specialization
        static String createJavaString(Node node, AbstractTruffleString a, Object arrayA, @Cached InlinedConditionProfile reuseProfile) {
            byte[] bytes;
            assert (TSCodeRange.is7Or8Bit(a.codeRange()) || TSCodeRange.isPrecise(a.codeRange()));
            assert (a.isLooselyCompatibleTo(TruffleString.Encoding.UTF_16));
            int stride = TStringUnsafe.COMPACT_STRINGS_ENABLED ? Stride.fromCodeRangeUTF16(a.codeRange()) : 1;
            if (reuseProfile.profile(node, a instanceof TruffleString && arrayA instanceof byte[] && a.length() << a.stride() == ((byte[])arrayA).length && a.stride() == stride)) {
                assert (a.offset() == 0);
                bytes = (byte[])arrayA;
            } else {
                bytes = new byte[a.length() << stride];
                TStringOps.arraycopyWithStride(node, arrayA, a.offset(), a.stride(), 0, bytes, 0, stride, 0, a.length());
            }
            return TStringUnsafe.createJavaString(bytes, stride);
        }
    }

    static abstract class FromJavaStringUTF16Node
    extends AbstractInternalNode {
        FromJavaStringUTF16Node() {
        }

        abstract TruffleString execute(Node var1, String var2, int var3, int var4, boolean var5);

        @Specialization
        static TruffleString doNonEmpty(Node node, String javaString, int charOffset, int length2, boolean copy, @Cached InlinedConditionProfile utf16CompactProfile) {
            byte[] array;
            int offset;
            int stride;
            int codePointLength;
            int codeRange;
            AbstractTruffleString.checkArrayRange(javaString.length(), charOffset, length2);
            CompilerAsserts.partialEvaluationConstant(copy);
            if (length2 == 0) {
                return TruffleString.Encoding.UTF_16.getEmpty();
            }
            int strideJS = TStringUnsafe.getJavaStringStride(javaString);
            int offsetJS = charOffset << 1;
            byte[] arrayJS = TStringUnsafe.getJavaStringArray(javaString);
            if (utf16CompactProfile.profile(node, strideJS == 0)) {
                if (length2 == 1) {
                    return TStringConstants.getSingleByte(TruffleString.Encoding.UTF_16, Byte.toUnsignedInt(arrayJS[charOffset]));
                }
                codeRange = TSCodeRange.markImprecise(TSCodeRange.get8Bit());
                codePointLength = length2;
            } else {
                assert (strideJS == 1);
                if (length2 == 1 && TStringOps.readFromByteArray(arrayJS, 1, charOffset) <= 255) {
                    return TStringConstants.getSingleByte(TruffleString.Encoding.UTF_16, TStringOps.readFromByteArray(arrayJS, 1, charOffset));
                }
                if (TStringUnsafe.COMPACT_STRINGS_ENABLED && length2 == javaString.length()) {
                    codePointLength = -1;
                    codeRange = TSCodeRange.markImprecise(TSCodeRange.getBrokenMultiByte());
                } else {
                    long attrs = TStringOps.calcStringAttributesUTF16(node, arrayJS, offsetJS, length2, false);
                    codePointLength = StringAttributes.getCodePointLength(attrs);
                    codeRange = StringAttributes.getCodeRange(attrs);
                }
            }
            if (TStringUnsafe.COMPACT_STRINGS_ENABLED && (!copy || length2 == javaString.length())) {
                stride = strideJS;
                offset = offsetJS;
                array = arrayJS;
            } else {
                stride = Stride.fromCodeRangeUTF16AllowImprecise(codeRange);
                array = new byte[length2 << stride];
                offset = 0;
                if (strideJS == 1 && stride == 0) {
                    TStringOps.arraycopyWithStride(node, arrayJS, offsetJS, 1, 0, array, offset, 0, 0, length2);
                } else {
                    assert (strideJS == stride);
                    TStringOps.arraycopyWithStride(node, arrayJS, offsetJS, 0, 0, array, offset, 0, 0, length2 << stride);
                }
            }
            TruffleString ret = TruffleString.createFromArray(array, offset, length2, stride, TruffleString.Encoding.UTF_16, codePointLength, codeRange);
            if (length2 == javaString.length()) {
                assert (charOffset == 0);
                TruffleString wrapped = TruffleString.createWrapJavaString(javaString, codePointLength, codeRange);
                ret.cacheInsertFirstBeforePublished(wrapped);
            }
            return ret;
        }
    }

    static abstract class ParseDoubleNode
    extends AbstractInternalNode {
        ParseDoubleNode() {
        }

        abstract double execute(Node var1, AbstractTruffleString var2, Object var3) throws TruffleString.NumberFormatException;

        @Specialization(guards={"compaction == cachedCompaction"}, limit="3", unroll=3)
        static double doParse(Node node, AbstractTruffleString a, Object arrayA, @Bind(value="fromStride(a.stride())") TruffleString.CompactionLevel compaction, @Cached(value="compaction") TruffleString.CompactionLevel cachedCompaction, @Cached InlinedBranchProfile errorProfile) throws TruffleString.NumberFormatException {
            return FastDoubleParser.parseDouble(node, a, arrayA, cachedCompaction.getStride(), 0, a.length(), errorProfile);
        }
    }

    static abstract class ParseLongNode
    extends AbstractInternalNode {
        ParseLongNode() {
        }

        abstract long execute(Node var1, AbstractTruffleString var2, Object var3, int var4, TruffleString.Encoding var5, int var6) throws TruffleString.NumberFormatException;

        @Specialization(guards={"is7Bit(codeRangeA)", "compaction == cachedCompaction"}, limit="3", unroll=3)
        static long do7Bit(Node node, AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int radix, @Bind(value="fromStride(a.stride())") TruffleString.CompactionLevel compaction, @Cached(value="compaction") TruffleString.CompactionLevel cachedCompaction, @Cached InlinedBranchProfile errorProfile) throws TruffleString.NumberFormatException {
            return NumberConversion.parseLong7Bit(node, a, arrayA, cachedCompaction.getStride(), radix, errorProfile);
        }

        @Specialization(guards={"!is7Bit(codeRangeA)"})
        static long parseLong(Node node, AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int radix, @Cached TruffleStringIterator.InternalNextNode nextNode, @Cached InlinedBranchProfile errorProfile) throws TruffleString.NumberFormatException {
            return NumberConversion.parseLong(node, AbstractTruffleString.forwardIterator(a, arrayA, codeRangeA, encoding), radix, errorProfile, nextNode);
        }
    }

    static abstract class ParseIntNode
    extends AbstractInternalNode {
        ParseIntNode() {
        }

        abstract int execute(Node var1, AbstractTruffleString var2, Object var3, int var4, TruffleString.Encoding var5, int var6) throws TruffleString.NumberFormatException;

        @Specialization(guards={"is7Bit(codeRangeA)", "compaction == cachedCompaction"}, limit="3", unroll=3)
        static int do7Bit(Node node, AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int radix, @Bind(value="fromStride(a.stride())") TruffleString.CompactionLevel compaction, @Cached(value="compaction") TruffleString.CompactionLevel cachedCompaction, @Cached InlinedBranchProfile errorProfile) throws TruffleString.NumberFormatException {
            return NumberConversion.parseInt7Bit(node, a, arrayA, cachedCompaction.getStride(), radix, errorProfile);
        }

        @Specialization(guards={"!is7Bit(codeRangeA)"})
        static int doGeneric(Node node, AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int radix, @Cached TruffleStringIterator.InternalNextNode nextNode, @Cached InlinedBranchProfile errorProfile) throws TruffleString.NumberFormatException {
            return NumberConversion.parseInt(node, AbstractTruffleString.forwardIterator(a, arrayA, codeRangeA, encoding), radix, errorProfile, nextNode);
        }
    }

    static abstract class CalcStringAttributesInnerNode
    extends AbstractInternalNode {
        CalcStringAttributesInnerNode() {
        }

        abstract long execute(Node var1, AbstractTruffleString var2, Object var3, int var4, int var5, int var6, TruffleString.Encoding var7, int var8, int var9);

        @Specialization(guards={"is8Bit(knownCodeRange) || isAsciiBytesOrLatin1(encoding)", "stride == 0"})
        long doLatin1(AbstractTruffleString a, Object array, int offset, int length2, int stride, TruffleString.Encoding encoding, int fromIndex, int knownCodeRange) {
            int codeRange = TStringOps.calcStringAttributesLatin1(this, array, offset + fromIndex, length2);
            return StringAttributes.create(length2, TStringGuards.is8Bit(codeRange) && TStringGuards.isAsciiBytesOrLatin1(encoding) ? TSCodeRange.asciiLatinBytesNonAsciiCodeRange(encoding) : codeRange);
        }

        @Specialization(guards={"isUpTo16Bit(knownCodeRange)", "stride == 1"})
        long doBMP(AbstractTruffleString a, Object array, int offset, int length2, int stride, TruffleString.Encoding encoding, int fromIndex, int knownCodeRange) {
            return StringAttributes.create(length2, TStringOps.calcStringAttributesBMP(this, array, offset + (fromIndex << 1), length2));
        }

        @Specialization(guards={"isUTF8(encoding)", "!isFixedWidth(knownCodeRange)"})
        static long doUTF8(Node node, AbstractTruffleString a, Object array, int offset, int length2, int stride, TruffleString.Encoding encoding, int fromIndex, int knownCodeRange, @Cached.Exclusive @Cached InlinedConditionProfile brokenProfile) {
            assert (stride == 0);
            int off = offset + fromIndex;
            if (TStringGuards.isValid(knownCodeRange) && a != null) {
                return TStringOps.calcStringAttributesUTF8(node, array, off, length2, true, off + length2 == a.offset() + a.length(), brokenProfile);
            }
            return TStringOps.calcStringAttributesUTF8(node, array, off, length2, false, false, brokenProfile);
        }

        @Specialization(guards={"isUTF16(encoding)", "isValid(knownCodeRange)"})
        long doUTF16Valid(AbstractTruffleString a, Object array, int offset, int length2, int stride, TruffleString.Encoding encoding, int fromIndex, int knownCodeRange) {
            assert (stride == 1);
            return TStringOps.calcStringAttributesUTF16(this, array, offset + (fromIndex << 1), length2, true);
        }

        @Specialization(guards={"isUTF16(encoding)", "isBroken(knownCodeRange)"})
        long doUTF16Unknown(AbstractTruffleString a, Object array, int offset, int length2, int stride, TruffleString.Encoding encoding, int fromIndex, int knownCodeRange) {
            assert (stride == 1);
            return TStringOps.calcStringAttributesUTF16(this, array, offset + (fromIndex << 1), length2, false);
        }

        @Specialization(guards={"stride == 2"})
        long doUTF32(AbstractTruffleString a, Object array, int offset, int length2, int stride, TruffleString.Encoding encoding, int fromIndex, int knownCodeRange) {
            assert (TStringGuards.isUTF32(encoding));
            return StringAttributes.create(length2, TStringOps.calcStringAttributesUTF32(this, array, offset + (fromIndex << 2), length2));
        }

        @Specialization(guards={"isUnsupportedEncoding(encoding)"})
        static long doGeneric(Node node, AbstractTruffleString a, Object array, int offset, int length2, int stride, TruffleString.Encoding encoding, int fromIndex, int knownCodeRange, @Cached.Exclusive @Cached InlinedConditionProfile validCharacterProfile, @Cached.Exclusive @Cached InlinedConditionProfile fixedWidthProfile) {
            assert (stride == 0);
            return JCodings.getInstance().calcStringAttributes(node, array, offset, length2, encoding, fromIndex, validCharacterProfile, fixedWidthProfile);
        }
    }

    static abstract class StrideFromCodeRangeNode
    extends AbstractInternalNode {
        StrideFromCodeRangeNode() {
        }

        abstract int execute(Node var1, int var2, TruffleString.Encoding var3);

        @Specialization(guards={"isUTF16(encoding)"})
        int doUTF16(int codeRange, TruffleString.Encoding encoding) {
            return Stride.fromCodeRangeUTF16(codeRange);
        }

        @Specialization(guards={"isUTF32(encoding)"})
        int doUTF32(int codeRange, TruffleString.Encoding encoding) {
            return Stride.fromCodeRangeUTF32(codeRange);
        }

        @Specialization(guards={"!isUTF16(encoding)", "!isUTF32(encoding)"})
        int doOther(int codeRange, TruffleString.Encoding encoding) {
            return 0;
        }
    }

    static abstract class LastIndexOfStringRawNode
    extends AbstractInternalNode {
        LastIndexOfStringRawNode() {
        }

        abstract int execute(Node var1, AbstractTruffleString var2, Object var3, int var4, AbstractTruffleString var5, Object var6, int var7, int var8, int var9, byte[] var10, TruffleString.Encoding var11);

        @Specialization(guards={"isSupportedEncoding(encoding) || isFixedWidth(codeRangeA)"})
        static int lios8SameEncoding(Node node, AbstractTruffleString a, Object arrayA, int codeRangeA, AbstractTruffleString b2, Object arrayB, int codeRangeB, int fromIndex, int toIndex, byte[] mask, TruffleString.Encoding encoding, @Cached TStringOpsNodes.RawLastIndexOfStringNode indexOfStringNode) {
            assert (!b2.isEmpty() && !TStringGuards.indexOfCannotMatch(codeRangeA, b2, codeRangeB, mask, fromIndex - toIndex));
            return indexOfStringNode.execute(node, a, arrayA, b2, arrayB, fromIndex, toIndex, mask);
        }

        @Specialization(guards={"isUnsupportedEncoding(encoding)", "!isFixedWidth(codeRangeA)"})
        static int unsupported(Node node, AbstractTruffleString a, Object arrayA, int codeRangeA, AbstractTruffleString b2, Object arrayB, int codeRangeB, int fromIndex, int toIndex, byte[] mask, TruffleString.Encoding encoding, @Cached TruffleStringIterator.InternalNextNode nextNodeA, @Cached TruffleStringIterator.InternalPreviousNode prevNodeA, @Cached TruffleStringIterator.InternalPreviousNode prevNodeB) {
            assert (mask == null);
            assert (!b2.isEmpty() && !TStringGuards.indexOfCannotMatch(codeRangeA, b2, codeRangeB, mask, fromIndex - toIndex));
            TruffleStringIterator aIt = AbstractTruffleString.forwardIterator(a, arrayA, codeRangeA, encoding);
            TruffleStringIterator bIt = AbstractTruffleString.backwardIterator(b2, arrayB, codeRangeB, encoding);
            return TruffleStringIterator.lastByteIndexOfString(node, aIt, bIt, fromIndex, toIndex, nextNodeA, prevNodeA, prevNodeB);
        }
    }

    static abstract class LastIndexOfStringNode
    extends AbstractInternalNode {
        LastIndexOfStringNode() {
        }

        abstract int execute(Node var1, AbstractTruffleString var2, Object var3, int var4, AbstractTruffleString var5, Object var6, int var7, int var8, int var9, TruffleString.Encoding var10);

        @Specialization(guards={"isFixedWidth(codeRangeA, codeRangeB)"})
        static int direct(Node node, AbstractTruffleString a, Object arrayA, int codeRangeA, AbstractTruffleString b2, Object arrayB, int codeRangeB, int fromIndex, int toIndex, TruffleString.Encoding encoding, @Cached TStringOpsNodes.RawLastIndexOfStringNode indexOfStringNode) {
            assert (!b2.isEmpty() && !TStringGuards.indexOfCannotMatch(node, codeRangeA, b2, codeRangeB, fromIndex - toIndex, encoding, GetCodePointLengthNode.getUncached()));
            return indexOfStringNode.execute(node, a, arrayA, b2, arrayB, fromIndex, toIndex, null);
        }

        @Specialization(guards={"!isFixedWidth(codeRangeA, codeRangeB)"})
        static int decode(Node node, AbstractTruffleString a, Object arrayA, int codeRangeA, AbstractTruffleString b2, Object arrayB, int codeRangeB, int fromIndex, int toIndex, TruffleString.Encoding encoding, @Cached TruffleStringIterator.InternalNextNode nextNodeA, @Cached TruffleStringIterator.InternalPreviousNode prevNodeA, @Cached TruffleStringIterator.InternalPreviousNode prevNodeB) {
            assert (!b2.isEmpty() && !TStringGuards.indexOfCannotMatch(node, codeRangeA, b2, codeRangeB, fromIndex - toIndex, encoding, GetCodePointLengthNode.getUncached()));
            TruffleStringIterator aIt = AbstractTruffleString.forwardIterator(a, arrayA, codeRangeA, encoding);
            TruffleStringIterator bIt = AbstractTruffleString.backwardIterator(b2, arrayB, codeRangeB, encoding);
            return TruffleStringIterator.lastIndexOfString(node, aIt, bIt, fromIndex, toIndex, nextNodeA, prevNodeA, prevNodeB);
        }
    }

    static abstract class IndexOfStringRawNode
    extends AbstractInternalNode {
        IndexOfStringRawNode() {
        }

        abstract int execute(Node var1, AbstractTruffleString var2, Object var3, int var4, AbstractTruffleString var5, Object var6, int var7, int var8, int var9, byte[] var10, TruffleString.Encoding var11);

        @Specialization(guards={"isSupportedEncoding(encoding) || isFixedWidth(codeRangeA)"})
        static int supported(Node node, AbstractTruffleString a, Object arrayA, int codeRangeA, AbstractTruffleString b2, Object arrayB, int codeRangeB, int fromIndex, int toIndex, byte[] mask, TruffleString.Encoding encoding, @Cached TStringOpsNodes.RawIndexOfStringNode indexOfStringNode) {
            assert (!b2.isEmpty() && !TStringGuards.indexOfCannotMatch(codeRangeA, b2, codeRangeB, mask, toIndex - fromIndex));
            return indexOfStringNode.execute(node, a, arrayA, b2, arrayB, fromIndex, toIndex, mask);
        }

        @Specialization(guards={"isUnsupportedEncoding(encoding)", "!isFixedWidth(codeRangeA)"})
        static int unsupported(Node node, AbstractTruffleString a, Object arrayA, int codeRangeA, AbstractTruffleString b2, Object arrayB, int codeRangeB, int fromIndex, int toIndex, byte[] mask, TruffleString.Encoding encoding, @Cached TruffleStringIterator.InternalNextNode nextNodeA, @Cached TruffleStringIterator.InternalNextNode nextNodeB) {
            assert (mask == null);
            assert (!b2.isEmpty() && !TStringGuards.indexOfCannotMatch(codeRangeA, b2, codeRangeB, mask, toIndex - fromIndex));
            TruffleStringIterator aIt = AbstractTruffleString.forwardIterator(a, arrayA, codeRangeA, encoding);
            TruffleStringIterator bIt = AbstractTruffleString.forwardIterator(b2, arrayB, codeRangeB, encoding);
            return TruffleStringIterator.byteIndexOfString(node, aIt, bIt, fromIndex, toIndex, nextNodeA, nextNodeB);
        }
    }

    static abstract class InternalIndexOfStringNode
    extends AbstractInternalNode {
        InternalIndexOfStringNode() {
        }

        abstract int execute(Node var1, AbstractTruffleString var2, Object var3, int var4, AbstractTruffleString var5, Object var6, int var7, int var8, int var9, TruffleString.Encoding var10);

        @Specialization(guards={"isFixedWidth(codeRangeA, codeRangeB)"})
        static int direct(Node node, AbstractTruffleString a, Object arrayA, int codeRangeA, AbstractTruffleString b2, Object arrayB, int codeRangeB, int fromIndex, int toIndex, TruffleString.Encoding encoding, @Cached TStringOpsNodes.RawIndexOfStringNode indexOfStringNode) {
            assert (!b2.isEmpty() && !TStringGuards.indexOfCannotMatch(node, codeRangeA, b2, codeRangeB, toIndex - fromIndex, encoding, GetCodePointLengthNode.getUncached()));
            return indexOfStringNode.execute(node, a, arrayA, b2, arrayB, fromIndex, toIndex, null);
        }

        @Specialization(guards={"!isFixedWidth(codeRangeA, codeRangeB)"})
        static int decode(Node node, AbstractTruffleString a, Object arrayA, int codeRangeA, AbstractTruffleString b2, Object arrayB, int codeRangeB, int fromIndex, int toIndex, TruffleString.Encoding encoding, @Cached TruffleStringIterator.InternalNextNode nextNodeA, @Cached TruffleStringIterator.InternalNextNode nextNodeB) {
            assert (!b2.isEmpty() && !TStringGuards.indexOfCannotMatch(node, codeRangeA, b2, codeRangeB, toIndex - fromIndex, encoding, GetCodePointLengthNode.getUncached()));
            TruffleStringIterator aIt = AbstractTruffleString.forwardIterator(a, arrayA, codeRangeA, encoding);
            TruffleStringIterator bIt = AbstractTruffleString.forwardIterator(b2, arrayB, codeRangeB, encoding);
            return TruffleStringIterator.indexOfString(node, aIt, bIt, fromIndex, toIndex, nextNodeA, nextNodeB);
        }
    }

    static abstract class RegionEqualsNode
    extends AbstractInternalNode {
        RegionEqualsNode() {
        }

        abstract boolean execute(Node var1, AbstractTruffleString var2, Object var3, int var4, int var5, AbstractTruffleString var6, Object var7, int var8, int var9, int var10, TruffleString.Encoding var11);

        @Specialization(guards={"isFixedWidth(codeRangeA, codeRangeB)"})
        boolean direct(AbstractTruffleString a, Object arrayA, int codeRangeA, int fromIndexA, AbstractTruffleString b2, Object arrayB, int codeRangeB, int fromIndexB, int length2, TruffleString.Encoding encoding) {
            return TStringOps.regionEqualsWithOrMaskWithStride(this, a, arrayA, a.stride(), fromIndexA, b2, arrayB, b2.stride(), fromIndexB, null, length2);
        }

        @Specialization(guards={"!isFixedWidth(codeRangeA, codeRangeB)"})
        static boolean decode(Node node, AbstractTruffleString a, Object arrayA, int codeRangeA, int fromIndexA, AbstractTruffleString b2, Object arrayB, int codeRangeB, int fromIndexB, int length2, TruffleString.Encoding encoding, @Cached TruffleStringIterator.InternalNextNode nextNodeA, @Cached TruffleStringIterator.InternalNextNode nextNodeB) {
            int i;
            TruffleStringIterator aIt = AbstractTruffleString.forwardIterator(a, arrayA, codeRangeA, encoding);
            TruffleStringIterator bIt = AbstractTruffleString.forwardIterator(b2, arrayB, codeRangeB, encoding);
            for (i = 0; i < fromIndexA; ++i) {
                if (!aIt.hasNext()) {
                    return false;
                }
                nextNodeA.execute(node, aIt);
                TStringConstants.truffleSafePointPoll(node, i + 1);
            }
            for (i = 0; i < fromIndexB; ++i) {
                if (!bIt.hasNext()) {
                    return false;
                }
                nextNodeB.execute(node, bIt);
                TStringConstants.truffleSafePointPoll(node, i + 1);
            }
            for (i = 0; i < length2; ++i) {
                if (!aIt.hasNext() || !bIt.hasNext() || nextNodeA.execute(node, aIt) != nextNodeB.execute(node, bIt)) {
                    return false;
                }
                TStringConstants.truffleSafePointPoll(node, i + 1);
            }
            return true;
        }
    }

    static abstract class ConcatMaterializeBytesNode
    extends AbstractInternalNode {
        ConcatMaterializeBytesNode() {
        }

        abstract byte[] execute(Node var1, AbstractTruffleString var2, Object var3, AbstractTruffleString var4, Object var5, TruffleString.Encoding var6, int var7, int var8);

        @Specialization(guards={"isUTF16(encoding) || isUTF32(encoding)"})
        byte[] doWithCompression(AbstractTruffleString a, Object arrayA, AbstractTruffleString b2, Object arrayB, TruffleString.Encoding encoding, int concatLength, int concatStride) {
            byte[] bytes = new byte[concatLength << concatStride];
            TStringOps.arraycopyWithStride(this, arrayA, a.offset(), a.stride(), 0, bytes, 0, concatStride, 0, a.length());
            TStringOps.arraycopyWithStride(this, arrayB, b2.offset(), b2.stride(), 0, bytes, 0, concatStride, a.length(), b2.length());
            return bytes;
        }

        @Specialization(guards={"!isUTF16(encoding)", "!isUTF32(encoding)"})
        byte[] doNoCompression(AbstractTruffleString a, Object arrayA, AbstractTruffleString b2, Object arrayB, TruffleString.Encoding encoding, int concatLength, int concatStride) {
            assert (TStringGuards.isStride0(a));
            assert (TStringGuards.isStride0(b2));
            assert (concatStride == 0);
            byte[] bytes = new byte[concatLength];
            TStringOps.arraycopyWithStride(this, arrayA, a.offset(), 0, 0, bytes, 0, 0, 0, a.length());
            TStringOps.arraycopyWithStride(this, arrayB, b2.offset(), 0, 0, bytes, 0, 0, a.length(), b2.length());
            return bytes;
        }
    }

    static abstract class ConcatEagerNode
    extends AbstractInternalNode {
        ConcatEagerNode() {
        }

        abstract TruffleString execute(Node var1, AbstractTruffleString var2, AbstractTruffleString var3, TruffleString.Encoding var4, int var5, int var6, int var7);

        @Specialization
        static TruffleString concat(Node node, AbstractTruffleString a, AbstractTruffleString b2, TruffleString.Encoding encoding, int concatLength, int concatStride, int concatCodeRange, @Cached TruffleString.ToIndexableNode toIndexableNodeA, @Cached TruffleString.ToIndexableNode toIndexableNodeB, @Cached GetCodePointLengthNode getCodePointLengthANode, @Cached GetCodePointLengthNode getCodePointLengthBNode, @Cached ConcatMaterializeBytesNode materializeBytesNode, @Cached CalcStringAttributesNode calculateAttributesNode, @Cached InlinedConditionProfile brokenProfile) {
            int codeRange;
            int codePointLength;
            byte[] bytes = materializeBytesNode.execute(node, a, toIndexableNodeA.execute(node, a, a.data()), b2, toIndexableNodeB.execute(node, b2, b2.data()), encoding, concatLength, concatStride);
            if (brokenProfile.profile(node, TStringGuards.isBrokenMultiByte(concatCodeRange))) {
                long attrs = calculateAttributesNode.execute(node, null, bytes, 0, concatLength, concatStride, encoding, 0, TSCodeRange.getBrokenMultiByte());
                codePointLength = StringAttributes.getCodePointLength(attrs);
                codeRange = StringAttributes.getCodeRange(attrs);
            } else {
                codePointLength = getCodePointLengthANode.execute(node, a, encoding) + getCodePointLengthBNode.execute(node, b2, encoding);
                codeRange = concatCodeRange;
            }
            return TruffleString.createFromByteArray(bytes, concatLength, concatStride, encoding, codePointLength, codeRange);
        }
    }

    static abstract class SubstringNode
    extends AbstractInternalNode {
        SubstringNode() {
        }

        abstract TruffleString execute(Node var1, AbstractTruffleString var2, Object var3, int var4, TruffleString.Encoding var5, int var6, int var7, boolean var8);

        @Specialization(guards={"length == 0"})
        static TruffleString lengthZero(AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int fromIndex, int length2, boolean lazy) {
            return encoding.getEmpty();
        }

        @Specialization(guards={"fromIndex == 0", "length == length(a)"})
        static TruffleString sameStr(TruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int fromIndex, int length2, boolean lazy) {
            return a;
        }

        @Specialization(guards={"length > 0", "length != length(a) || a.isMutable()", "!lazy"})
        static TruffleString materializeSubstring(Node node, AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int fromIndex, int length2, boolean lazy, @Cached.Shared(value="attributes") @Cached CalcStringAttributesNode calcAttributesNode, @Cached.Exclusive @Cached InlinedConditionProfile utf16Profile, @Cached.Exclusive @Cached InlinedConditionProfile utf32Profile) {
            int newStride;
            int codeRange;
            long attrs;
            int stride;
            if (utf16Profile.profile(node, TStringGuards.isUTF16(encoding))) {
                stride = a.stride();
                attrs = calcAttributesNode.execute(node, a, arrayA, a.offset(), length2, stride, TruffleString.Encoding.UTF_16, fromIndex, codeRangeA);
                codeRange = StringAttributes.getCodeRange(attrs);
                newStride = Stride.fromCodeRangeUTF16(codeRange);
            } else if (utf32Profile.profile(node, TStringGuards.isUTF32(encoding))) {
                stride = a.stride();
                attrs = calcAttributesNode.execute(node, a, arrayA, a.offset(), length2, stride, TruffleString.Encoding.UTF_32, fromIndex, codeRangeA);
                codeRange = StringAttributes.getCodeRange(attrs);
                newStride = Stride.fromCodeRangeUTF32(codeRange);
            } else {
                stride = 0;
                attrs = calcAttributesNode.execute(node, a, arrayA, a.offset(), length2, stride, encoding, fromIndex, codeRangeA);
                codeRange = StringAttributes.getCodeRange(attrs);
                newStride = 0;
            }
            byte[] newBytes = TStringOps.arraycopyOfWithStride(node, arrayA, a.offset() + (fromIndex << stride), length2, stride, length2, newStride);
            return TruffleString.createFromByteArray(newBytes, length2, newStride, encoding, StringAttributes.getCodePointLength(attrs), codeRange);
        }

        @Specialization(guards={"length > 0", "length != length(a)", "lazy"})
        static TruffleString createLazySubstring(Node node, TruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int fromIndex, int length2, boolean lazy, @Cached.Shared(value="attributes") @Cached CalcStringAttributesNode calcAttributesNode, @Cached.Exclusive @Cached InlinedConditionProfile stride1MustMaterializeProfile, @Cached.Exclusive @Cached InlinedConditionProfile stride2MustMaterializeProfile) {
            Object array;
            int offset;
            int stride;
            int lazyOffset = a.offset() + (fromIndex << a.stride());
            long attrs = calcAttributesNode.execute(node, a, arrayA, a.offset(), length2, a.stride(), encoding, fromIndex, codeRangeA);
            int codeRange = StringAttributes.getCodeRange(attrs);
            int codePointLength = StringAttributes.getCodePointLength(attrs);
            if (stride1MustMaterializeProfile.profile(node, a.stride() == 1 && TSCodeRange.isMoreRestrictiveOrEqual(codeRange, TSCodeRange.get8Bit()))) {
                assert (TStringGuards.isUTF16Or32(encoding));
                stride = 0;
                offset = 0;
                byte[] newBytes = new byte[length2];
                TStringOps.arraycopyWithStride(node, arrayA, lazyOffset, 1, 0, newBytes, offset, 0, 0, length2);
                array = newBytes;
            } else if (stride2MustMaterializeProfile.profile(node, a.stride() == 2 && TSCodeRange.isMoreRestrictiveOrEqual(codeRange, TSCodeRange.get16Bit()))) {
                assert (TStringGuards.isUTF32(encoding));
                stride = Stride.fromCodeRangeUTF32(StringAttributes.getCodeRange(attrs));
                offset = 0;
                byte[] newBytes = new byte[length2 << stride];
                if (stride == 0) {
                    TStringOps.arraycopyWithStride(node, arrayA, lazyOffset, 2, 0, newBytes, offset, 0, 0, length2);
                } else {
                    assert (stride == 1);
                    TStringOps.arraycopyWithStride(node, arrayA, lazyOffset, 2, 0, newBytes, offset, 1, 0, length2);
                }
                array = newBytes;
            } else {
                array = TStringGuards.isUnsupportedEncoding(encoding) && arrayA instanceof AbstractTruffleString.NativePointer ? ((AbstractTruffleString.NativePointer)arrayA).copy() : arrayA;
                offset = lazyOffset;
                stride = a.stride();
            }
            return TruffleString.createFromArray(array, offset, length2, stride, encoding, codePointLength, codeRange);
        }
    }

    @ImportStatic(value={TStringGuards.class, TruffleString.Encoding.class})
    static abstract class IndexOfCodePointSetNode
    extends Node {
        static final int POSSIBLE_STRIDE_VALUES = 3;
        @Node.Children
        IndexOfCodePointSet.IndexOfNode[] indexOfNodes;
        final TruffleString.Encoding encoding;
        final boolean isUTF16Or32;

        IndexOfCodePointSetNode(IndexOfCodePointSet.IndexOfNode[] indexOfNodes, TruffleString.Encoding encoding) {
            this.indexOfNodes = this.insert(indexOfNodes);
            this.encoding = encoding;
            this.isUTF16Or32 = TStringGuards.isUTF16Or32(encoding);
        }

        abstract int execute(Object var1, int var2, int var3, int var4, int var5, int var6, int var7);

        @Specialization(guards={"!isUTF16Or32"})
        int stride0(Object arrayA, int offsetA, int lengthA, int strideA, int codeRangeA, int fromIndex, int toIndex) {
            return this.doIndexOf(arrayA, offsetA, lengthA, 0, codeRangeA, fromIndex, toIndex);
        }

        @Specialization(guards={"isUTF16Or32", "strideA == cachedStride"}, limit="POSSIBLE_STRIDE_VALUES")
        int dynamicStride(Object arrayA, int offsetA, int lengthA, int strideA, int codeRangeA, int fromIndex, int toIndex, @Cached(value="strideA", allowUncached=true) int cachedStride) {
            return this.doIndexOf(arrayA, offsetA, lengthA, cachedStride, codeRangeA, fromIndex, toIndex);
        }

        @ExplodeLoop
        private int doIndexOf(Object arrayA, int offsetA, int lengthA, int strideA, int codeRangeA, int fromIndex, int toIndex) {
            CompilerAsserts.partialEvaluationConstant(this.indexOfNodes);
            for (int i = 0; i < this.indexOfNodes.length - 1; ++i) {
                CompilerAsserts.partialEvaluationConstant(i);
                IndexOfCodePointSet.IndexOfNode node = this.indexOfNodes[i];
                CompilerAsserts.partialEvaluationConstant(node);
                if (!TSCodeRange.isMoreRestrictiveOrEqual(codeRangeA, Byte.toUnsignedInt(node.maxCodeRange))) continue;
                return node.execute(this, arrayA, offsetA, lengthA, strideA, codeRangeA, fromIndex, toIndex, this.encoding);
            }
            return this.indexOfNodes[this.indexOfNodes.length - 1].execute(this, arrayA, offsetA, lengthA, strideA, codeRangeA, fromIndex, toIndex, this.encoding);
        }
    }

    static abstract class LastIndexOfCodePointRawNode
    extends AbstractInternalNode {
        LastIndexOfCodePointRawNode() {
        }

        abstract int execute(Node var1, AbstractTruffleString var2, Object var3, int var4, TruffleString.Encoding var5, int var6, int var7, int var8);

        @Specialization(guards={"isFixedWidth(codeRangeA)"})
        static int utf8Fixed(Node node, AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int codepoint, int fromIndex, int toIndex, @Cached @Cached.Shared(value="lastIndexOfNode") TStringOpsNodes.RawLastIndexOfCodePointNode lastIndexOfNode) {
            return TStringInternalNodes.lastIndexOfFixedWidth(node, a, arrayA, codeRangeA, codepoint, fromIndex, toIndex, lastIndexOfNode);
        }

        @Specialization(guards={"isUTF8(encoding)", "!isFixedWidth(codeRangeA)"})
        static int utf8Variable(Node node, AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int codepoint, int fromIndex, int toIndex, @Cached @Cached.Shared(value="lastIndexOfNode") TStringOpsNodes.RawLastIndexOfCodePointNode lastIndexOfNode) {
            int encodedSize = Encodings.utf8EncodedSize(codepoint);
            if (encodedSize > fromIndex - toIndex) {
                return -1;
            }
            if (encodedSize == 1) {
                return TStringInternalNodes.lastIndexOfFixedWidth(node, a, arrayA, codeRangeA, codepoint, fromIndex, toIndex, lastIndexOfNode);
            }
            byte[] encoded = Encodings.utf8EncodeNonAscii(codepoint, encodedSize);
            TruffleString b2 = TruffleString.createFromByteArray(encoded, encoded.length, 0, TruffleString.Encoding.UTF_8, 1, TSCodeRange.getValidMultiByte());
            return TStringOps.lastIndexOfStringWithOrMaskWithStride(node, a, arrayA, 0, b2, encoded, 0, fromIndex, toIndex, null);
        }

        @Specialization(guards={"isUTF16(encoding)", "!isFixedWidth(codeRangeA)"})
        static int utf16Variable(Node node, AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int codepoint, int fromIndex, int toIndex, @Cached @Cached.Shared(value="lastIndexOfNode") TStringOpsNodes.RawLastIndexOfCodePointNode lastIndexOfNode) {
            assert (TStringGuards.isStride1(a));
            int encodedSize = Encodings.utf16EncodedSize(codepoint);
            if (encodedSize > fromIndex - toIndex) {
                return -1;
            }
            if (encodedSize == 1) {
                return TStringInternalNodes.lastIndexOfFixedWidth(node, a, arrayA, codeRangeA, codepoint, fromIndex, toIndex, lastIndexOfNode);
            }
            return TStringOps.lastIndexOf2ConsecutiveWithOrMaskWithStride(node, a, arrayA, 1, fromIndex, toIndex, Character.highSurrogate(codepoint), Character.lowSurrogate(codepoint), 0, 0);
        }

        @Specialization(guards={"isUnsupportedEncoding(encoding)", "!isFixedWidth(codeRangeA)"})
        static int unsupported(Node node, AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int codepoint, int fromIndex, int toIndex, @Cached TruffleStringIterator.InternalPreviousNode prevNode) {
            TruffleStringIterator it = TruffleString.backwardIterator(a, arrayA, codeRangeA, encoding);
            it.setRawIndex(fromIndex);
            int loopCount = 0;
            while (it.hasPrevious() && it.getRawIndex() >= toIndex) {
                if (prevNode.execute(node, it) == codepoint) {
                    return it.getRawIndex();
                }
                TStringConstants.truffleSafePointPoll(node, ++loopCount);
            }
            return -1;
        }
    }

    static abstract class LastIndexOfCodePointNode
    extends AbstractInternalNode {
        LastIndexOfCodePointNode() {
        }

        abstract int execute(Node var1, AbstractTruffleString var2, Object var3, int var4, TruffleString.Encoding var5, int var6, int var7, int var8);

        @Specialization(guards={"isFixedWidth(codeRangeA)"})
        static int doFixedWidth(Node node, AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int codepoint, int fromIndex, int toIndex, @Cached TStringOpsNodes.RawLastIndexOfCodePointNode lastIndexOfNode) {
            return TStringInternalNodes.lastIndexOfFixedWidth(node, a, arrayA, codeRangeA, codepoint, fromIndex, toIndex, lastIndexOfNode);
        }

        @Specialization(guards={"!isFixedWidth(codeRangeA)"})
        static int decode(Node node, AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int codepoint, int fromIndex, int toIndex, @Cached TruffleStringIterator.InternalNextNode nextNode) {
            return TruffleStringIterator.lastIndexOf(node, AbstractTruffleString.forwardIterator(a, arrayA, codeRangeA, encoding), codepoint, fromIndex, toIndex, nextNode);
        }
    }

    static abstract class IndexOfCodePointRawNode
    extends AbstractInternalNode {
        IndexOfCodePointRawNode() {
        }

        abstract int execute(Node var1, AbstractTruffleString var2, Object var3, int var4, TruffleString.Encoding var5, int var6, int var7, int var8);

        @Specialization(guards={"isFixedWidth(codeRangeA)"})
        static int utf8Fixed(Node node, AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int codepoint, int fromIndex, int toIndex, @Cached TStringOpsNodes.RawIndexOfCodePointNode indexOfNode) {
            return TStringInternalNodes.indexOfFixedWidth(node, a, arrayA, codeRangeA, codepoint, fromIndex, toIndex, indexOfNode);
        }

        @Specialization(guards={"isUTF8(encoding)", "!isFixedWidth(codeRangeA)"})
        int utf8Variable(AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int codepoint, int fromIndex, int toIndex) {
            assert (TStringGuards.isStride0(a));
            int encodedSize = Encodings.utf8EncodedSize(codepoint);
            if (encodedSize > toIndex - fromIndex) {
                return -1;
            }
            if (encodedSize == 1) {
                return TStringOps.indexOfCodePointWithStride(this, a, arrayA, 0, fromIndex, toIndex, codepoint);
            }
            byte[] encoded = Encodings.utf8EncodeNonAscii(codepoint, encodedSize);
            TruffleString b2 = TruffleString.createFromByteArray(encoded, encoded.length, 0, TruffleString.Encoding.UTF_8, 1, TSCodeRange.getValidMultiByte());
            return TStringOps.indexOfStringWithOrMaskWithStride(this, a, arrayA, 0, b2, encoded, 0, fromIndex, toIndex, null);
        }

        @Specialization(guards={"isUTF16(encoding)", "!isFixedWidth(codeRangeA)"})
        int utf16Variable(AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int codepoint, int fromIndex, int toIndex) {
            assert (TStringGuards.isStride1(a));
            int encodedSize = Encodings.utf16EncodedSize(codepoint);
            if (encodedSize > toIndex - fromIndex) {
                return -1;
            }
            if (encodedSize == 1) {
                return TStringOps.indexOfCodePointWithStride(this, a, arrayA, 1, fromIndex, toIndex, codepoint);
            }
            return TStringOps.indexOf2ConsecutiveWithStride(this, a, arrayA, 1, fromIndex, toIndex, Character.highSurrogate(codepoint), Character.lowSurrogate(codepoint));
        }

        @Specialization(guards={"isUnsupportedEncoding(encoding)", "!isFixedWidth(codeRangeA)"})
        static int unsupported(Node node, AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int codepoint, int fromIndex, int toIndex, @Cached TruffleStringIterator.InternalNextNode nextNode) {
            TruffleStringIterator it = AbstractTruffleString.forwardIterator(a, arrayA, codeRangeA, encoding);
            it.setRawIndex(fromIndex);
            int loopCount = 0;
            while (it.hasNext() && it.getRawIndex() < toIndex) {
                int ret = it.getRawIndex();
                if (nextNode.execute(node, it) == codepoint) {
                    return ret;
                }
                TStringConstants.truffleSafePointPoll(node, ++loopCount);
            }
            return -1;
        }
    }

    static abstract class IndexOfCodePointNode
    extends AbstractInternalNode {
        IndexOfCodePointNode() {
        }

        abstract int execute(Node var1, AbstractTruffleString var2, Object var3, int var4, TruffleString.Encoding var5, int var6, int var7, int var8);

        @Specialization(guards={"isFixedWidth(codeRangeA)"})
        static int doFixedWidth(Node node, AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int codepoint, int fromIndex, int toIndex, @Cached TStringOpsNodes.RawIndexOfCodePointNode indexOfNode) {
            return TStringInternalNodes.indexOfFixedWidth(node, a, arrayA, codeRangeA, codepoint, fromIndex, toIndex, indexOfNode);
        }

        @Specialization(guards={"!isFixedWidth(codeRangeA)"})
        static int decode(Node node, AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int codepoint, int fromIndex, int toIndex, @Cached TruffleStringIterator.InternalNextNode nextNode) {
            return TruffleStringIterator.indexOf(node, AbstractTruffleString.forwardIterator(a, arrayA, codeRangeA, encoding), codepoint, fromIndex, toIndex, nextNode);
        }
    }

    static abstract class CodePointAtRawNode
    extends AbstractInternalNode {
        CodePointAtRawNode() {
        }

        abstract int execute(Node var1, AbstractTruffleString var2, Object var3, int var4, TruffleString.Encoding var5, int var6, TruffleString.ErrorHandling var7);

        @Specialization(guards={"isUTF16(encoding)"})
        static int utf16(Node node, AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int i, TruffleString.ErrorHandling errorHandling, @Cached InlinedConditionProfile fixedWidthProfile, @Cached InlinedConditionProfile validProfile, @Cached.Shared(value="stride0") @Cached InlinedConditionProfile stride0Profile) {
            if (fixedWidthProfile.profile(node, TStringGuards.isFixedWidth(codeRangeA))) {
                if (stride0Profile.profile(node, TStringGuards.isStride0(a))) {
                    return TStringOps.readS0(a, arrayA, i);
                }
                assert (TStringGuards.isStride1(a));
                return TStringOps.readS1(a, arrayA, i);
            }
            if (validProfile.profile(node, TStringGuards.isValid(codeRangeA))) {
                return Encodings.utf16DecodeValid(a, arrayA, i);
            }
            assert (TStringGuards.isBroken(codeRangeA));
            return Encodings.utf16DecodeBroken(a, arrayA, i, errorHandling);
        }

        @Specialization(guards={"isUTF32(encoding)"})
        static int utf32(Node node, AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int i, TruffleString.ErrorHandling errorHandling, @Cached.Shared(value="stride0") @Cached InlinedConditionProfile stride0Profile, @Cached.Exclusive @Cached InlinedConditionProfile stride1Profile) {
            if (stride0Profile.profile(node, TStringGuards.isStride0(a))) {
                return TStringOps.readS0(a, arrayA, i);
            }
            if (stride1Profile.profile(node, TStringGuards.isStride1(a))) {
                char c = TStringOps.readS1(a, arrayA, i);
                if (errorHandling == TruffleString.ErrorHandling.RETURN_NEGATIVE && Encodings.isUTF16Surrogate(c)) {
                    return -1;
                }
                return c;
            }
            assert (TStringGuards.isStride2(a));
            int c = TStringOps.readS2(a, arrayA, i);
            if (errorHandling == TruffleString.ErrorHandling.RETURN_NEGATIVE && !Encodings.isValidUnicodeCodepoint(c)) {
                return -1;
            }
            return c;
        }

        @Specialization(guards={"isUTF8(encoding)"})
        static int utf8(Node node, AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int i, TruffleString.ErrorHandling errorHandling, @Cached.Exclusive @Cached InlinedConditionProfile fixedWidthProfile, @Cached.Exclusive @Cached InlinedConditionProfile validProfile) {
            if (fixedWidthProfile.profile(node, TStringGuards.is7Bit(codeRangeA))) {
                return TStringOps.readS0(a, arrayA, i);
            }
            if (validProfile.profile(node, TStringGuards.isValid(codeRangeA))) {
                return Encodings.utf8DecodeValid(a, arrayA, i);
            }
            assert (TStringGuards.isBroken(codeRangeA));
            return Encodings.utf8DecodeBroken(a, arrayA, i, errorHandling);
        }

        @Specialization(guards={"!isUTF16Or32(encoding)", "!isUTF8(encoding)", "isBytes(encoding) || is7Or8Bit(codeRangeA)"})
        static int doFixed(AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int i, TruffleString.ErrorHandling errorHandling) {
            assert (TStringGuards.isStride0(a));
            return TStringOps.readS0(a, arrayA, i);
        }

        @Specialization(guards={"isAscii(encoding)", "!is7Or8Bit(codeRangeA)"})
        static int doAsciiBroken(AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int i, TruffleString.ErrorHandling errorHandling) {
            assert (TStringGuards.isStride0(a));
            int c = TStringOps.readS0(a, arrayA, i);
            if (errorHandling == TruffleString.ErrorHandling.RETURN_NEGATIVE && c > 127) {
                return -1;
            }
            assert (errorHandling == TruffleString.ErrorHandling.BEST_EFFORT || !TSCodeRange.isPrecise(codeRangeA));
            return c;
        }

        @Specialization(guards={"isUnsupportedEncoding(encoding)", "!is7Or8Bit(codeRangeA)"})
        static int unsupported(AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int i, TruffleString.ErrorHandling errorHandling) {
            return JCodings.getInstance().decode(a, JCodings.asByteArray(arrayA), i, JCodings.getInstance().get(encoding), errorHandling);
        }
    }

    static abstract class CodePointAtNode
    extends AbstractInternalNode {
        CodePointAtNode() {
        }

        abstract int execute(Node var1, AbstractTruffleString var2, Object var3, int var4, TruffleString.Encoding var5, int var6, TruffleString.ErrorHandling var7);

        @Specialization(guards={"isUTF16(encoding)"})
        static int utf16(Node node, AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int i, TruffleString.ErrorHandling errorHandling, @Cached InlinedConditionProfile fixedWidthProfile, @Cached.Shared(value="stride0") @Cached InlinedConditionProfile stride0Profile, @Cached.Shared(value="valid") @Cached InlinedConditionProfile validProfile) {
            if (fixedWidthProfile.profile(node, TStringGuards.isFixedWidth(codeRangeA))) {
                if (stride0Profile.profile(node, TStringGuards.isStride0(a))) {
                    return TStringOps.readS0(a, arrayA, i);
                }
                assert (TStringGuards.isStride1(a));
                return TStringOps.readS1(a, arrayA, i);
            }
            if (validProfile.profile(node, TStringGuards.isValid(codeRangeA))) {
                assert (TStringGuards.isStride1(a));
                return Encodings.utf16DecodeValid(a, arrayA, Encodings.utf16ValidCodePointToCharIndex(node, a, arrayA, i));
            }
            assert (TStringGuards.isStride1(a));
            assert (TStringGuards.isBroken(codeRangeA));
            return Encodings.utf16DecodeBroken(a, arrayA, Encodings.utf16BrokenCodePointToCharIndex(node, a, arrayA, i), errorHandling);
        }

        @Specialization(guards={"isUTF32(encoding)"})
        static int utf32(Node node, AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int i, TruffleString.ErrorHandling errorHandling, @Cached.Shared(value="stride0") @Cached InlinedConditionProfile stride0Profile, @Cached.Exclusive @Cached InlinedConditionProfile stride1Profile) {
            return CodePointAtRawNode.utf32(node, a, arrayA, codeRangeA, encoding, i, errorHandling, stride0Profile, stride1Profile);
        }

        @Specialization(guards={"isUTF8(encoding)"})
        static int utf8(Node node, AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int i, TruffleString.ErrorHandling errorHandling, @Cached.Exclusive @Cached InlinedConditionProfile fixedWidthProfile, @Cached.Shared(value="valid") @Cached InlinedConditionProfile validProfile) {
            if (fixedWidthProfile.profile(node, TStringGuards.is7Bit(codeRangeA))) {
                return TStringOps.readS0(a, arrayA, i);
            }
            int byteIndex = Encodings.utf8CodePointToByteIndex(node, a, arrayA, i);
            if (validProfile.profile(node, TStringGuards.isValid(codeRangeA))) {
                return Encodings.utf8DecodeValid(a, arrayA, byteIndex);
            }
            assert (TStringGuards.isBroken(codeRangeA));
            return Encodings.utf8DecodeBroken(a, arrayA, byteIndex, errorHandling);
        }

        @Specialization(guards={"!isUTF16Or32(encoding)", "!isUTF8(encoding)", "isBytes(encoding) || is7Or8Bit(codeRangeA)"})
        static int doFixed(AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int i, TruffleString.ErrorHandling errorHandling) {
            return CodePointAtRawNode.doFixed(a, arrayA, codeRangeA, encoding, i, errorHandling);
        }

        @Specialization(guards={"isAscii(encoding)", "!is7Or8Bit(codeRangeA)"})
        static int doAsciiBroken(AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int i, TruffleString.ErrorHandling errorHandling) {
            return CodePointAtRawNode.doAsciiBroken(a, arrayA, codeRangeA, encoding, i, errorHandling);
        }

        @Specialization(guards={"isUnsupportedEncoding(encoding)", "!is7Or8Bit(codeRangeA)"})
        int unsupported(AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int i, TruffleString.ErrorHandling errorHandling) {
            assert (TStringGuards.isStride0(a));
            JCodings.Encoding jCoding = JCodings.getInstance().get(encoding);
            byte[] bytes = JCodings.asByteArray(arrayA);
            return JCodings.getInstance().decode(a, bytes, JCodings.getInstance().codePointIndexToRaw(this, a, bytes, 0, i, false, jCoding), jCoding, errorHandling);
        }
    }

    static abstract class ReadByteNode
    extends AbstractInternalNode {
        ReadByteNode() {
        }

        abstract int execute(Node var1, AbstractTruffleString var2, Object var3, int var4, TruffleString.Encoding var5);

        @Specialization(guards={"isUTF16(encoding)"})
        static int doUTF16(Node node, AbstractTruffleString a, Object arrayA, int i, TruffleString.Encoding encoding, @Cached.Shared(value="stride0") @Cached InlinedConditionProfile stride0Profile) {
            int index;
            a.boundsCheckByteIndexUTF16(i);
            if (stride0Profile.profile(node, TStringGuards.isStride0(a))) {
                if (TStringGuards.bigEndian() == ((i & 1) == 0)) {
                    return 0;
                }
                index = i >> 1;
            } else {
                assert (TStringGuards.isStride1(a));
                index = i;
            }
            return TStringOps.readS0(arrayA, a.offset(), a.length() << a.stride(), index);
        }

        @Specialization(guards={"isUTF32(encoding)"})
        static int doUTF32(Node node, AbstractTruffleString a, Object arrayA, int i, TruffleString.Encoding encoding, @Cached.Shared(value="stride0") @Cached InlinedConditionProfile stride0Profile, @Cached.Exclusive @Cached InlinedConditionProfile stride1Profile) {
            int index;
            a.boundsCheckByteIndexUTF32(i);
            if (stride0Profile.profile(node, TStringGuards.isStride0(a))) {
                if ((i & 3) != (TStringGuards.bigEndian() ? 3 : 0)) {
                    return 0;
                }
                index = i >> 2;
            } else if (stride1Profile.profile(node, TStringGuards.isStride1(a))) {
                if (TStringGuards.bigEndian() == ((i & 2) == 0)) {
                    return 0;
                }
                index = TStringGuards.bigEndian() ? i >> 1 | i & 1 : i >> 1 & 0xFFFFFFFE | i & 1;
            } else {
                assert (TStringGuards.isStride2(a));
                index = i;
            }
            return TStringOps.readS0(arrayA, a.offset(), a.length() << a.stride(), index);
        }

        @Specialization(guards={"!isUTF16Or32(encoding)"})
        static int doRest(AbstractTruffleString a, Object arrayA, int i, TruffleString.Encoding encoding) {
            a.boundsCheckByteIndexS0(i);
            return TStringOps.readS0(a, arrayA, i);
        }
    }

    static abstract class CodePointIndexToRawNode
    extends AbstractInternalNode {
        CodePointIndexToRawNode() {
        }

        abstract int execute(Node var1, AbstractTruffleString var2, Object var3, int var4, TruffleString.Encoding var5, int var6, int var7, boolean var8);

        @Specialization(guards={"isFixedWidth(codeRangeA)"})
        int doFixed(AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int extraOffsetRaw, int index, boolean isLength) {
            return index;
        }

        @Specialization(guards={"isUTF8(encoding)", "isValid(codeRangeA)"})
        int utf8Valid(AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int extraOffsetRaw, int index, boolean isLength) {
            int regionLength;
            assert (TStringGuards.isStride0(a));
            int regionOffset = a.offset() + extraOffsetRaw;
            int byteIndex = TStringOps.codePointIndexToByteIndexUTF8Valid(this, arrayA, regionOffset, regionLength = a.length() - extraOffsetRaw, index);
            if (byteIndex < 0 || !isLength && byteIndex == regionLength) {
                throw InternalErrors.indexOutOfBounds();
            }
            return byteIndex;
        }

        @Specialization(guards={"isUTF8(encoding)", "isBroken(codeRangeA)"})
        int utf8Broken(AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int extraOffsetRaw, int index, boolean isLength) {
            assert (TStringGuards.isStride0(a));
            int cpi = 0;
            for (int i = extraOffsetRaw; i < a.length(); i += Encodings.utf8GetCodePointLength(a, arrayA, i, TruffleString.ErrorHandling.BEST_EFFORT)) {
                if (cpi == index) {
                    return i - extraOffsetRaw;
                }
                TStringConstants.truffleSafePointPoll(this, ++cpi);
            }
            return CodePointIndexToRawNode.atEnd(a, extraOffsetRaw, index, isLength, cpi);
        }

        @Specialization(guards={"isUTF16(encoding)", "isValid(codeRangeA)"})
        int utf16Valid(AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int extraOffsetRaw, int index, boolean isLength) {
            int regionLength;
            assert (TStringGuards.isStride1(a));
            int regionOffset = a.offset() + (extraOffsetRaw << 1);
            int result = TStringOps.codePointIndexToByteIndexUTF16Valid(this, arrayA, regionOffset, regionLength = a.length() - extraOffsetRaw, index);
            if (result < 0 || !isLength && result == regionLength) {
                throw InternalErrors.indexOutOfBounds();
            }
            return result;
        }

        @Specialization(guards={"isUTF16(encoding)", "isBroken(codeRangeA)"})
        int utf16Broken(AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int extraOffsetRaw, int index, boolean isLength) {
            assert (TStringGuards.isStride1(a));
            int cpi = 0;
            for (int i = extraOffsetRaw; i < a.length(); ++i) {
                if (i <= extraOffsetRaw || !Encodings.isUTF16LowSurrogate(TStringOps.readS1(a, arrayA, i)) || !Encodings.isUTF16HighSurrogate(TStringOps.readS1(a, arrayA, i - 1))) {
                    if (cpi == index) {
                        return i - extraOffsetRaw;
                    }
                    ++cpi;
                }
                TStringConstants.truffleSafePointPoll(this, i + 1);
            }
            return CodePointIndexToRawNode.atEnd(a, extraOffsetRaw, index, isLength, cpi);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isUnsupportedEncoding(encoding)"})
        int unsupported(AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int extraOffsetRaw, int index, boolean isLength) {
            JCodings.Encoding jCoding = JCodings.getInstance().get(encoding);
            return JCodings.getInstance().codePointIndexToRaw(this, a, JCodings.asByteArray(arrayA), extraOffsetRaw, index, isLength, jCoding);
        }

        static int atEnd(AbstractTruffleString a, int extraOffsetRaw, int index, boolean isLength, int cpi) {
            if (isLength && cpi == index) {
                return a.length() - extraOffsetRaw;
            }
            throw InternalErrors.indexOutOfBounds();
        }
    }

    static abstract class RawIndexToCodePointIndexNode
    extends AbstractInternalNode {
        RawIndexToCodePointIndexNode() {
        }

        abstract int execute(Node var1, AbstractTruffleString var2, Object var3, int var4, TruffleString.Encoding var5, int var6, int var7);

        @Specialization(guards={"isFixedWidth(codeRangeA)"})
        int doFixed(AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int byteOffset, int index) {
            return index;
        }

        @Specialization(guards={"isUTF8(encoding)", "isValid(codeRangeA)"})
        static int utf8Valid(Node node, AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int byteOffset, int index, @Cached.Shared(value="broken") @Cached InlinedConditionProfile brokenProfile) {
            return StringAttributes.getCodePointLength(TStringOps.calcStringAttributesUTF8(node, arrayA, a.offset() + byteOffset, index, true, byteOffset + index == a.length(), brokenProfile));
        }

        @Specialization(guards={"isUTF8(encoding)", "isBroken(codeRangeA)"})
        static int utf8Broken(Node node, AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int byteOffset, int index, @Cached.Shared(value="broken") @Cached InlinedConditionProfile brokenProfile) {
            return StringAttributes.getCodePointLength(TStringOps.calcStringAttributesUTF8(node, arrayA, a.offset() + byteOffset, index, false, false, brokenProfile));
        }

        @Specialization(guards={"isUTF16(encoding)", "isValid(codeRangeA)"})
        int utf16Valid(AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int byteOffset, int index) {
            assert (TStringGuards.isStride1(a));
            return StringAttributes.getCodePointLength(TStringOps.calcStringAttributesUTF16(this, arrayA, a.offset() + byteOffset, index, true));
        }

        @Specialization(guards={"isUTF16(encoding)", "isBroken(codeRangeA)"})
        int utf16Broken(AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int byteOffset, int index) {
            assert (TStringGuards.isStride1(a));
            return StringAttributes.getCodePointLength(TStringOps.calcStringAttributesUTF16(this, arrayA, a.offset() + byteOffset, index, false));
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isUnsupportedEncoding(encoding)"})
        static int unsupported(Node node, AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int byteOffset, int index, @Cached.Exclusive @Cached InlinedConditionProfile validProfile, @Cached.Shared(value="broken") @Cached InlinedConditionProfile fixedWidthProfile) {
            return StringAttributes.getCodePointLength(JCodings.getInstance().calcStringAttributes(node, arrayA, a.offset(), index, encoding, byteOffset, validProfile, fixedWidthProfile));
        }
    }

    static abstract class ByteLengthOfCodePointNode
    extends AbstractInternalNode {
        ByteLengthOfCodePointNode() {
        }

        abstract int execute(Node var1, AbstractTruffleString var2, Object var3, int var4, TruffleString.Encoding var5, int var6, TruffleString.ErrorHandling var7);

        @Specialization(guards={"isFixedWidth(codeRangeA)", "isBestEffort(errorHandling)"})
        int doFixed(AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int index, TruffleString.ErrorHandling errorHandling) {
            return 1 << encoding.naturalStride;
        }

        @Specialization(guards={"isUpToValidFixedWidth(codeRangeA)", "isReturnNegative(errorHandling)"})
        int doFixedValidReturnNegative(AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int index, TruffleString.ErrorHandling errorHandling) {
            return 1 << encoding.naturalStride;
        }

        @Specialization(guards={"isAscii(encoding)", "isBroken(codeRangeA)", "isReturnNegative(errorHandling)"})
        int doASCIIBrokenReturnNegative(AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int index, TruffleString.ErrorHandling errorHandling) {
            assert (TStringGuards.isStride0(a));
            return TStringOps.readS0(a, arrayA, index) < 128 ? 1 : -1;
        }

        @Specialization(guards={"isUTF32(encoding)", "isBroken(codeRangeA)", "isReturnNegative(errorHandling)"})
        static int doUTF32BrokenReturnNegative(Node node, AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int index, TruffleString.ErrorHandling errorHandling, @Cached CodePointAtRawNode codePointAtRawNode) {
            return codePointAtRawNode.execute(node, a, arrayA, codeRangeA, encoding, index, TruffleString.ErrorHandling.RETURN_NEGATIVE) < 0 ? -1 : 4;
        }

        @Specialization(guards={"isUTF8(encoding)", "isValid(codeRangeA)"})
        int utf8Valid(AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int index, TruffleString.ErrorHandling errorHandling) {
            assert (TStringGuards.isStride0(a));
            int firstByte = TStringOps.readS0(a, arrayA, index);
            return firstByte <= 127 ? 1 : Encodings.utf8CodePointLength(firstByte);
        }

        @Specialization(guards={"isUTF8(encoding)", "isBroken(codeRangeA)"})
        int utf8Broken(AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int index, TruffleString.ErrorHandling errorHandling) {
            assert (TStringGuards.isStride0(a));
            return Encodings.utf8GetCodePointLength(a, arrayA, index, errorHandling);
        }

        @Specialization(guards={"isUTF16(encoding)", "isValid(codeRangeA)"})
        int utf16Valid(AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int index, TruffleString.ErrorHandling errorHandling) {
            assert (TStringGuards.isStride1(a));
            return Encodings.isUTF16HighSurrogate(TStringOps.readS1(a, arrayA, index)) ? 4 : 2;
        }

        @Specialization(guards={"isUTF16(encoding)", "isBroken(codeRangeA)"})
        int utf16Broken(AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int index, TruffleString.ErrorHandling errorHandling) {
            assert (TStringGuards.isStride1(a));
            return Encodings.utf16BrokenGetCodePointByteLength(a, arrayA, index, errorHandling);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isUnsupportedEncoding(encoding)"})
        int unsupported(AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int index, TruffleString.ErrorHandling errorHandling) {
            assert (TStringGuards.isStride0(a));
            JCodings.Encoding jCoding = JCodings.getInstance().get(encoding);
            int cpLength = JCodings.getInstance().getCodePointLength(jCoding, JCodings.asByteArray(arrayA), a.byteArrayOffset() + index, a.byteArrayOffset() + a.length());
            int regionLength = a.length() - index;
            if (errorHandling == TruffleString.ErrorHandling.BEST_EFFORT) {
                if (cpLength > 0 && cpLength <= regionLength) {
                    return cpLength;
                }
                return Math.min(JCodings.getInstance().minLength(jCoding), regionLength);
            }
            assert (errorHandling == TruffleString.ErrorHandling.RETURN_NEGATIVE);
            if (cpLength <= regionLength) {
                return cpLength;
            }
            return -1 - (cpLength - regionLength);
        }
    }

    static abstract class FromNativePointerNode
    extends AbstractInternalNode {
        FromNativePointerNode() {
        }

        abstract TruffleString execute(Node var1, AbstractTruffleString.NativePointer var2, int var3, int var4, TruffleString.Encoding var5, boolean var6);

        @Specialization
        static TruffleString fromNativePointerInternal(Node node, AbstractTruffleString.NativePointer pointer, int byteOffset, int byteLength, TruffleString.Encoding encoding, boolean isCacheHead, @Cached InlinedConditionProfile asciiLatinBytesProfile, @Cached InlinedConditionProfile utf8Profile, @Cached InlinedConditionProfile utf8BrokenProfile, @Cached InlinedConditionProfile utf16Profile, @Cached InlinedConditionProfile utf32Profile, @Cached InlinedConditionProfile exoticValidProfile, @Cached InlinedConditionProfile exoticFixedWidthProfile) {
            int stride;
            int codeRange;
            int codePointLength;
            int length2;
            if (utf16Profile.profile(node, TStringGuards.isUTF16(encoding))) {
                AbstractTruffleString.checkByteLengthUTF16(byteLength);
                length2 = byteLength >> 1;
                long attrs = TStringOps.calcStringAttributesUTF16(node, pointer, byteOffset, length2, false);
                codePointLength = StringAttributes.getCodePointLength(attrs);
                codeRange = StringAttributes.getCodeRange(attrs);
                stride = 1;
            } else if (utf32Profile.profile(node, TStringGuards.isUTF32(encoding))) {
                AbstractTruffleString.checkByteLengthUTF32(byteLength);
                length2 = byteLength >> 2;
                codeRange = TStringOps.calcStringAttributesUTF32(node, pointer, byteOffset, length2);
                codePointLength = length2;
                stride = 2;
            } else {
                length2 = byteLength;
                stride = 0;
                if (utf8Profile.profile(node, TStringGuards.isUTF8(encoding))) {
                    long attrs = TStringOps.calcStringAttributesUTF8(node, pointer, byteOffset, length2, false, false, utf8BrokenProfile);
                    codeRange = StringAttributes.getCodeRange(attrs);
                    codePointLength = StringAttributes.getCodePointLength(attrs);
                } else if (asciiLatinBytesProfile.profile(node, TStringGuards.isAsciiBytesOrLatin1(encoding))) {
                    int cr = TStringOps.calcStringAttributesLatin1(node, pointer, byteOffset, length2);
                    codeRange = TStringGuards.is8Bit(cr) ? TSCodeRange.asciiLatinBytesNonAsciiCodeRange(encoding) : cr;
                    codePointLength = length2;
                } else {
                    pointer.materializeByteArray(node, byteOffset, byteLength, InlinedConditionProfile.getUncached());
                    long attrs = JCodings.getInstance().calcStringAttributes(node, pointer, byteOffset, length2, encoding, 0, exoticValidProfile, exoticFixedWidthProfile);
                    codeRange = StringAttributes.getCodeRange(attrs);
                    codePointLength = StringAttributes.getCodePointLength(attrs);
                }
            }
            return TruffleString.createFromArray(pointer, byteOffset, length2, stride, encoding, codePointLength, codeRange, isCacheHead);
        }
    }

    static abstract class FromBufferWithStringCompactionKnownAttributesNode
    extends AbstractInternalNode {
        FromBufferWithStringCompactionKnownAttributesNode() {
        }

        final TruffleString execute(Node node, AbstractTruffleString a, TruffleString.Encoding encoding) {
            return this.execute(node, a, true, encoding);
        }

        abstract TruffleString execute(Node var1, AbstractTruffleString var2, boolean var3, TruffleString.Encoding var4);

        @Specialization
        static TruffleString fromBufferWithStringCompaction(Node node, AbstractTruffleString a, boolean isCacheHead, TruffleString.Encoding encoding, @Cached GetCodePointLengthNode getCodePointLengthNode, @Cached GetPreciseCodeRangeNode getPreciseCodeRangeNode, @Cached InlinedConditionProfile utf16Profile, @Cached InlinedConditionProfile utf16CompactProfile, @Cached InlinedConditionProfile utf32Profile, @Cached InlinedConditionProfile utf32Compact0Profile, @Cached InlinedConditionProfile utf32Compact1Profile) {
            byte[] array;
            int stride;
            int codeRange = getPreciseCodeRangeNode.execute(node, a, encoding);
            a.looseCheckEncoding(encoding, codeRange);
            int length2 = a.length();
            if (length2 == 0) {
                return encoding.getEmpty();
            }
            Object arrayA = a.data();
            assert (arrayA instanceof byte[] || arrayA instanceof AbstractTruffleString.NativePointer);
            int offsetA = a.offset();
            int strideA = a.stride();
            boolean offset = false;
            if (utf16Profile.profile(node, TStringGuards.isUTF16(encoding))) {
                stride = Stride.fromCodeRangeUTF16(codeRange);
                array = new byte[length2 << stride];
                if (utf16CompactProfile.profile(node, strideA == 1 && stride == 0)) {
                    TStringOps.arraycopyWithStride(node, arrayA, offsetA, 1, 0, array, 0, 0, 0, length2);
                } else {
                    assert (stride == strideA);
                    TStringOps.arraycopyWithStride(node, arrayA, offsetA, 0, 0, array, 0, 0, 0, length2 << stride);
                }
            } else if (utf32Profile.profile(node, TStringGuards.isUTF32(encoding))) {
                stride = Stride.fromCodeRangeUTF32(codeRange);
                array = new byte[length2 << stride];
                if (utf32Compact0Profile.profile(node, strideA == 2 && stride == 0)) {
                    TStringOps.arraycopyWithStride(node, arrayA, offsetA, 2, 0, array, 0, 0, 0, length2);
                } else if (utf32Compact1Profile.profile(node, strideA == 2 && stride == 1)) {
                    TStringOps.arraycopyWithStride(node, arrayA, offsetA, 2, 0, array, 0, 1, 0, length2);
                } else {
                    assert (stride == strideA);
                    TStringOps.arraycopyWithStride(node, arrayA, offsetA, 0, 0, array, 0, 0, 0, length2 << stride);
                }
            } else {
                stride = 0;
                array = TStringOps.arraycopyOfWithStride(node, arrayA, offsetA, length2, 0, length2, 0);
            }
            int codePointLength = getCodePointLengthNode.execute(node, a, encoding);
            return TruffleString.createFromArray(array, 0, length2, stride, encoding, codePointLength, codeRange, isCacheHead);
        }

        static FromBufferWithStringCompactionKnownAttributesNode getUncached() {
            return TStringInternalNodesFactory.FromBufferWithStringCompactionKnownAttributesNodeGen.getUncached();
        }
    }

    static abstract class FromBufferWithStringCompactionNode
    extends AbstractInternalNode {
        FromBufferWithStringCompactionNode() {
        }

        abstract TruffleString execute(Node var1, Object var2, int var3, int var4, TruffleString.Encoding var5, boolean var6, boolean var7);

        @Specialization
        static TruffleString fromBufferWithStringCompaction(Node node, Object arrayA, int offsetA, int byteLength, TruffleString.Encoding encoding, boolean copy, boolean isCacheHead, @Cached InlinedConditionProfile asciiLatinBytesProfile, @Cached InlinedConditionProfile utf8Profile, @Cached InlinedConditionProfile utf8BrokenProfile, @Cached InlinedConditionProfile utf16Profile, @Cached InlinedConditionProfile utf16CompactProfile, @Cached InlinedConditionProfile utf32Profile, @Cached InlinedConditionProfile utf32Compact0Profile, @Cached InlinedConditionProfile utf32Compact1Profile, @Cached InlinedConditionProfile exoticValidProfile, @Cached InlinedConditionProfile exoticFixedWidthProfile) {
            Object array;
            int offset;
            int stride;
            int codeRange;
            int codePointLength;
            int length2;
            if (utf16Profile.profile(node, TStringGuards.isUTF16(encoding))) {
                AbstractTruffleString.checkByteLengthUTF16(byteLength);
                length2 = byteLength >> 1;
                long attrs = TStringOps.calcStringAttributesUTF16(node, arrayA, offsetA, length2, false);
                codePointLength = StringAttributes.getCodePointLength(attrs);
                codeRange = StringAttributes.getCodeRange(attrs);
                stride = Stride.fromCodeRangeUTF16(codeRange);
                if (copy || stride == 0) {
                    offset = 0;
                    array = new byte[length2 << stride];
                    if (utf16CompactProfile.profile(node, stride == 0)) {
                        TStringOps.arraycopyWithStride(node, arrayA, offsetA, 1, 0, array, offset, 0, 0, length2);
                    } else {
                        TStringOps.arraycopyWithStride(node, arrayA, offsetA, 1, 0, array, offset, 1, 0, length2);
                    }
                } else {
                    offset = offsetA;
                    array = arrayA;
                }
            } else if (utf32Profile.profile(node, TStringGuards.isUTF32(encoding))) {
                AbstractTruffleString.checkByteLengthUTF32(byteLength);
                length2 = byteLength >> 2;
                codeRange = TStringOps.calcStringAttributesUTF32(node, arrayA, offsetA, length2);
                codePointLength = length2;
                stride = Stride.fromCodeRangeUTF32(codeRange);
                if (copy || stride < 2) {
                    offset = 0;
                    array = new byte[length2 << stride];
                    if (utf32Compact0Profile.profile(node, stride == 0)) {
                        TStringOps.arraycopyWithStride(node, arrayA, offsetA, 2, 0, array, offset, 0, 0, length2);
                    } else if (utf32Compact1Profile.profile(node, stride == 1)) {
                        TStringOps.arraycopyWithStride(node, arrayA, offsetA, 2, 0, array, offset, 1, 0, length2);
                    } else {
                        TStringOps.arraycopyWithStride(node, arrayA, offsetA, 2, 0, array, offset, 2, 0, length2);
                    }
                } else {
                    offset = offsetA;
                    array = arrayA;
                }
            } else {
                length2 = byteLength;
                stride = 0;
                if (utf8Profile.profile(node, TStringGuards.isUTF8(encoding))) {
                    long attrs = TStringOps.calcStringAttributesUTF8(node, arrayA, offsetA, length2, false, false, utf8BrokenProfile);
                    codeRange = StringAttributes.getCodeRange(attrs);
                    codePointLength = StringAttributes.getCodePointLength(attrs);
                } else if (asciiLatinBytesProfile.profile(node, TStringGuards.isAsciiBytesOrLatin1(encoding))) {
                    int cr = TStringOps.calcStringAttributesLatin1(node, arrayA, offsetA, length2);
                    codeRange = TStringGuards.is8Bit(cr) ? TSCodeRange.asciiLatinBytesNonAsciiCodeRange(encoding) : cr;
                    codePointLength = length2;
                } else {
                    if (arrayA instanceof AbstractTruffleString.NativePointer) {
                        ((AbstractTruffleString.NativePointer)arrayA).materializeByteArray(node, offsetA, length2 << stride, InlinedConditionProfile.getUncached());
                    }
                    long attrs = JCodings.getInstance().calcStringAttributes(node, arrayA, offsetA, length2, encoding, 0, exoticValidProfile, exoticFixedWidthProfile);
                    codeRange = StringAttributes.getCodeRange(attrs);
                    codePointLength = StringAttributes.getCodePointLength(attrs);
                }
                if (copy) {
                    offset = 0;
                    array = TStringOps.arraycopyOfWithStride(node, arrayA, offsetA, length2, 0, length2, 0);
                } else {
                    offset = offsetA;
                    array = arrayA;
                }
            }
            return TruffleString.createFromArray(array, offset, length2, stride, encoding, codePointLength, codeRange, isCacheHead);
        }
    }

    static abstract class GetCodePointLengthNode
    extends AbstractInternalNode {
        GetCodePointLengthNode() {
        }

        abstract int execute(Node var1, AbstractTruffleString var2, TruffleString.Encoding var3);

        @Specialization
        static int get(Node node, AbstractTruffleString a, TruffleString.Encoding encoding, @Cached InlinedConditionProfile cacheMissProfile, @Cached TruffleString.ToIndexableNode toIndexableNode, @Cached CalcStringAttributesNode calcStringAttributesNode) {
            int codePointLength = a.codePointLength();
            if (cacheMissProfile.profile(node, codePointLength < 0)) {
                return StringAttributes.getCodePointLength(TStringInternalNodes.updateAttributes(node, a, encoding, a.codeRange(), toIndexableNode, calcStringAttributesNode));
            }
            return codePointLength;
        }

        static GetCodePointLengthNode getUncached() {
            return TStringInternalNodesFactory.GetCodePointLengthNodeGen.getUncached();
        }
    }

    static abstract class GetPreciseCodeRangeNode
    extends AbstractInternalNode {
        GetPreciseCodeRangeNode() {
        }

        abstract int execute(Node var1, AbstractTruffleString var2, TruffleString.Encoding var3);

        @Specialization
        static int get(Node node, AbstractTruffleString a, TruffleString.Encoding encoding, @Cached InlinedConditionProfile impreciseProfile, @Cached TruffleString.ToIndexableNode toIndexableNode, @Cached CalcStringAttributesNode calcStringAttributesNode) {
            int codeRange = a.codeRange();
            if (impreciseProfile.profile(node, !TSCodeRange.isPrecise(codeRange))) {
                return StringAttributes.getCodeRange(TStringInternalNodes.updateAttributes(node, a, encoding, codeRange, toIndexableNode, calcStringAttributesNode));
            }
            return codeRange;
        }
    }

    static abstract class GetCodeRangeForIndexCalculationNode
    extends AbstractInternalNode {
        GetCodeRangeForIndexCalculationNode() {
        }

        abstract int execute(Node var1, AbstractTruffleString var2, TruffleString.Encoding var3);

        @Specialization
        static int get(Node node, AbstractTruffleString a, TruffleString.Encoding encoding, @Cached InlinedConditionProfile impreciseProfile, @Cached TruffleString.ToIndexableNode toIndexableNode, @Cached CalcStringAttributesNode calcStringAttributesNode) {
            int codeRange = a.codeRange();
            if (impreciseProfile.profile(node, !TSCodeRange.isPrecise(codeRange) && !TStringGuards.isFixedWidth(codeRange))) {
                return StringAttributes.getCodeRange(TStringInternalNodes.updateAttributes(node, a, encoding, codeRange, toIndexableNode, calcStringAttributesNode));
            }
            return codeRange;
        }
    }
}

