/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.truffle.object;

import java.util.Objects;
import org.pkl.thirdparty.truffle.api.object.DynamicObject;
import org.pkl.thirdparty.truffle.api.object.Location;
import org.pkl.thirdparty.truffle.object.CoreAllocator;
import org.pkl.thirdparty.truffle.object.CoreLocation;
import org.pkl.thirdparty.truffle.object.CoreLocations;
import org.pkl.thirdparty.truffle.object.DefaultLayout;
import org.pkl.thirdparty.truffle.object.LayoutImpl;
import org.pkl.thirdparty.truffle.object.LayoutStrategy;
import org.pkl.thirdparty.truffle.object.LocationImpl;
import org.pkl.thirdparty.truffle.object.ShapeImpl;

final class DefaultStrategy
extends LayoutStrategy {
    static final LayoutStrategy SINGLETON = new DefaultStrategy();

    private DefaultStrategy() {
    }

    @Override
    public boolean updateShape(DynamicObject object) {
        assert (object.getShape().isValid());
        return false;
    }

    @Override
    public ShapeImpl ensureValid(ShapeImpl newShape) {
        assert (newShape.isValid());
        return newShape;
    }

    private static boolean assertLocationInRange(ShapeImpl shape, Location location) {
        DefaultLayout layout = (DefaultLayout)shape.getLayout();
        assert (shape.getPrimitiveFieldSize() + ((LocationImpl)location).primitiveFieldCount() <= layout.getPrimitiveFieldCount());
        assert (shape.getObjectFieldSize() + ((LocationImpl)location).objectFieldCount() <= layout.getObjectFieldCount());
        return true;
    }

    @Override
    public ShapeImpl ensureSpace(ShapeImpl shape, Location location) {
        Objects.requireNonNull(location);
        assert (DefaultStrategy.assertLocationInRange(shape, location));
        return shape;
    }

    @Override
    public ShapeImpl.BaseAllocator createAllocator(ShapeImpl shape) {
        return new CoreAllocator(shape);
    }

    @Override
    public ShapeImpl.BaseAllocator createAllocator(LayoutImpl layout) {
        return new CoreAllocator(layout);
    }

    @Override
    protected Location createLocationForValue(ShapeImpl shape, Object value2, long putFlags) {
        return ((CoreAllocator)shape.allocator()).locationForValue(value2, true, value2 != null, putFlags);
    }

    @Override
    protected int getLocationOrdinal(Location location) {
        return CoreLocations.getLocationOrdinal((CoreLocation)location);
    }
}

