/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.truffle.polyglot;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.FileSystem;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.pkl.thirdparty.graalvm.options.OptionDescriptors;
import org.pkl.thirdparty.graalvm.polyglot.Context;
import org.pkl.thirdparty.graalvm.polyglot.Engine;
import org.pkl.thirdparty.graalvm.polyglot.HostAccess;
import org.pkl.thirdparty.graalvm.polyglot.PolyglotException;
import org.pkl.thirdparty.graalvm.polyglot.ResourceLimitEvent;
import org.pkl.thirdparty.graalvm.polyglot.SandboxPolicy;
import org.pkl.thirdparty.graalvm.polyglot.SourceSection;
import org.pkl.thirdparty.graalvm.polyglot.Value;
import org.pkl.thirdparty.graalvm.polyglot.impl.AbstractPolyglotImpl;
import org.pkl.thirdparty.graalvm.polyglot.io.ByteSequence;
import org.pkl.thirdparty.graalvm.polyglot.io.MessageTransport;
import org.pkl.thirdparty.graalvm.polyglot.io.ProcessHandler;
import org.pkl.thirdparty.graalvm.polyglot.proxy.Proxy;
import org.pkl.thirdparty.truffle.api.CompilerDirectives;
import org.pkl.thirdparty.truffle.api.TruffleFile;
import org.pkl.thirdparty.truffle.api.TruffleLanguage;
import org.pkl.thirdparty.truffle.api.TruffleOptions;
import org.pkl.thirdparty.truffle.api.impl.DispatchOutputStream;
import org.pkl.thirdparty.truffle.api.interop.TruffleObject;
import org.pkl.thirdparty.truffle.api.source.Source;
import org.pkl.thirdparty.truffle.api.strings.TruffleString;
import org.pkl.thirdparty.truffle.polyglot.DefaultPolyglotHostService;
import org.pkl.thirdparty.truffle.polyglot.EngineAccessor;
import org.pkl.thirdparty.truffle.polyglot.FileSystems;
import org.pkl.thirdparty.truffle.polyglot.LanguageCache;
import org.pkl.thirdparty.truffle.polyglot.ModuleUtils;
import org.pkl.thirdparty.truffle.polyglot.OptionValuesImpl;
import org.pkl.thirdparty.truffle.polyglot.PolyglotContextDispatch;
import org.pkl.thirdparty.truffle.polyglot.PolyglotContextImpl;
import org.pkl.thirdparty.truffle.polyglot.PolyglotEngineDispatch;
import org.pkl.thirdparty.truffle.polyglot.PolyglotEngineException;
import org.pkl.thirdparty.truffle.polyglot.PolyglotEngineImpl;
import org.pkl.thirdparty.truffle.polyglot.PolyglotExceptionDispatch;
import org.pkl.thirdparty.truffle.polyglot.PolyglotExceptionImpl;
import org.pkl.thirdparty.truffle.polyglot.PolyglotExecutionEventDispatch;
import org.pkl.thirdparty.truffle.polyglot.PolyglotExecutionListenerDispatch;
import org.pkl.thirdparty.truffle.polyglot.PolyglotFastThreadLocals;
import org.pkl.thirdparty.truffle.polyglot.PolyglotHostAccess;
import org.pkl.thirdparty.truffle.polyglot.PolyglotInstrumentDispatch;
import org.pkl.thirdparty.truffle.polyglot.PolyglotLanguageContext;
import org.pkl.thirdparty.truffle.polyglot.PolyglotLanguageDispatch;
import org.pkl.thirdparty.truffle.polyglot.PolyglotLimits;
import org.pkl.thirdparty.truffle.polyglot.PolyglotLoggers;
import org.pkl.thirdparty.truffle.polyglot.PolyglotSourceDispatch;
import org.pkl.thirdparty.truffle.polyglot.PolyglotSourceSectionDispatch;
import org.pkl.thirdparty.truffle.polyglot.PolyglotValueDispatch;
import org.pkl.thirdparty.truffle.polyglot.PolyglotWrapper;
import org.pkl.thirdparty.truffle.polyglot.PreInitContextHostLanguage;
import org.pkl.thirdparty.truffle.polyglot.ProcessHandlers;

public final class PolyglotImpl
extends AbstractPolyglotImpl {
    static final Object[] EMPTY_ARGS = new Object[0];
    private final PolyglotSourceDispatch sourceDispatch = new PolyglotSourceDispatch(this);
    private final PolyglotSourceSectionDispatch sourceSectionDispatch = new PolyglotSourceSectionDispatch(this);
    private final PolyglotExecutionListenerDispatch executionListenerDispatch = new PolyglotExecutionListenerDispatch(this);
    private final PolyglotExecutionEventDispatch executionEventDispatch = new PolyglotExecutionEventDispatch(this);
    final PolyglotEngineDispatch engineDispatch = new PolyglotEngineDispatch(this);
    final PolyglotContextDispatch contextDispatch = new PolyglotContextDispatch(this);
    private final PolyglotExceptionDispatch exceptionDispatch = new PolyglotExceptionDispatch(this);
    final PolyglotInstrumentDispatch instrumentDispatch = new PolyglotInstrumentDispatch(this);
    final PolyglotLanguageDispatch languageDispatch = new PolyglotLanguageDispatch(this);
    private final AtomicReference<PolyglotEngineImpl> preInitializedEngineRef = new AtomicReference();
    private final Map<Class<?>, PolyglotValueDispatch> primitiveValues = new HashMap();
    Value hostNull;
    private PolyglotValueDispatch disconnectedHostValue;
    private PolyglotValueDispatch disconnectedBigIntegerHostValue;
    private volatile Object defaultFileSystemContext;
    private static volatile AbstractPolyglotImpl abstractImpl;

    @Override
    public int getPriority() {
        return 0;
    }

    private static AbstractPolyglotImpl getImpl() {
        AbstractPolyglotImpl local = abstractImpl;
        if (local == null) {
            try {
                Method f = Engine.class.getDeclaredMethod("getImpl", new Class[0]);
                f.setAccessible(true);
                abstractImpl = local = (AbstractPolyglotImpl)f.invoke(null, new Object[0]);
                assert (local != null) : "polyglot impl not found";
            }
            catch (Exception e2) {
                throw new AssertionError((Object)e2);
            }
        }
        return local;
    }

    static PolyglotImpl getInstance() {
        AbstractPolyglotImpl polyglot;
        for (polyglot = PolyglotImpl.getImpl(); polyglot != null && !(polyglot instanceof PolyglotImpl); polyglot = polyglot.getNext()) {
        }
        if (polyglot == null) {
            throw new AssertionError((Object)String.format("%s not found or installed but required.", PolyglotImpl.class.getSimpleName()));
        }
        return (PolyglotImpl)polyglot;
    }

    PolyglotEngineImpl getPreinitializedEngine() {
        return this.preInitializedEngineRef.get();
    }

    @Override
    protected void initialize() {
        this.hostNull = this.getAPIAccess().newValue(PolyglotValueDispatch.createHostNull(this), null, EngineAccessor.HOST.getHostNull());
        this.disconnectedHostValue = new PolyglotValueDispatch.HostValue(this);
        this.disconnectedBigIntegerHostValue = new PolyglotValueDispatch.BigIntegerHostValue(this);
        PolyglotValueDispatch.createDefaultValues(this, null, this.primitiveValues);
    }

    @Override
    public Object buildLimits(long statementLimit, Predicate<org.pkl.thirdparty.graalvm.polyglot.Source> statementLimitSourceFilter, Consumer<ResourceLimitEvent> onLimit) {
        try {
            return new PolyglotLimits(statementLimit, statementLimitSourceFilter, onLimit);
        }
        catch (Throwable t) {
            throw PolyglotImpl.guestToHostException(this, t);
        }
    }

    AbstractPolyglotImpl.AbstractSourceDispatch getSourceDispatch() {
        return this.sourceDispatch;
    }

    AbstractPolyglotImpl.AbstractSourceSectionDispatch getSourceSectionDispatch() {
        return this.sourceSectionDispatch;
    }

    AbstractPolyglotImpl.AbstractExecutionListenerDispatch getExecutionListenerDispatch() {
        return this.executionListenerDispatch;
    }

    AbstractPolyglotImpl.AbstractExecutionEventDispatch getExecutionEventDispatch() {
        return this.executionEventDispatch;
    }

    @Override
    public Context getCurrentContext() {
        try {
            PolyglotContextImpl context = PolyglotFastThreadLocals.getContext(null);
            if (context == null) {
                throw PolyglotEngineException.illegalState("No current context is available. Make sure the Java method is invoked by a Graal guest language or a context is entered using Context.enter().");
            }
            Context api = context.api;
            if (api == null) {
                context.api = api = this.getAPIAccess().newContext(this.contextDispatch, context, context.engine.api);
            }
            return api;
        }
        catch (Throwable t) {
            throw PolyglotImpl.guestToHostException(this, t);
        }
    }

    @Override
    public Engine buildEngine(String[] permittedLanguages, SandboxPolicy sandboxPolicy, OutputStream out, OutputStream err, InputStream in, Map<String, String> options, boolean allowExperimentalOptions, boolean boundEngine, MessageTransport messageInterceptor, AbstractPolyglotImpl.LogHandler logHandler, Object hostLanguage, boolean hostLanguageOnly, boolean registerInActiveEngines, AbstractPolyglotImpl.AbstractPolyglotHostService polyglotHostService) {
        PolyglotEngineImpl impl = null;
        try {
            this.validateSandbox(sandboxPolicy);
            if (TruffleOptions.AOT) {
                EngineAccessor.ACCESSOR.initializeNativeImageTruffleLocator();
            }
            OutputStream resolvedOut = out == null ? System.out : out;
            OutputStream resolvedErr = err == null ? System.err : err;
            InputStream resolvedIn = in == null ? System.in : in;
            DispatchOutputStream dispatchOut = EngineAccessor.INSTRUMENT.createDispatchOutput(resolvedOut);
            DispatchOutputStream dispatchErr = EngineAccessor.INSTRUMENT.createDispatchOutput(resolvedErr);
            PolyglotEngineImpl.LogConfig logConfig = new PolyglotEngineImpl.LogConfig();
            OptionValuesImpl engineOptions = PolyglotImpl.createEngineOptions(options, logConfig, sandboxPolicy, allowExperimentalOptions);
            AbstractPolyglotImpl.LogHandler useHandler = logHandler != null ? logHandler : PolyglotEngineImpl.createLogHandler(this, logConfig, dispatchErr, sandboxPolicy);
            PolyglotLoggers.EngineLoggerProvider loggerProvider = new PolyglotLoggers.EngineLoggerProvider(useHandler, logConfig.logLevels);
            AbstractPolyglotImpl.AbstractPolyglotHostService usePolyglotHostService = polyglotHostService != null ? polyglotHostService : new DefaultPolyglotHostService(this);
            impl = (PolyglotEngineImpl)EngineAccessor.RUNTIME.tryLoadCachedEngine(engineOptions, loggerProvider);
            if (impl == null && boundEngine && !hostLanguageOnly && !EngineAccessor.RUNTIME.isStoreEnabled(engineOptions)) {
                impl = this.preInitializedEngineRef.getAndSet(null);
            }
            if (impl != null) {
                assert (hostLanguage.getClass() == impl.getHostLanguageSPI().getClass() || PreInitContextHostLanguage.isInstance(impl.hostLanguage));
                impl.patch(sandboxPolicy, dispatchOut, dispatchErr, resolvedIn, engineOptions, logConfig, loggerProvider, options, allowExperimentalOptions, boundEngine, useHandler, (TruffleLanguage)hostLanguage, usePolyglotHostService);
            }
            if (impl == null) {
                impl = new PolyglotEngineImpl(this, sandboxPolicy, permittedLanguages, dispatchOut, dispatchErr, resolvedIn, engineOptions, logConfig.logLevels, loggerProvider, options, allowExperimentalOptions, boundEngine, false, messageInterceptor, useHandler, (TruffleLanguage)hostLanguage, hostLanguageOnly, usePolyglotHostService);
            }
            return this.getAPIAccess().newEngine(this.engineDispatch, impl, registerInActiveEngines);
        }
        catch (Throwable t) {
            if (impl == null) {
                throw PolyglotImpl.guestToHostException(this, t);
            }
            throw PolyglotImpl.guestToHostException(impl, t);
        }
    }

    private void validateSandbox(SandboxPolicy sandboxPolicy) {
        if (this == this.getRootImpl() && sandboxPolicy.isStricterThan(SandboxPolicy.CONSTRAINED)) {
            throw PolyglotEngineException.illegalArgument(String.format("The Builder.sandbox(SandboxPolicy) is set to %s, but the GraalVM community edition supports only sandbox policy TRUSTED or CONSTRAINED.In order to resolve this switch to a less strict sandbox policy using Builder.sandbox(SandboxPolicy).", new Object[]{sandboxPolicy}));
        }
    }

    @Override
    protected OptionDescriptors createEngineOptionDescriptors() {
        return PolyglotEngineImpl.createEngineOptionDescriptors();
    }

    static OptionValuesImpl createEngineOptions(Map<String, String> options, PolyglotEngineImpl.LogConfig logOptions, SandboxPolicy sandboxPolicy, boolean allowExperimentalOptions) {
        OptionDescriptors engineOptionDescriptors = PolyglotImpl.getInstance().createAllEngineOptionDescriptors();
        HashMap<String, String> engineOptions = new HashMap<String, String>();
        PolyglotEngineImpl.parseEngineOptions(options, engineOptions, logOptions);
        OptionValuesImpl values2 = new OptionValuesImpl(engineOptionDescriptors, sandboxPolicy, true);
        values2.putAll(null, engineOptions, allowExperimentalOptions);
        return values2;
    }

    @Override
    public void preInitializeEngine() {
        PolyglotEngineImpl engine = this.createDefaultEngine(new PreInitContextHostLanguage());
        this.getAPIAccess().newEngine(this.engineDispatch, engine, false);
        try {
            engine.preInitialize();
        }
        finally {
            LanguageCache.resetNativeImageCacheLanguageHomes();
            engine.logLevels.clear();
            engine.logHandler.close();
            engine.logHandler = null;
        }
        this.preInitializedEngineRef.set(engine);
    }

    PolyglotEngineImpl createDefaultEngine(TruffleLanguage<Object> hostLanguage) {
        Map<String, String> options = this.getAPIAccess().readOptionsFromSystemProperties();
        PolyglotEngineImpl.LogConfig logConfig = new PolyglotEngineImpl.LogConfig();
        SandboxPolicy sandboxPolicy = SandboxPolicy.TRUSTED;
        OptionValuesImpl engineOptions = PolyglotImpl.createEngineOptions(options, logConfig, sandboxPolicy, true);
        DispatchOutputStream out = EngineAccessor.INSTRUMENT.createDispatchOutput(System.out);
        DispatchOutputStream err = EngineAccessor.INSTRUMENT.createDispatchOutput(System.err);
        AbstractPolyglotImpl.LogHandler logHandler = PolyglotEngineImpl.createLogHandler(this, logConfig, err, sandboxPolicy);
        PolyglotLoggers.EngineLoggerProvider loggerProvider = new PolyglotLoggers.EngineLoggerProvider(logHandler, logConfig.logLevels);
        PolyglotEngineImpl engine = new PolyglotEngineImpl(this, sandboxPolicy, new String[0], out, err, System.in, engineOptions, logConfig.logLevels, loggerProvider, options, true, true, true, null, logHandler, hostLanguage, false, new DefaultPolyglotHostService(this));
        this.getAPIAccess().newEngine(this.engineDispatch, engine, false);
        return engine;
    }

    @Override
    public TruffleLanguage<Object> createHostLanguage(AbstractPolyglotImpl.AbstractHostAccess access) {
        return EngineAccessor.HOST.createDefaultHostLanguage(this, access);
    }

    @Override
    public void resetPreInitializedEngine() {
        this.preInitializedEngineRef.set(null);
    }

    @Override
    public Class<?> loadLanguageClass(String className) {
        for (Supplier supplier : EngineAccessor.locatorOrDefaultLoaders()) {
            ClassLoader loader = (ClassLoader)supplier.get();
            if (loader == null) continue;
            try {
                Class<?> c = loader.loadClass(className);
                if (!TruffleOptions.AOT) {
                    ModuleUtils.exportTo(loader, null);
                }
                return c;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        return null;
    }

    @Override
    public <S, T> Object newTargetTypeMapping(Class<S> sourceType, Class<T> targetType, Predicate<S> acceptsValue, Function<S, T> convertValue, HostAccess.TargetMappingPrecedence precedence) {
        return EngineAccessor.HOST.newTargetTypeMapping(sourceType, targetType, acceptsValue, convertValue, precedence);
    }

    Value asValue(PolyglotContextImpl currentContext, Object hostValue) {
        if (currentContext != null) {
            return currentContext.asValue(hostValue);
        }
        assert (!(hostValue instanceof Value));
        Object guestValue = null;
        if (hostValue == null) {
            return this.hostNull;
        }
        if (PolyglotImpl.isGuestPrimitive(hostValue)) {
            return this.getAPIAccess().newValue(this.primitiveValues.get(hostValue.getClass()), null, hostValue);
        }
        if (PolyglotWrapper.isInstance(hostValue)) {
            PolyglotWrapper hostWrapper = PolyglotWrapper.asInstance(hostValue);
            PolyglotLanguageContext languageContext = hostWrapper.getLanguageContext();
            assert (languageContext != null) : "HostWrappers must be guaranteed to have non-null language context.";
            guestValue = hostWrapper.getGuestObject();
            return languageContext.asValue(guestValue);
        }
        guestValue = hostValue instanceof TruffleObject ? hostValue : (hostValue instanceof Proxy ? EngineAccessor.HOST.toDisconnectedHostProxy((Proxy)hostValue) : EngineAccessor.HOST.toDisconnectedHostObject(hostValue));
        return this.getAPIAccess().newValue(hostValue instanceof BigInteger ? this.disconnectedBigIntegerHostValue : this.disconnectedHostValue, null, guestValue);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public Value asValue(Object hostValue) {
        try {
            PolyglotContextImpl currentContext = PolyglotFastThreadLocals.getContext(null);
            return this.asValue(currentContext, hostValue);
        }
        catch (Throwable t) {
            throw PolyglotImpl.guestToHostException(this, t);
        }
    }

    @Override
    public org.pkl.thirdparty.graalvm.polyglot.io.FileSystem newDefaultFileSystem() {
        return FileSystems.newDefaultFileSystem();
    }

    @Override
    public org.pkl.thirdparty.graalvm.polyglot.io.FileSystem allowLanguageHomeAccess(org.pkl.thirdparty.graalvm.polyglot.io.FileSystem fileSystem) {
        return FileSystems.allowLanguageHomeAccess(fileSystem);
    }

    @Override
    public org.pkl.thirdparty.graalvm.polyglot.io.FileSystem newReadOnlyFileSystem(org.pkl.thirdparty.graalvm.polyglot.io.FileSystem fileSystem) {
        return FileSystems.newReadOnlyFileSystem(fileSystem);
    }

    @Override
    public org.pkl.thirdparty.graalvm.polyglot.io.FileSystem newNIOFileSystem(FileSystem fileSystem) {
        return FileSystems.newNIOFileSystem(fileSystem);
    }

    @Override
    public ProcessHandler newDefaultProcessHandler() {
        if (PolyglotEngineImpl.ALLOW_CREATE_PROCESS) {
            return ProcessHandlers.newDefaultProcessHandler();
        }
        return null;
    }

    @Override
    public boolean isDefaultProcessHandler(ProcessHandler processHandler) {
        return ProcessHandlers.isDefault(processHandler);
    }

    @Override
    public boolean isInternalFileSystem(org.pkl.thirdparty.graalvm.polyglot.io.FileSystem fileSystem) {
        return FileSystems.isInternal(this.getRootImpl(), fileSystem);
    }

    @Override
    public boolean isHostFileSystem(org.pkl.thirdparty.graalvm.polyglot.io.FileSystem fileSystem) {
        return FileSystems.isHostFileSystem(fileSystem);
    }

    @Override
    public AbstractPolyglotImpl.ThreadScope createThreadScope() {
        return null;
    }

    @Override
    public AbstractPolyglotImpl.LogHandler newLogHandler(Object logHandlerOrStream) {
        return PolyglotLoggers.asLogHandler(this, logHandlerOrStream);
    }

    @Override
    public OptionDescriptors createUnionOptionDescriptors(OptionDescriptors ... optionDescriptors) {
        return EngineAccessor.LANGUAGE.createOptionDescriptorsUnion(optionDescriptors);
    }

    @Override
    public AbstractPolyglotImpl.AbstractHostAccess createHostAccess() {
        return new PolyglotHostAccess(this);
    }

    @Override
    public String findLanguage(File file) throws IOException {
        Objects.requireNonNull(file);
        String mimeType = this.findMimeType(file);
        if (mimeType != null) {
            return this.findLanguage(mimeType);
        }
        return null;
    }

    @Override
    public String findLanguage(URL url) throws IOException {
        String mimeType = this.findMimeType(url);
        if (mimeType != null) {
            return this.findLanguage(mimeType);
        }
        return null;
    }

    @Override
    public String findMimeType(File file) throws IOException {
        TruffleFile truffleFile;
        Objects.requireNonNull(file);
        try {
            truffleFile = EngineAccessor.LANGUAGE.getTruffleFile(file.toPath().toString(), this.getDefaultFileSystemContext());
        }
        catch (IllegalArgumentException | UnsupportedOperationException e2) {
            throw new AssertionError("Inconsistent path", e2);
        }
        return truffleFile.detectMimeType();
    }

    @Override
    public String findMimeType(URL url) throws IOException {
        Objects.requireNonNull(url);
        return EngineAccessor.SOURCE.findMimeType(url, this.getDefaultFileSystemContext());
    }

    @Override
    public String findLanguage(String mimeType) {
        Objects.requireNonNull(mimeType);
        LanguageCache cache = LanguageCache.languageMimes().get(mimeType);
        if (cache != null) {
            return cache.getId();
        }
        return null;
    }

    @Override
    public org.pkl.thirdparty.graalvm.polyglot.Source build(String language, Object origin, URI uri, String name, String mimeType, Object content, boolean interactive, boolean internal, boolean cached, Charset encoding, URL url, String path) throws IOException {
        Source.SourceBuilder builder;
        assert (language != null);
        if (origin instanceof File) {
            builder = EngineAccessor.SOURCE.newBuilder(language, (File)origin);
        } else if (origin instanceof CharSequence) {
            builder = Source.newBuilder(language, (CharSequence)origin, name);
        } else if (origin instanceof ByteSequence) {
            builder = Source.newBuilder(language, (ByteSequence)origin, name);
        } else if (origin instanceof Reader) {
            builder = Source.newBuilder(language, (Reader)origin, name);
        } else if (origin instanceof URL) {
            builder = Source.newBuilder(language, (URL)origin);
        } else if (origin == Source.CONTENT_NONE) {
            builder = Source.newBuilder(language, "", name).content(Source.CONTENT_NONE);
        } else {
            throw CompilerDirectives.shouldNotReachHere();
        }
        if (origin instanceof File || origin instanceof URL) {
            EngineAccessor.SOURCE.setFileSystemContext(builder, this.getDefaultFileSystemContext());
        }
        EngineAccessor.SOURCE.setEmbedderSource(builder, true);
        if (url != null) {
            EngineAccessor.SOURCE.setURL(builder, url);
        }
        if (path != null) {
            EngineAccessor.SOURCE.setPath(builder, path);
        }
        if (content instanceof CharSequence) {
            builder.content((CharSequence)content);
        } else if (content instanceof ByteSequence) {
            builder.content((ByteSequence)content);
        }
        builder.uri(uri);
        builder.name(name);
        builder.internal(internal);
        builder.interactive(interactive);
        builder.mimeType(mimeType);
        builder.cached(cached);
        builder.encoding(encoding);
        try {
            return PolyglotImpl.getOrCreatePolyglotSource(this, builder.build());
        }
        catch (IOException | RuntimeException e2) {
            throw e2;
        }
        catch (Exception e3) {
            throw CompilerDirectives.shouldNotReachHere(e3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getDefaultFileSystemContext() {
        Object res = this.defaultFileSystemContext;
        if (res == null) {
            PolyglotImpl polyglotImpl = this;
            synchronized (polyglotImpl) {
                res = this.defaultFileSystemContext;
                if (res == null) {
                    EmbedderFileSystemContext context = new EmbedderFileSystemContext(this);
                    this.defaultFileSystemContext = res = EngineAccessor.LANGUAGE.createFileSystemContext(context, context.fileSystem);
                }
            }
        }
        return res;
    }

    static org.pkl.thirdparty.graalvm.polyglot.Source getOrCreatePolyglotSource(PolyglotImpl polyglot, Source source) {
        return EngineAccessor.SOURCE.getOrCreatePolyglotSource(source, t -> polyglot.getAPIAccess().newSource(polyglot.sourceDispatch, t));
    }

    static SourceSection getPolyglotSourceSection(PolyglotImpl polyglot, org.pkl.thirdparty.truffle.api.source.SourceSection sourceSection) {
        if (sourceSection == null) {
            return null;
        }
        org.pkl.thirdparty.graalvm.polyglot.Source polyglotSource = PolyglotImpl.getOrCreatePolyglotSource(polyglot, sourceSection.getSource());
        return polyglot.getAPIAccess().newSourceSection(polyglotSource, polyglot.sourceSectionDispatch, sourceSection);
    }

    @CompilerDirectives.TruffleBoundary
    static <T extends Throwable> RuntimeException engineToLanguageException(Throwable t) throws T {
        assert (!(t instanceof PolyglotException)) : "polyglot exceptions must not be thrown to the guest language";
        PolyglotEngineException.rethrow(t);
        throw t;
    }

    @CompilerDirectives.TruffleBoundary
    static <T extends Throwable> RuntimeException engineToInstrumentException(Throwable t) throws T {
        assert (!(t instanceof PolyglotException)) : "polyglot exceptions must not be thrown to the guest instrument";
        PolyglotEngineException.rethrow(t);
        throw t;
    }

    @CompilerDirectives.TruffleBoundary
    static <T extends Throwable> PolyglotException guestToHostException(PolyglotLanguageContext languageContext, T e2, boolean entered) {
        PolyglotExceptionImpl exceptionImpl;
        assert (!(e2 instanceof PolyglotException)) : "polyglot exceptions must not be thrown to the host: " + e2;
        PolyglotEngineException.rethrow(e2);
        if (languageContext == null) {
            throw new RuntimeException(e2);
        }
        PolyglotContextImpl context = languageContext.context;
        PolyglotExceptionImpl suppressedImpl = null;
        PolyglotContextImpl.State localContextState = context.state;
        if (localContextState.isInvalidOrClosed()) {
            exceptionImpl = new PolyglotExceptionImpl(context.engine.impl, context.engine, localContextState, context.invalidResourceLimit, context.exitCode, languageContext, e2, false, false);
        } else {
            try {
                exceptionImpl = new PolyglotExceptionImpl(languageContext.getImpl(), languageContext.context.engine, localContextState, false, 0, languageContext, e2, true, entered);
            }
            catch (Throwable t) {
                exceptionImpl = new PolyglotExceptionImpl(context.engine, localContextState, false, 0, e2);
                suppressedImpl = new PolyglotExceptionImpl(context.engine, localContextState, false, 0, t);
            }
        }
        AbstractPolyglotImpl.APIAccess access = PolyglotImpl.getInstance().getAPIAccess();
        PolyglotException polyglotException = access.newLanguageException(exceptionImpl.getMessage(), PolyglotImpl.getInstance().exceptionDispatch, exceptionImpl);
        if (suppressedImpl != null) {
            polyglotException.addSuppressed(access.newLanguageException(exceptionImpl.getMessage(), PolyglotImpl.getInstance().exceptionDispatch, suppressedImpl));
        }
        return polyglotException;
    }

    static <T extends Throwable> PolyglotException guestToHostException(PolyglotEngineImpl engine, T e2) {
        assert (!(e2 instanceof PolyglotException)) : "polyglot exceptions must not be thrown to the host: " + e2;
        PolyglotEngineException.rethrow(e2);
        AbstractPolyglotImpl.APIAccess access = engine.getAPIAccess();
        PolyglotExceptionImpl exceptionImpl = new PolyglotExceptionImpl(engine, null, false, 0, e2);
        return access.newLanguageException(exceptionImpl.getMessage(), PolyglotImpl.getInstance().exceptionDispatch, exceptionImpl);
    }

    @CompilerDirectives.TruffleBoundary
    static <T extends Throwable> PolyglotException guestToHostException(PolyglotImpl polyglot, T e2) {
        assert (!(e2 instanceof PolyglotException)) : "polyglot exceptions must not be thrown to the host: " + e2;
        PolyglotEngineException.rethrow(e2);
        AbstractPolyglotImpl.APIAccess access = polyglot.getAPIAccess();
        PolyglotExceptionImpl exceptionImpl = new PolyglotExceptionImpl(polyglot, e2);
        return access.newLanguageException(exceptionImpl.getMessage(), PolyglotImpl.getInstance().exceptionDispatch, exceptionImpl);
    }

    static RuntimeException hostToGuestException(PolyglotEngineImpl engine, Throwable t) {
        return engine.polyglotHostService.hostToGuestException(engine.host, t);
    }

    static IllegalArgumentException sandboxPolicyException(SandboxPolicy sandboxPolicy, String reason, String fix) {
        Objects.requireNonNull(sandboxPolicy);
        Objects.requireNonNull(reason);
        Objects.requireNonNull(fix);
        String spawnIsolateHelp = sandboxPolicy.isStricterOrEqual(SandboxPolicy.ISOLATED) ? " If you switch to a less strict sandbox policy you can still spawn an isolate with an isolated heap using Builder.option(\"engine.SpawnIsolate\",\"true\")." : "";
        String message = String.format("The validation for the given sandbox policy %s failed. %s In order to resolve this %s or switch to a less strict sandbox policy using Builder.sandbox(SandboxPolicy).%s", new Object[]{sandboxPolicy, reason, fix, spawnIsolateHelp});
        return new IllegalArgumentException(message);
    }

    static boolean isGuestPrimitive(Object receiver) {
        return receiver instanceof Integer || receiver instanceof Double || receiver instanceof Long || receiver instanceof Float || receiver instanceof Boolean || receiver instanceof Character || receiver instanceof Byte || receiver instanceof Short || receiver instanceof String || receiver instanceof TruffleString;
    }

    static final class EmbedderFileSystemContext {
        private final PolyglotImpl impl;
        final org.pkl.thirdparty.graalvm.polyglot.io.FileSystem fileSystem = FileSystems.newDefaultFileSystem();
        final Map<String, LanguageCache> cachedLanguages = LanguageCache.languages();
        final Supplier<Map<String, Collection<? extends TruffleFile.FileTypeDetector>>> fileTypeDetectors = FileSystems.newFileTypeDetectorsSupplier(this.cachedLanguages.values());

        EmbedderFileSystemContext(PolyglotImpl impl) {
            this.impl = Objects.requireNonNull(impl);
        }

        PolyglotImpl getImpl() {
            return this.impl;
        }
    }

    static interface VMObject {
        public PolyglotEngineImpl getEngine();

        default public PolyglotImpl getImpl() {
            return this.getEngine().impl;
        }

        default public AbstractPolyglotImpl.APIAccess getAPIAccess() {
            return this.getEngine().impl.getAPIAccess();
        }
    }
}

