/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.spring.boot;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.pkl.core.Composite;
import org.pkl.core.Evaluator;
import org.pkl.core.EvaluatorBuilder;
import org.pkl.core.ModuleSource;
import org.pkl.core.PModule;
import org.springframework.boot.env.PropertySourceLoader;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.Resource;
import org.springframework.util.StreamUtils;

public class PklPropertySourceLoader
implements PropertySourceLoader {
    public String[] getFileExtensions() {
        return new String[]{"pkl", "pcf"};
    }

    public List<PropertySource<?>> load(String propertySourceName, Resource resource) throws IOException {
        PModule module;
        String text = StreamUtils.copyToString((InputStream)resource.getInputStream(), (Charset)StandardCharsets.UTF_8);
        try (Evaluator evaluator = EvaluatorBuilder.preconfigured().build();){
            module = evaluator.evaluate(ModuleSource.create((URI)resource.getURI(), (String)text));
        }
        LinkedHashMap result = new LinkedHashMap();
        module.getProperties().forEach((name, value) -> PklPropertySourceLoader.flatten(name, value, result));
        return List.of(new MapPropertySource(propertySourceName, result));
    }

    private static void flatten(String propertyName, Object propertyValue, Map<String, Object> result) {
        if (propertyValue instanceof Composite) {
            PklPropertySourceLoader.flatten(propertyName, ((Composite)propertyValue).getProperties(), result);
        } else if (propertyValue instanceof Map) {
            Map map = (Map)propertyValue;
            if (map.isEmpty()) {
                result.put(propertyName, Collections.emptyMap());
            } else {
                map.forEach((name, value) -> PklPropertySourceLoader.flatten(propertyName + "." + name, value, result));
            }
        } else if (propertyValue instanceof Collection) {
            Collection collection = (Collection)propertyValue;
            if (collection.isEmpty()) {
                result.put(propertyName, propertyValue instanceof Set ? Collections.emptySet() : Collections.emptyList());
            } else {
                int index = 0;
                for (Object element : collection) {
                    PklPropertySourceLoader.flatten(propertyName + "[" + index++ + "]", element, result);
                }
            }
        } else {
            result.put(propertyName, propertyValue);
        }
    }
}

