/*
 * Decompiled with CFR 0.152.
 */
package examples;

import examples.TestAutoregister;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.postgis.Geometry;
import org.postgis.PGgeometry;
import org.postgis.binary.BinaryParser;
import org.postgis.binary.BinaryWriter;
import org.postgresql.util.PGtokenizer;

public class TestParser {
    public static String ALL = "ALL";
    public static String ONLY10 = "ONLY10";
    public static String EQUAL10 = "EQUAL10";
    public static final String[][] testset = new String[][]{{ALL, "POINT(10 10)"}, {ALL, "POINT(10 10 0)"}, {ALL, "POINT(10 10 20)"}, {ALL, "POINT(1e100 1.2345e-100 -2e-5)"}, {ONLY10, "POINTM(10 10 20)"}, {ONLY10, "POINT(10 10 20 30)"}, {ALL, "MULTIPOINT(11 12, 20 20)"}, {ALL, "MULTIPOINT(11 12 13, 20 20 20)"}, {ONLY10, "MULTIPOINTM(11 12 13, 20 20 20)"}, {ONLY10, "MULTIPOINT(11 12 13 14,20 20 20 20)"}, {ALL, "MULTIPOINT((11 12), (20 20))"}, {ALL, "MULTIPOINT((11 12 13), (20 20 20))"}, {ONLY10, "MULTIPOINTM((11 12 13), (20 20 20))"}, {ONLY10, "MULTIPOINT((11 12 13 14),(20 20 20 20))"}, {ALL, "LINESTRING(10 10,20 20,50 50,34 34)"}, {ALL, "LINESTRING(10 10 20,20 20 20,50 50 50,34 34 34)"}, {ONLY10, "LINESTRINGM(10 10 20,20 20 20,50 50 50,34 34 34)"}, {ONLY10, "LINESTRING(10 10 20 20,20 20 20 20,50 50 50 50,34 34 34 50)"}, {ALL, "POLYGON((10 10,20 10,20 20,20 10,10 10),(5 5,5 6,6 6,6 5,5 5))"}, {ALL, "POLYGON((10 10 0,20 10 0,20 20 0,20 10 0,10 10 0),(5 5 0,5 6 0,6 6 0,6 5 0,5 5 0))"}, {ONLY10, "POLYGONM((10 10 0,20 10 0,20 20 0,20 10 0,10 10 0),(5 5 0,5 6 0,6 6 0,6 5 0,5 5 0))"}, {ONLY10, "POLYGON((10 10 0 7,20 10 0 7,20 20 0 7,20 10 0 7,10 10 0 7),(5 5 0 7,5 6 0 7,6 6 0 7,6 5 0 7,5 5 0 7))"}, {ALL, "MULTIPOLYGON(((10 10,20 10,20 20,20 10,10 10),(5 5,5 6,6 6,6 5,5 5)),((10 10,20 10,20 20,20 10,10 10),(5 5,5 6,6 6,6 5,5 5)))"}, {ALL, "MULTIPOLYGON(((10 10 0,20 10 0,20 20 0,20 10 0,10 10 0),(5 5 0,5 6 0,6 6 0,6 5 0,5 5 0)),((10 10 0,20 10 0,20 20 0,20 10 0,10 10 0),(5 5 0,5 6 0,6 6 0,6 5 0,5 5 0)))"}, {ONLY10, "MULTIPOLYGONM(((10 10 0,20 10 0,20 20 0,20 10 0,10 10 0),(5 5 0,5 6 0,6 6 0,6 5 0,5 5 0)),((10 10 0,20 10 0,20 20 0,20 10 0,10 10 0),(5 5 0,5 6 0,6 6 0,6 5 0,5 5 0)))"}, {ONLY10, "MULTIPOLYGON(((10 10 0 7,20 10 0 7,20 20 0 7,20 10 0 7,10 10 0 7),(5 5 0 7,5 6 0 7,6 6 0 7,6 5 0 7,5 5 0 7)),((10 10 0 7,20 10 0 7,20 20 0 7,20 10 0 7,10 10 0 7),(5 5 0 7,5 6 0 7,6 6 0 7,6 5 0 7,5 5 0 7)))"}, {ALL, "MULTILINESTRING((10 10,20 10,20 20,20 10,10 10),(5 5,5 6,6 6,6 5,5 5))"}, {ALL, "MULTILINESTRING((10 10 5,20 10 5,20 20 0,20 10 0,10 10 0),(5 5 0,5 6 0,6 6 0,6 5 0,5 5 0))"}, {ONLY10, "MULTILINESTRINGM((10 10 7,20 10 7,20 20 0,20 10 0,10 10 0),(5 5 0,5 6 0,6 6 0,6 5 0,5 5 0))"}, {ONLY10, "MULTILINESTRING((10 10 0 7,20 10 0 7,20 20 0 7,20 10 0 7,10 10 0 7),(5 5 0 7,5 6 0 7,6 6 0 7,6 5 0 7,5 5 0 7))"}, {ALL, "GEOMETRYCOLLECTION(POINT(10 10),POINT(20 20))"}, {ALL, "GEOMETRYCOLLECTION(POINT(10 10 20),POINT(20 20 20))"}, {ONLY10, "GEOMETRYCOLLECTIONM(POINT(10 10 20),POINT(20 20 20))"}, {ONLY10, "GEOMETRYCOLLECTION(POINT(10 10 20 7),POINT(20 20 20 7))"}, {ALL, "GEOMETRYCOLLECTION(LINESTRING(10 10 20,20 20 20, 50 50 50, 34 34 34),LINESTRING(10 10 20,20 20 20, 50 50 50, 34 34 34))"}, {ALL, "GEOMETRYCOLLECTION(POLYGON((10 10 0,20 10 0,20 20 0,20 10 0,10 10 0),(5 5 0,5 6 0,6 6 0,6 5 0,5 5 0)),POLYGON((10 10 0,20 10 0,20 20 0,20 10 0,10 10 0),(5 5 0,5 6 0,6 6 0,6 5 0,5 5 0)))"}, {ONLY10, "GEOMETRYCOLLECTION(MULTIPOINT(10 10 10, 20 20 20),MULTIPOINT(10 10 10, 20 20 20))"}, {ONLY10, "GEOMETRYCOLLECTION(MULTIPOINT((10 10 10), (20 20 20)),MULTIPOINT((10 10 10), (20 20 20)))"}, {EQUAL10, "GEOMETRYCOLLECTION(MULTILINESTRING((10 10 0,20 10 0,20 20 0,20 10 0,10 10 0),(5 5 0,5 6 0,6 6 0,6 5 0,5 5 0)))"}, {EQUAL10, "GEOMETRYCOLLECTION(MULTIPOLYGON(((10 10 0,20 10 0,20 20 0,20 10 0,10 10 0),(5 5 0,5 6 0,6 6 0,6 5 0,5 5 0)),((10 10 0,20 10 0,20 20 0,20 10 0,10 10 0),(5 5 0,5 6 0,6 6 0,6 5 0,5 5 0))),MULTIPOLYGON(((10 10 0,20 10 0,20 20 0,20 10 0,10 10 0),(5 5 0,5 6 0,6 6 0,6 5 0,5 5 0)),((10 10 0,20 10 0,20 20 0,20 10 0,10 10 0),(5 5 0,5 6 0,6 6 0,6 5 0,5 5 0))))"}, {ALL, "GEOMETRYCOLLECTION(POINT(10 10 20),LINESTRING(10 10 20,20 20 20, 50 50 50, 34 34 34),POLYGON((10 10 0,20 10 0,20 20 0,20 10 0,10 10 0),(5 5 0,5 6 0,6 6 0,6 5 0,5 5 0)))"}, {ONLY10, "GEOMETRYCOLLECTION(POINT(10 10 20),MULTIPOINT(10 10 10, 20 20 20),LINESTRING(10 10 20,20 20 20, 50 50 50, 34 34 34),POLYGON((10 10 0,20 10 0,20 20 0,20 10 0,10 10 0),(5 5 0,5 6 0,6 6 0,6 5 0,5 5 0)),MULTIPOLYGON(((10 10 0,20 10 0,20 20 0,20 10 0,10 10 0),(5 5 0,5 6 0,6 6 0,6 5 0,5 5 0)),((10 10 0,20 10 0,20 20 0,20 10 0,10 10 0),(5 5 0,5 6 0,6 6 0,6 5 0,5 5 0))),MULTILINESTRING((10 10 0,20 10 0,20 20 0,20 10 0,10 10 0),(5 5 0,5 6 0,6 6 0,6 5 0,5 5 0)))"}, {ONLY10, "GEOMETRYCOLLECTION(POINT(10 10 20),MULTIPOINT((10 10 10), (20 20 20)),LINESTRING(10 10 20,20 20 20, 50 50 50, 34 34 34),POLYGON((10 10 0,20 10 0,20 20 0,20 10 0,10 10 0),(5 5 0,5 6 0,6 6 0,6 5 0,5 5 0)),MULTIPOLYGON(((10 10 0,20 10 0,20 20 0,20 10 0,10 10 0),(5 5 0,5 6 0,6 6 0,6 5 0,5 5 0)),((10 10 0,20 10 0,20 20 0,20 10 0,10 10 0),(5 5 0,5 6 0,6 6 0,6 5 0,5 5 0))),MULTILINESTRING((10 10 0,20 10 0,20 20 0,20 10 0,10 10 0),(5 5 0,5 6 0,6 6 0,6 5 0,5 5 0)))"}, {ALL, "GEOMETRYCOLLECTION(EMPTY)"}, {ALL, "GEOMETRYCOLLECTION EMPTY"}, {ONLY10, "POINT EMPTY"}, {ONLY10, "LINESTRING EMPTY"}, {ONLY10, "POLYGON EMPTY"}, {ONLY10, "MULTIPOINT EMPTY"}, {ONLY10, "MULTILINESTRING EMPTY"}, {ONLY10, "MULTIPOLYGON EMPTY"}};
    public static final int SRID = 4326;
    public static final String SRIDPREFIX = "SRID=4326;";
    public static int failcount = 0;
    private static BinaryParser bp = new BinaryParser();
    private static final BinaryWriter bw = new BinaryWriter();

    public static void test(String string, Connection[] connectionArray, String string2) throws SQLException {
        System.out.println("Original:  " + string);
        Geometry geometry = PGgeometry.geomFromString(string);
        String string3 = geometry.toString();
        System.out.println("Parsed:    " + string3);
        Geometry geometry2 = PGgeometry.geomFromString(string3);
        String string4 = geometry2.toString();
        System.out.println("Re-Parsed: " + string4);
        if (!geometry.equals(geometry2)) {
            System.out.println("--- Geometries are not equal!");
            ++failcount;
        } else if (!string4.equals(string3)) {
            System.out.println("--- Text Reps are not equal!");
            ++failcount;
        } else {
            System.out.println("Equals:    yes");
        }
        String string5 = bw.writeHexed(geometry2, (byte)1);
        System.out.println("NDRHex:    " + string5);
        geometry2 = PGgeometry.geomFromString(string5);
        System.out.println("ReNDRHex:  " + geometry2.toString());
        if (!geometry.equals(geometry2)) {
            System.out.println("--- Geometries are not equal!");
            ++failcount;
        } else {
            System.out.println("Equals:    yes");
        }
        String string6 = bw.writeHexed(geometry2, (byte)0);
        System.out.println("XDRHex:    " + string6);
        geometry2 = PGgeometry.geomFromString(string6);
        System.out.println("ReXDRHex:  " + geometry2.toString());
        if (!geometry.equals(geometry2)) {
            System.out.println("--- Geometries are not equal!");
            ++failcount;
        } else {
            System.out.println("Equals:    yes");
        }
        byte[] byArray = bw.writeBinary(geometry2, (byte)1);
        geometry2 = bp.parse(byArray);
        System.out.println("NDR:       " + geometry2.toString());
        if (!geometry.equals(geometry2)) {
            System.out.println("--- Geometries are not equal!");
            ++failcount;
        } else {
            System.out.println("Equals:    yes");
        }
        byte[] byArray2 = bw.writeBinary(geometry2, (byte)0);
        geometry2 = bp.parse(byArray2);
        System.out.println("XDR:       " + geometry2.toString());
        if (!geometry.equals(geometry2)) {
            System.out.println("--- Geometries are not equal!");
            ++failcount;
        } else {
            System.out.println("Equals:    yes");
        }
        for (int i = 0; i < connectionArray.length; ++i) {
            Connection connection = connectionArray[i];
            Statement statement = connection.createStatement();
            int n = TestAutoregister.getPostgisMajor(statement);
            if (string2 == ONLY10 && n < 1) {
                System.out.println("PostGIS server too old, skipping test on connection " + i + ": " + connection.getCatalog());
            } else {
                Geometry geometry3;
                System.out.println("Testing on connection " + i + ": " + connection.getCatalog());
                try {
                    geometry3 = TestParser.viaSQL(string, statement);
                    System.out.println("SQLin    : " + geometry3.toString());
                    if (!geometry.equals(geometry3)) {
                        System.out.println("--- Geometries after SQL are not equal!");
                        if (string2 == EQUAL10 && n < 1) {
                            System.out.println("--- This is expected with PostGIS " + n + ".X");
                        } else {
                            ++failcount;
                        }
                    } else {
                        System.out.println("Eq SQL in: yes");
                    }
                }
                catch (SQLException sQLException) {
                    System.out.println("--- Server side error: " + sQLException.toString());
                    ++failcount;
                }
                try {
                    geometry3 = TestParser.viaSQL(string3, statement);
                    System.out.println("SQLout  :  " + geometry3.toString());
                    if (!geometry.equals(geometry3)) {
                        System.out.println("--- reparsed Geometries after SQL are not equal!");
                        if (string2 == EQUAL10 && n < 1) {
                            System.out.println("--- This is expected with PostGIS " + n + ".X");
                        } else {
                            ++failcount;
                        }
                    } else {
                        System.out.println("Eq SQLout: yes");
                    }
                }
                catch (SQLException sQLException) {
                    System.out.println("--- Server side error: " + sQLException.toString());
                    ++failcount;
                }
                try {
                    geometry3 = TestParser.viaPrepSQL(geometry, connection);
                    System.out.println("Prepared:  " + geometry3.toString());
                    if (!geometry.equals(geometry3)) {
                        System.out.println("--- reparsed Geometries after prepared StatementSQL are not equal!");
                        if (string2 == EQUAL10 && n < 1) {
                            System.out.println("--- This is expected with PostGIS " + n + ".X");
                        } else {
                            ++failcount;
                        }
                    } else {
                        System.out.println("Eq Prep: yes");
                    }
                }
                catch (SQLException sQLException) {
                    System.out.println("--- Server side error: " + sQLException.toString());
                    ++failcount;
                }
                try {
                    if (n >= 1) {
                        geometry3 = TestParser.ewktViaSQL(string, statement);
                        System.out.println("asEWKT   : " + geometry3.toString());
                        if (!geometry.equals(geometry3)) {
                            System.out.println("--- Geometries after EWKT SQL are not equal!");
                            ++failcount;
                        } else {
                            System.out.println("equal   : yes");
                        }
                    }
                }
                catch (SQLException sQLException) {
                    System.out.println("--- Server side error: " + sQLException.toString());
                    ++failcount;
                }
                try {
                    if (n >= 1) {
                        geometry3 = TestParser.ewkbViaSQL(string, statement);
                        System.out.println("asEWKB   : " + geometry3.toString());
                        if (!geometry.equals(geometry3)) {
                            System.out.println("--- Geometries after EWKB SQL are not equal!");
                            ++failcount;
                        } else {
                            System.out.println("equal    : yes");
                        }
                    }
                }
                catch (SQLException sQLException) {
                    System.out.println("--- Server side error: " + sQLException.toString());
                    ++failcount;
                }
                try {
                    if (n >= 1) {
                        geometry3 = TestParser.viaSQL(string5, statement);
                        System.out.println("hexNWKT:   " + geometry3.toString());
                        if (!geometry.equals(geometry3)) {
                            System.out.println("--- Geometries after EWKB SQL are not equal!");
                            ++failcount;
                        } else {
                            System.out.println("equal    : yes");
                        }
                    }
                }
                catch (SQLException sQLException) {
                    System.out.println("--- Server side error: " + sQLException.toString());
                    ++failcount;
                }
                try {
                    if (n >= 1) {
                        geometry3 = TestParser.viaSQL(string6, statement);
                        System.out.println("hexXWKT:   " + geometry3.toString());
                        if (!geometry.equals(geometry3)) {
                            System.out.println("--- Geometries after EWKB SQL are not equal!");
                            ++failcount;
                        } else {
                            System.out.println("equal    : yes");
                        }
                    }
                }
                catch (SQLException sQLException) {
                    System.out.println("--- Server side error: " + sQLException.toString());
                    ++failcount;
                }
                try {
                    if (n >= 1) {
                        geometry3 = TestParser.binaryViaSQL(byArray, connection);
                        System.out.println("NWKT:      " + geometry3.toString());
                        if (!geometry.equals(geometry3)) {
                            System.out.println("--- Geometries after EWKB SQL are not equal!");
                            ++failcount;
                        } else {
                            System.out.println("equal    : yes");
                        }
                    }
                }
                catch (SQLException sQLException) {
                    System.out.println("--- Server side error: " + sQLException.toString());
                    ++failcount;
                }
                try {
                    if (n >= 1) {
                        geometry3 = TestParser.binaryViaSQL(byArray2, connection);
                        System.out.println("XWKT:      " + geometry3.toString());
                        if (!geometry.equals(geometry3)) {
                            System.out.println("--- Geometries after EWKB SQL are not equal!");
                            ++failcount;
                        } else {
                            System.out.println("equal    : yes");
                        }
                    }
                }
                catch (SQLException sQLException) {
                    System.out.println("--- Server side error: " + sQLException.toString());
                    ++failcount;
                }
            }
            statement.close();
        }
        System.out.println("***");
    }

    private static Geometry viaSQL(String string, Statement statement) throws SQLException {
        ResultSet resultSet = statement.executeQuery("SELECT geometry_in('" + string + "')");
        resultSet.next();
        return ((PGgeometry)((Object)resultSet.getObject(1))).getGeometry();
    }

    private static Geometry viaPrepSQL(Geometry geometry, Connection connection) throws SQLException {
        PreparedStatement preparedStatement = connection.prepareStatement("SELECT ?::geometry");
        PGgeometry pGgeometry = new PGgeometry(geometry);
        preparedStatement.setObject(1, (Object)pGgeometry, 1111);
        ResultSet resultSet = preparedStatement.executeQuery();
        resultSet.next();
        PGgeometry pGgeometry2 = (PGgeometry)((Object)resultSet.getObject(1));
        return pGgeometry2.getGeometry();
    }

    private static Geometry ewktViaSQL(String string, Statement statement) throws SQLException {
        ResultSet resultSet = statement.executeQuery("SELECT asEWKT(geometry_in('" + string + "'))");
        resultSet.next();
        String string2 = resultSet.getString(1);
        return PGgeometry.geomFromString(string2);
    }

    private static Geometry ewkbViaSQL(String string, Statement statement) throws SQLException {
        ResultSet resultSet = statement.executeQuery("SELECT asEWKB(geometry_in('" + string + "'))");
        resultSet.next();
        byte[] byArray = resultSet.getBytes(1);
        return bp.parse(byArray);
    }

    private static Geometry binaryViaSQL(byte[] byArray, Connection connection) throws SQLException {
        PreparedStatement preparedStatement = connection.prepareStatement("SELECT ?::bytea::geometry");
        preparedStatement.setBytes(1, byArray);
        ResultSet resultSet = preparedStatement.executeQuery();
        resultSet.next();
        PGgeometry pGgeometry = (PGgeometry)((Object)resultSet.getObject(1));
        return pGgeometry.getGeometry();
    }

    public static Connection connect(String string, String string2, String string3) throws SQLException {
        Connection connection = DriverManager.getConnection(string, string2, string3);
        return connection;
    }

    public static void loadDrivers() throws ClassNotFoundException {
        Class.forName("org.postgis.DriverWrapper");
        Class.forName("org.postgis.DriverWrapperAutoprobe");
    }

    public static void main(String[] stringArray) throws SQLException, ClassNotFoundException {
        int n;
        PGtokenizer pGtokenizer;
        TestParser.loadDrivers();
        String string = null;
        String string2 = null;
        if (stringArray.length == 1 && stringArray[0].equalsIgnoreCase("offline")) {
            System.out.println("Performing only offline tests");
            pGtokenizer = new PGtokenizer("", ';');
        } else if (stringArray.length == 3) {
            System.out.println("Performing offline and online tests");
            pGtokenizer = new PGtokenizer(stringArray[0], ';');
            string = stringArray[1];
            string2 = stringArray[2];
        } else {
            System.err.println("Usage: java examples/TestParser dburls user pass");
            System.err.println("   or: java examples/TestParser offline");
            System.err.println();
            System.err.println("dburls has one or more jdbc urls separated by ; in the following format");
            System.err.println("jdbc:postgresql://HOST:PORT/DATABASENAME");
            System.exit(1);
            return;
        }
        Connection[] connectionArray = new Connection[pGtokenizer.getSize()];
        for (n = 0; n < pGtokenizer.getSize(); ++n) {
            System.out.println("Creating JDBC connection to " + pGtokenizer.getToken(n));
            connectionArray[n] = TestParser.connect(pGtokenizer.getToken(n), string, string2);
        }
        System.out.println("Performing tests...");
        System.out.println("***");
        for (n = 0; n < testset.length; ++n) {
            TestParser.test(testset[n][1], connectionArray, testset[n][0]);
            TestParser.test(SRIDPREFIX + testset[n][1], connectionArray, testset[n][0]);
        }
        System.out.print("cleaning up...");
        for (n = 0; n < connectionArray.length; ++n) {
            connectionArray[n].close();
        }
        System.out.println("Finished, " + failcount + " tests failed!");
        System.err.println("Finished, " + failcount + " tests failed!");
        System.exit(failcount);
    }
}

