/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql;

import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.unix.DomainSocketAddress;
import io.r2dbc.postgresql.DefaultPortalNameSupplier;
import io.r2dbc.postgresql.DefaultPostgresqlReplicationConnection;
import io.r2dbc.postgresql.ExceptionFactory;
import io.r2dbc.postgresql.Extensions;
import io.r2dbc.postgresql.PostgresqlConnection;
import io.r2dbc.postgresql.PostgresqlConnectionConfiguration;
import io.r2dbc.postgresql.PostgresqlConnectionFactoryMetadata;
import io.r2dbc.postgresql.StatementCache;
import io.r2dbc.postgresql.api.PostgresqlReplicationConnection;
import io.r2dbc.postgresql.authentication.AuthenticationHandler;
import io.r2dbc.postgresql.authentication.PasswordAuthenticationHandler;
import io.r2dbc.postgresql.authentication.SASLAuthenticationHandler;
import io.r2dbc.postgresql.client.Client;
import io.r2dbc.postgresql.client.ConnectionSettings;
import io.r2dbc.postgresql.client.ReactorNettyClient;
import io.r2dbc.postgresql.client.SSLConfig;
import io.r2dbc.postgresql.client.SSLMode;
import io.r2dbc.postgresql.client.StartupMessageFlow;
import io.r2dbc.postgresql.codec.DefaultCodecs;
import io.r2dbc.postgresql.extension.CodecRegistrar;
import io.r2dbc.postgresql.message.backend.AuthenticationMessage;
import io.r2dbc.postgresql.util.Assert;
import io.r2dbc.spi.ConnectionFactory;
import io.r2dbc.spi.ConnectionFactoryMetadata;
import io.r2dbc.spi.IsolationLevel;
import io.r2dbc.spi.R2dbcException;
import io.r2dbc.spi.R2dbcNonTransientResourceException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

public final class PostgresqlConnectionFactory
implements ConnectionFactory {
    private static final String REPLICATION_OPTION = "replication";
    private static final String REPLICATION_DATABASE = "database";
    private final Function<ConnectionSettings, Mono<? extends Client>> clientFactory;
    private final PostgresqlConnectionConfiguration configuration;
    private final SocketAddress endpoint;
    private final Extensions extensions;

    public PostgresqlConnectionFactory(PostgresqlConnectionConfiguration configuration) {
        this.configuration = Assert.requireNonNull(configuration, "configuration must not be null");
        this.endpoint = PostgresqlConnectionFactory.createSocketAddress(configuration);
        this.clientFactory = settings -> ReactorNettyClient.connect(this.endpoint, settings).cast(Client.class);
        this.extensions = PostgresqlConnectionFactory.getExtensions(configuration);
    }

    PostgresqlConnectionFactory(Function<ConnectionSettings, Mono<? extends Client>> clientFactory, PostgresqlConnectionConfiguration configuration) {
        this.configuration = Assert.requireNonNull(configuration, "configuration must not be null");
        this.endpoint = PostgresqlConnectionFactory.createSocketAddress(configuration);
        this.clientFactory = Assert.requireNonNull(clientFactory, "clientFactory must not be null");
        this.extensions = PostgresqlConnectionFactory.getExtensions(configuration);
    }

    private static SocketAddress createSocketAddress(PostgresqlConnectionConfiguration configuration) {
        if (!configuration.isUseSocket()) {
            return InetSocketAddress.createUnresolved(configuration.getRequiredHost(), configuration.getPort());
        }
        return DomainSocketFactory.getDomainSocketAddress(configuration);
    }

    private static Extensions getExtensions(PostgresqlConnectionConfiguration configuration) {
        Extensions extensions = Extensions.from(configuration.getExtensions());
        if (configuration.isAutodetectExtensions()) {
            extensions = extensions.mergeWith(Extensions.autodetect());
        }
        return extensions;
    }

    public Mono<io.r2dbc.postgresql.api.PostgresqlConnection> create() {
        if (this.isReplicationConnection()) {
            throw new UnsupportedOperationException("Cannot create replication connection through create(). Use replication() method instead.");
        }
        return this.doCreateConnection(false, this.configuration.getOptions()).cast(io.r2dbc.postgresql.api.PostgresqlConnection.class);
    }

    public Mono<PostgresqlReplicationConnection> replication() {
        LinkedHashMap<String, String> options = new LinkedHashMap<String, String>(this.configuration.getOptions());
        options.put(REPLICATION_OPTION, REPLICATION_DATABASE);
        return this.doCreateConnection(true, options).map(DefaultPostgresqlReplicationConnection::new);
    }

    private Mono<PostgresqlConnection> doCreateConnection(boolean forReplication, @Nullable Map<String, String> options) {
        SSLConfig sslConfig = this.configuration.getSslConfig();
        ConnectionSettings connectionSettings = this.configuration.getConnectionSettings();
        Predicate<Throwable> isAuthSpecificationError = e -> e instanceof ExceptionFactory.PostgresqlAuthenticationFailure;
        return this.tryConnectWithConfig(connectionSettings, options).onErrorResume(isAuthSpecificationError.and(e -> sslConfig.getSslMode() == SSLMode.ALLOW), e -> this.tryConnectWithConfig(connectionSettings.mutate(builder -> builder.sslConfig(sslConfig.mutateMode(SSLMode.REQUIRE))), options).onErrorResume(sslAuthError -> {
            e.addSuppressed((Throwable)sslAuthError);
            return Mono.error((Throwable)e);
        })).onErrorResume(isAuthSpecificationError.and(e -> sslConfig.getSslMode() == SSLMode.PREFER), e -> this.tryConnectWithConfig(connectionSettings.mutate(builder -> builder.sslConfig(sslConfig.mutateMode(SSLMode.DISABLE))), options).onErrorResume(sslAuthError -> {
            e.addSuppressed((Throwable)sslAuthError);
            return Mono.error((Throwable)e);
        })).flatMap(client -> {
            DefaultCodecs codecs = new DefaultCodecs(client.getByteBufAllocator(), this.configuration.isPreferAttachedBuffers());
            StatementCache statementCache = StatementCache.fromPreparedStatementCacheQueries(client, this.configuration.getPreparedStatementCacheQueries());
            PostgresqlConnection earlyConnection = new PostgresqlConnection((Client)client, codecs, DefaultPortalNameSupplier.INSTANCE, statementCache, IsolationLevel.READ_COMMITTED, this.configuration);
            Mono<IsolationLevel> isolationLevelMono = Mono.just((Object)IsolationLevel.READ_COMMITTED);
            if (!forReplication) {
                isolationLevelMono = this.getIsolationLevel(earlyConnection);
            }
            return isolationLevelMono.map(isolationLevel -> new PostgresqlConnection((Client)client, codecs, DefaultPortalNameSupplier.INSTANCE, statementCache, (IsolationLevel)isolationLevel, this.configuration)).delayUntil(connection -> this.prepareConnection((PostgresqlConnection)connection, client.getByteBufAllocator(), codecs, forReplication)).onErrorResume(throwable -> this.closeWithError((Client)client, (Throwable)throwable));
        }).onErrorMap(this::cannotConnect);
    }

    private boolean isReplicationConnection() {
        Map<String, String> options = this.configuration.getOptions();
        return REPLICATION_DATABASE.equalsIgnoreCase(options.get(REPLICATION_OPTION));
    }

    private Mono<Client> tryConnectWithConfig(ConnectionSettings settings, @Nullable Map<String, String> options) {
        return this.clientFactory.apply(settings).delayUntil(client -> StartupMessageFlow.exchange(this.configuration.getApplicationName(), this::getAuthenticationHandler, client, this.configuration.getDatabase(), this.configuration.getUsername(), options).handle(ExceptionFactory.INSTANCE::handleErrorResponse)).cast(Client.class);
    }

    private Publisher<?> prepareConnection(PostgresqlConnection connection, ByteBufAllocator byteBufAllocator, DefaultCodecs codecs, boolean forReplication) {
        ArrayList publishers = new ArrayList();
        if (!forReplication) {
            this.extensions.forEach(CodecRegistrar.class, it -> publishers.add(it.register(connection, byteBufAllocator, codecs)));
        }
        return Flux.concat(publishers).then();
    }

    private Mono<PostgresqlConnection> closeWithError(Client client, Throwable throwable) {
        return client.close().then(Mono.error((Throwable)throwable));
    }

    private Throwable cannotConnect(Throwable throwable) {
        if (throwable instanceof R2dbcException) {
            return throwable;
        }
        return new PostgresConnectionException(String.format("Cannot connect to %s", this.endpoint), throwable);
    }

    public ConnectionFactoryMetadata getMetadata() {
        return PostgresqlConnectionFactoryMetadata.INSTANCE;
    }

    PostgresqlConnectionConfiguration getConfiguration() {
        return this.configuration;
    }

    public String toString() {
        return "PostgresqlConnectionFactory{clientFactory=" + this.clientFactory + ", configuration=" + this.configuration + ", extensions=" + this.extensions + '}';
    }

    private AuthenticationHandler getAuthenticationHandler(AuthenticationMessage message) {
        if (PasswordAuthenticationHandler.supports(message)) {
            CharSequence password = Assert.requireNonNull(this.configuration.getPassword(), "Password must not be null");
            return new PasswordAuthenticationHandler(password, this.configuration.getUsername());
        }
        if (SASLAuthenticationHandler.supports(message)) {
            CharSequence password = Assert.requireNonNull(this.configuration.getPassword(), "Password must not be null");
            return new SASLAuthenticationHandler(password, this.configuration.getUsername());
        }
        throw new IllegalStateException(String.format("Unable to provide AuthenticationHandler capable of handling %s", message));
    }

    private Mono<IsolationLevel> getIsolationLevel(io.r2dbc.postgresql.api.PostgresqlConnection connection) {
        return connection.createStatement("SHOW TRANSACTION ISOLATION LEVEL").fetchSize(0).execute().flatMap(it -> it.map((row, rowMetadata) -> {
            String level = (String)row.get(0, String.class);
            if (level == null) {
                return IsolationLevel.READ_COMMITTED;
            }
            return IsolationLevel.valueOf((String)level.toUpperCase(Locale.US));
        })).defaultIfEmpty((Object)IsolationLevel.READ_COMMITTED).last();
    }

    static class DomainSocketFactory {
        DomainSocketFactory() {
        }

        private static SocketAddress getDomainSocketAddress(PostgresqlConnectionConfiguration configuration) {
            return new DomainSocketAddress(configuration.getRequiredSocket());
        }
    }

    static class PostgresConnectionException
    extends R2dbcNonTransientResourceException {
        public PostgresConnectionException(String msg, @Nullable Throwable cause) {
            super(msg, cause);
        }
    }
}

