/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.ReferenceCounted;
import io.r2dbc.postgresql.BindingLogger;
import io.r2dbc.postgresql.ConnectionResources;
import io.r2dbc.postgresql.ExceptionFactory;
import io.r2dbc.postgresql.ExtendedFlowDelegate;
import io.r2dbc.postgresql.PostgresqlResult;
import io.r2dbc.postgresql.PostgresqlSqlLexer;
import io.r2dbc.postgresql.TokenizedSql;
import io.r2dbc.postgresql.client.Binding;
import io.r2dbc.postgresql.client.ConnectionContext;
import io.r2dbc.postgresql.client.EncodedParameter;
import io.r2dbc.postgresql.client.SimpleQueryMessageFlow;
import io.r2dbc.postgresql.message.backend.BackendMessage;
import io.r2dbc.postgresql.message.backend.CommandComplete;
import io.r2dbc.postgresql.message.backend.EmptyQueryResponse;
import io.r2dbc.postgresql.message.backend.ErrorResponse;
import io.r2dbc.postgresql.message.frontend.Bind;
import io.r2dbc.postgresql.util.Assert;
import io.r2dbc.postgresql.util.GeneratedValuesUtils;
import io.r2dbc.postgresql.util.Operators;
import io.r2dbc.postgresql.util.PredicateUtils;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;

final class PostgresqlStatement
implements io.r2dbc.postgresql.api.PostgresqlStatement {
    private static final Predicate<BackendMessage> WINDOW_UNTIL;
    private final ArrayDeque<Binding> bindings;
    private final ConnectionResources resources;
    private final ConnectionContext connectionContext;
    private final TokenizedSql tokenizedSql;
    private int fetchSize;
    private String[] generatedColumns;

    PostgresqlStatement(ConnectionResources resources, String sql) {
        this.resources = Assert.requireNonNull(resources, "resources must not be null");
        this.tokenizedSql = PostgresqlSqlLexer.tokenize(Assert.requireNonNull(sql, "sql must not be null"));
        this.connectionContext = resources.getClient().getContext();
        this.bindings = new ArrayDeque(this.tokenizedSql.getParameterCount());
        if (this.tokenizedSql.getStatementCount() > 1 && this.tokenizedSql.getParameterCount() > 0) {
            throw new IllegalArgumentException(String.format("Statement '%s' cannot be created. This is often due to the presence of both multiple statements and parameters at the same time.", sql));
        }
        this.fetchSize(this.resources.getConfiguration().getFetchSize(sql));
    }

    @Override
    public PostgresqlStatement add() {
        Binding binding = this.bindings.peekLast();
        if (binding != null) {
            binding.validate();
        }
        this.bindings.add(new Binding(this.tokenizedSql.getParameterCount()));
        return this;
    }

    @Override
    public PostgresqlStatement bind(String identifier, Object value) {
        return this.bind(this.getIdentifierIndex(identifier), value);
    }

    @Override
    public PostgresqlStatement bind(int index, Object value) {
        Assert.requireNonNull(value, "value must not be null");
        BindingLogger.logBind(this.connectionContext, index, value);
        this.getCurrentOrFirstBinding().add(index, this.resources.getCodecs().encode(value));
        return this;
    }

    @Override
    public PostgresqlStatement bindNull(String identifier, Class<?> type) {
        return this.bindNull(this.getIdentifierIndex(identifier), (Class)type);
    }

    @Override
    public PostgresqlStatement bindNull(int index, Class<?> type) {
        Assert.requireNonNull(type, "type must not be null");
        if (index >= this.tokenizedSql.getParameterCount()) {
            throw new UnsupportedOperationException(String.format("Cannot bind parameter %d, statement has %d parameters", index, this.tokenizedSql.getParameterCount()));
        }
        BindingLogger.logBindNull(this.connectionContext, index, type);
        this.getCurrentOrFirstBinding().add(index, this.resources.getCodecs().encodeNull(type));
        return this;
    }

    @Nonnull
    private Binding getCurrentOrFirstBinding() {
        Binding binding = this.bindings.peekLast();
        if (binding == null) {
            Binding newBinding = new Binding(this.tokenizedSql.getParameterCount());
            this.bindings.add(newBinding);
            return newBinding;
        }
        return binding;
    }

    @Override
    public Flux<io.r2dbc.postgresql.api.PostgresqlResult> execute() {
        if (this.generatedColumns == null) {
            return this.execute(this.tokenizedSql.getSql());
        }
        return this.execute(GeneratedValuesUtils.augment(this.tokenizedSql.getSql(), this.generatedColumns));
    }

    @Override
    public PostgresqlStatement returnGeneratedValues(String ... columns) {
        Assert.requireNonNull(columns, "columns must not be null");
        if (this.tokenizedSql.hasDefaultTokenValue("RETURNING")) {
            throw new IllegalStateException("Statement already includes RETURNING clause");
        }
        if (!this.tokenizedSql.hasDefaultTokenValue("DELETE", "INSERT", "UPDATE")) {
            throw new IllegalStateException("Statement is not a DELETE, INSERT, or UPDATE command");
        }
        this.generatedColumns = columns;
        return this;
    }

    @Override
    public PostgresqlStatement fetchSize(int rows) {
        Assert.isTrue(rows >= 0, "fetch size must be greater or equal zero");
        this.fetchSize = rows;
        return this;
    }

    public String toString() {
        return "PostgresqlStatement{bindings=" + this.bindings + ", context=" + this.resources + ", sql='" + this.tokenizedSql.getSql() + '\'' + ", generatedColumns=" + Arrays.toString(this.generatedColumns) + '}';
    }

    Binding getCurrentBinding() {
        return this.getCurrentOrFirstBinding();
    }

    private int getIdentifierIndex(String identifier) {
        Assert.requireNonNull(identifier, "identifier must not be null");
        Assert.requireType(identifier, String.class, "identifier must be a String");
        if (!identifier.startsWith("$")) {
            throw new NoSuchElementException(String.format("\"%s\" is not a valid identifier", identifier));
        }
        try {
            return Integer.parseInt(identifier.substring(1)) - 1;
        }
        catch (NumberFormatException e) {
            throw new NoSuchElementException(String.format("\"%s\" is not a valid identifier", identifier));
        }
    }

    private Flux<io.r2dbc.postgresql.api.PostgresqlResult> execute(String sql) {
        ExceptionFactory factory = ExceptionFactory.withSql(sql);
        if (this.tokenizedSql.getParameterCount() != 0) {
            if (this.bindings.size() == 0) {
                throw new IllegalStateException("No parameters have been bound");
            }
            this.bindings.forEach(Binding::validate);
            int fetchSize = this.fetchSize;
            return Flux.defer(() -> {
                if (this.bindings.size() == 1) {
                    Binding binding = this.bindings.peekFirst();
                    Flux messages = PostgresqlStatement.collectBindingParameters(binding).flatMapMany(values -> ExtendedFlowDelegate.runQuery(this.resources, factory, sql, binding, values, fetchSize));
                    return Flux.just((Object)PostgresqlResult.toResult(this.resources, (Flux<BackendMessage>)messages, factory));
                }
                Iterator<Binding> iterator = this.bindings.iterator();
                Sinks.Many bindings = Sinks.many().unicast().onBackpressureBuffer();
                AtomicBoolean canceled = new AtomicBoolean();
                return bindings.asFlux().map(it -> {
                    Flux messages = PostgresqlStatement.collectBindingParameters(it).flatMapMany(values -> ExtendedFlowDelegate.runQuery(this.resources, factory, sql, it, values, this.fetchSize)).doOnComplete(() -> PostgresqlStatement.tryNextBinding(iterator, (Sinks.Many<Binding>)bindings, canceled));
                    return PostgresqlResult.toResult(this.resources, (Flux<BackendMessage>)messages, factory);
                }).doOnCancel(() -> this.clearBindings(iterator, canceled)).doOnError(e -> this.clearBindings(iterator, canceled)).doOnSubscribe(it -> bindings.emitNext(iterator.next(), Sinks.EmitFailureHandler.FAIL_FAST));
            }).cast(io.r2dbc.postgresql.api.PostgresqlResult.class);
        }
        Flux<BackendMessage> exchange = this.fetchSize != 0 ? ExtendedFlowDelegate.runQuery(this.resources, factory, sql, Binding.EMPTY, Collections.emptyList(), this.fetchSize) : SimpleQueryMessageFlow.exchange(this.resources.getClient(), sql);
        return (Flux)exchange.windowUntil(WINDOW_UNTIL).doOnDiscard(ReferenceCounted.class, ReferenceCountUtil::release).map(messages -> PostgresqlResult.toResult(this.resources, (Flux<BackendMessage>)messages, factory)).as(Operators::discardOnCancel);
    }

    private static void tryNextBinding(Iterator<Binding> iterator, Sinks.Many<Binding> bindingSink, AtomicBoolean canceled) {
        if (canceled.get()) {
            return;
        }
        try {
            if (iterator.hasNext()) {
                bindingSink.emitNext((Object)iterator.next(), Sinks.EmitFailureHandler.FAIL_FAST);
            } else {
                bindingSink.emitComplete(Sinks.EmitFailureHandler.FAIL_FAST);
            }
        }
        catch (Exception e) {
            bindingSink.emitError((Throwable)e, Sinks.EmitFailureHandler.FAIL_FAST);
        }
    }

    private static Mono<List<ByteBuf>> collectBindingParameters(Binding binding) {
        return Flux.fromIterable(binding.getParameterValues()).concatMap(f -> {
            if (f == EncodedParameter.NULL_VALUE) {
                return Flux.just((Object)Bind.NULL_VALUE);
            }
            return Flux.from((Publisher)f).reduce((Object)Unpooled.compositeBuffer(), (c, b) -> c.addComponent(true, b));
        }).collectList();
    }

    private void clearBindings(Iterator<Binding> iterator, AtomicBoolean canceled) {
        canceled.set(true);
        while (iterator.hasNext()) {
            iterator.next();
        }
        this.bindings.forEach(Binding::clear);
    }

    static {
        Predicate[] predicateArray = new Predicate[3];
        predicateArray[0] = CommandComplete.class::isInstance;
        predicateArray[1] = EmptyQueryResponse.class::isInstance;
        predicateArray[2] = ErrorResponse.class::isInstance;
        WINDOW_UNTIL = PredicateUtils.or(predicateArray);
    }
}

