/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.message.frontend;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.message.frontend.ExecutionType;
import io.r2dbc.postgresql.message.frontend.FrontendMessage;
import io.r2dbc.postgresql.message.frontend.FrontendMessageUtils;
import io.r2dbc.postgresql.util.Assert;
import java.util.Objects;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public final class Describe
implements FrontendMessage,
FrontendMessage.DirectEncoder {
    public static final String UNNAMED = "";
    private final String name;
    private final ExecutionType type;

    public Describe(String name, ExecutionType type) {
        this.name = Assert.requireNonNull(name, "name must not be null");
        this.type = Assert.requireNonNull(type, "type must not be null");
    }

    @Override
    public Publisher<ByteBuf> encode(ByteBufAllocator byteBufAllocator) {
        Assert.requireNonNull(byteBufAllocator, "byteBufAllocator must not be null");
        return Mono.fromSupplier(() -> {
            ByteBuf out = byteBufAllocator.ioBuffer();
            this.encode(out);
            return out;
        });
    }

    @Override
    public void encode(ByteBuf byteBuf) {
        FrontendMessageUtils.writeByte(byteBuf, 68);
        int writerIndex = byteBuf.writerIndex();
        FrontendMessageUtils.writeLengthPlaceholder(byteBuf);
        FrontendMessageUtils.writeByte(byteBuf, (int)this.type.getDiscriminator());
        FrontendMessageUtils.writeCStringUTF8(byteBuf, this.name);
        FrontendMessageUtils.writeSize(byteBuf, writerIndex);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Describe that = (Describe)o;
        return Objects.equals(this.name, that.name) && this.type == that.type;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.type});
    }

    public String toString() {
        return "Describe{name='" + this.name + '\'' + ", type=" + (Object)((Object)this.type) + '}';
    }
}

