/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.replication;

import java.util.Objects;

public final class LogSequenceNumber
implements Comparable<LogSequenceNumber> {
    public static final LogSequenceNumber INVALID_LSN = LogSequenceNumber.valueOf(0L);
    private final long value;

    private LogSequenceNumber(long value) {
        this.value = value;
    }

    public static LogSequenceNumber valueOf(long value) {
        return new LogSequenceNumber(value);
    }

    public static LogSequenceNumber valueOf(String strValue) {
        int slashIndex = strValue.lastIndexOf(47);
        if (slashIndex <= 0) {
            return INVALID_LSN;
        }
        int logicalXlog = (int)Long.parseLong(strValue.substring(0, slashIndex), 16);
        int segment = (int)Long.parseLong(strValue.substring(slashIndex + 1), 16);
        long value = (long)logicalXlog << 32 | (long)segment;
        return LogSequenceNumber.valueOf(value);
    }

    public long asLong() {
        return this.value;
    }

    public String asString() {
        int logicalXlog = (int)(this.value >> 32);
        int segment = (int)this.value;
        return String.format("%X/%X", logicalXlog, segment);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LogSequenceNumber)) {
            return false;
        }
        LogSequenceNumber that = (LogSequenceNumber)o;
        return this.value == that.value;
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return "LSN{" + this.asString() + '}';
    }

    @Override
    public int compareTo(LogSequenceNumber o) {
        if (this.value == o.value) {
            return 0;
        }
        return this.value + Long.MIN_VALUE < o.value + Long.MIN_VALUE ? -1 : 1;
    }
}

