/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.client.EncodedParameter;
import io.r2dbc.postgresql.codec.AbstractCodec;
import io.r2dbc.postgresql.codec.ArrayCodecDelegate;
import io.r2dbc.postgresql.codec.PostgresTypeIdentifier;
import io.r2dbc.postgresql.codec.PostgresqlObjectId;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.util.Assert;
import io.r2dbc.postgresql.util.ByteBufUtils;
import java.util.Collections;
import java.util.function.Function;

abstract class BuiltinCodecSupport<T>
extends AbstractCodec<T>
implements ArrayCodecDelegate<T> {
    private final ByteBufAllocator byteBufAllocator;
    private final PostgresqlObjectId postgresType;
    private final PostgresqlObjectId postgresArrayType;
    private final Function<T, String> toTextEncoder;

    BuiltinCodecSupport(Class<T> type, ByteBufAllocator byteBufAllocator, PostgresqlObjectId postgresType, PostgresqlObjectId postgresArrayType, Function<T, String> toTextEncoder) {
        super(type);
        this.byteBufAllocator = Assert.requireNonNull(byteBufAllocator, "byteBufAllocator must not be null");
        this.postgresType = Assert.requireNonNull(postgresType, "postgresType must not be null");
        this.postgresArrayType = Assert.requireNonNull(postgresArrayType, "postgresArrayType must not be null");
        this.toTextEncoder = Assert.requireNonNull(toTextEncoder, "toTextEncoder must not be null");
    }

    @Override
    boolean doCanDecode(PostgresqlObjectId type, Format format) {
        Assert.requireNonNull(type, "type must not be null");
        return this.postgresType == type;
    }

    @Override
    final EncodedParameter doEncode(T value) {
        return this.doEncode(value, this.postgresType);
    }

    @Override
    final EncodedParameter doEncode(T value, PostgresTypeIdentifier dataType) {
        Assert.requireNonNull(value, "value must not be null");
        return BuiltinCodecSupport.create(Format.FORMAT_TEXT, dataType, () -> ByteBufUtils.encode(this.byteBufAllocator, this.encodeToText(value)));
    }

    @Override
    public final String encodeToText(T value) {
        Assert.requireNonNull(value, "value must not be null");
        return this.toTextEncoder.apply(value);
    }

    @Override
    public final EncodedParameter encodeNull() {
        return BuiltinCodecSupport.createNull(Format.FORMAT_TEXT, this.postgresType);
    }

    @Override
    public Iterable<PostgresTypeIdentifier> getDataTypes() {
        return Collections.singleton(this.postgresType);
    }

    @Override
    public final PostgresTypeIdentifier getArrayDataType() {
        return this.postgresArrayType;
    }
}

