/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.message.backend;

import io.netty.buffer.ByteBuf;
import io.r2dbc.postgresql.message.backend.BackendMessage;
import io.r2dbc.postgresql.message.backend.BackendMessageUtils;
import io.r2dbc.postgresql.util.Assert;
import java.util.Objects;

public final class NotificationResponse
implements BackendMessage {
    private final String name;
    private final String payload;
    private final int processId;

    public NotificationResponse(String name, String payload, int processId) {
        this.name = Assert.requireNonNull(name, "name must not be null");
        this.payload = Assert.requireNonNull(payload, "payload must not be null");
        this.processId = processId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NotificationResponse that = (NotificationResponse)o;
        return this.processId == that.processId && Objects.equals(this.name, that.name) && Objects.equals(this.payload, that.payload);
    }

    public String getName() {
        return this.name;
    }

    public String getPayload() {
        return this.payload;
    }

    public int getProcessId() {
        return this.processId;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.payload, this.processId);
    }

    public String toString() {
        return "NotificationResponse{name='" + this.name + '\'' + ", payload='" + this.payload + '\'' + ", processId=" + this.processId + '}';
    }

    static NotificationResponse decode(ByteBuf in) {
        Assert.requireNonNull(in, "in must not be null");
        int processId = in.readInt();
        String name = BackendMessageUtils.readCStringUTF8(in);
        String payload = BackendMessageUtils.readCStringUTF8(in);
        return new NotificationResponse(name, payload, processId);
    }
}

