/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.message.backend;

import io.netty.buffer.ByteBuf;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.message.backend.BackendMessage;
import io.r2dbc.postgresql.message.backend.BackendMessageUtils;
import io.r2dbc.postgresql.util.Assert;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class RowDescription
implements BackendMessage {
    private final List<Field> fields;

    public RowDescription(List<Field> fields) {
        this.fields = Assert.requireNonNull(fields, "fields must not be null");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RowDescription that = (RowDescription)o;
        return Objects.equals(this.fields, that.fields);
    }

    public List<Field> getFields() {
        return this.fields;
    }

    public int hashCode() {
        return Objects.hash(this.fields);
    }

    public String toString() {
        return "RowDescription{fields=" + this.fields + '}';
    }

    static RowDescription decode(ByteBuf in) {
        List<Field> fields;
        Assert.requireNonNull(in, "in must not be null");
        int fieldCount = in.readShort();
        switch (fieldCount) {
            case 0: {
                fields = Collections.emptyList();
                break;
            }
            case 1: {
                fields = Collections.singletonList(Field.decode(in));
                break;
            }
            default: {
                fields = new ArrayList(fieldCount);
                for (int i = 0; i < fieldCount; ++i) {
                    fields.add(Field.decode(in));
                }
            }
        }
        return new RowDescription(fields);
    }

    public static final class Field {
        private final short column;
        private final int dataType;
        private final int dataTypeModifier;
        private final short dataTypeSize;
        private final Format format;
        private final String name;
        private final int table;

        public Field(short column, int dataType, int dataTypeModifier, short dataTypeSize, Format format, String name, int table) {
            this.column = column;
            this.dataType = dataType;
            this.dataTypeModifier = dataTypeModifier;
            this.dataTypeSize = dataTypeSize;
            this.format = Assert.requireNonNull(format, "format must not be null");
            this.name = Assert.requireNonNull(name, "name must not be null");
            this.table = table;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Field that = (Field)o;
            return this.column == that.column && this.dataType == that.dataType && this.dataTypeModifier == that.dataTypeModifier && this.dataTypeSize == that.dataTypeSize && this.table == that.table && this.format == that.format && Objects.equals(this.name, that.name);
        }

        public short getColumn() {
            return this.column;
        }

        public int getDataType() {
            return this.dataType;
        }

        public int getDataTypeModifier() {
            return this.dataTypeModifier;
        }

        public short getDataTypeSize() {
            return this.dataTypeSize;
        }

        public Format getFormat() {
            return this.format;
        }

        public String getName() {
            return this.name;
        }

        public int getTable() {
            return this.table;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.column, this.dataType, this.dataTypeModifier, this.dataTypeSize, this.format, this.name, this.table});
        }

        public String toString() {
            return "Field{column=" + this.column + ", dataType=" + this.dataType + ", dataTypeModifier=" + this.dataTypeModifier + ", dataTypeSize=" + this.dataTypeSize + ", format=" + (Object)((Object)this.format) + ", name='" + this.name + '\'' + ", table=" + this.table + '}';
        }

        static Field decode(ByteBuf in) {
            Assert.requireNonNull(in, "in must not be null");
            String name = BackendMessageUtils.readCStringUTF8(in);
            int table = in.readInt();
            short column = in.readShort();
            int dataType = in.readInt();
            short dataTypeSize = in.readShort();
            int dataTypeModifier = in.readInt();
            Format format = Format.valueOf(in.readShort());
            return new Field(column, dataType, dataTypeModifier, dataTypeSize, format, name, table);
        }
    }
}

