/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.r2dbc.postgresql.codec.Codec;
import io.r2dbc.postgresql.codec.CodecLookup;
import io.r2dbc.postgresql.codec.PreferredCodec;
import io.r2dbc.postgresql.message.Format;
import java.util.Iterator;
import java.util.function.Predicate;
import reactor.util.annotation.Nullable;

class DefaultCodecLookup
implements CodecLookup {
    private final Iterable<Codec<?>> codecs;

    DefaultCodecLookup(Iterable<Codec<?>> codecRegistry) {
        this.codecs = codecRegistry;
    }

    @Nullable
    synchronized <T> Codec<T> findCodec(Predicate<Codec<?>> predicate) {
        for (Codec<?> codec : this.codecs) {
            if (!predicate.test(codec)) continue;
            return codec;
        }
        return null;
    }

    @Override
    public <T> Codec<T> findDecodeCodec(int dataType, Format format, Class<? extends T> type) {
        Codec<T> preferred = this.findCodec(codec -> codec instanceof PreferredCodec && ((PreferredCodec)((Object)codec)).isPreferred(dataType, format, type) && codec.canDecode(dataType, format, type));
        if (preferred != null) {
            return preferred;
        }
        return this.findCodec(codec -> codec.canDecode(dataType, format, type));
    }

    @Override
    public <T> Codec<T> findEncodeCodec(T value) {
        return this.findCodec(codec -> codec.canEncode(value));
    }

    @Override
    public <T> Codec<T> findEncodeNullCodec(Class<T> type) {
        return this.findCodec(codec -> codec.canEncodeNull(type));
    }

    @Override
    public Iterator<Codec<?>> iterator() {
        return this.codecs.iterator();
    }
}

