/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.codec.BuiltinCodecSupport;
import io.r2dbc.postgresql.codec.PostgresTypeIdentifier;
import io.r2dbc.postgresql.codec.PostgresqlObjectId;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.util.Assert;
import io.r2dbc.postgresql.util.ByteBufUtils;
import java.util.UUID;
import org.jspecify.annotations.Nullable;

final class UuidCodec
extends BuiltinCodecSupport<UUID> {
    UuidCodec(ByteBufAllocator byteBufAllocator) {
        super(UUID.class, byteBufAllocator, PostgresqlObjectId.UUID, PostgresqlObjectId.UUID_ARRAY, UUID::toString);
    }

    @Override
    UUID doDecode(ByteBuf buffer, PostgresTypeIdentifier dataType, @Nullable Format format, @Nullable Class<? extends UUID> type) {
        Assert.requireNonNull(buffer, "byteBuf must not be null");
        if (format == Format.FORMAT_BINARY) {
            return new UUID(buffer.readLong(), buffer.readLong());
        }
        String str = ByteBufUtils.decode(buffer);
        return UUID.fromString(str);
    }
}

