/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.util;

import io.netty.buffer.ByteBuf;
import io.r2dbc.postgresql.util.Assert;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;

public final class ByteBufferUtils {
    private ByteBufferUtils() {
    }

    public static String decode(ByteBuffer byteBuffer) {
        Assert.requireNonNull(byteBuffer, "byteBuffer must not be null");
        return StandardCharsets.UTF_8.decode(byteBuffer).toString();
    }

    public static ByteBuffer encode(CharSequence s) {
        Assert.requireNonNull(s, "s must not be null");
        ByteBuffer buffer = StandardCharsets.UTF_8.encode(s.toString());
        buffer.position(buffer.limit());
        ((Buffer)buffer).flip();
        return buffer;
    }

    public static ByteBuffer toByteBuffer(ByteBuf source) {
        Assert.requireNonNull(source, "source must not be null");
        ByteBuffer out = ByteBuffer.allocate(source.readableBytes());
        source.readBytes(out);
        ((Buffer)out).flip();
        return out;
    }
}

