/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql;

import io.r2dbc.postgresql.ConnectionFunction;
import io.r2dbc.postgresql.ExceptionFactory;
import io.r2dbc.postgresql.PostgresqlConnectionConfiguration;
import io.r2dbc.postgresql.authentication.AuthenticationHandler;
import io.r2dbc.postgresql.authentication.UsernameAndPassword;
import io.r2dbc.postgresql.client.Client;
import io.r2dbc.postgresql.client.ConnectionContext;
import io.r2dbc.postgresql.client.ConnectionSettings;
import io.r2dbc.postgresql.client.PostgresStartupParameterProvider;
import io.r2dbc.postgresql.client.StartupMessageFlow;
import io.r2dbc.postgresql.message.backend.AuthenticationMessage;
import java.net.SocketAddress;
import java.util.Optional;
import reactor.core.publisher.Mono;

final class SingleHostConnectionFunction
implements ConnectionFunction {
    private final ConnectionFunction upstreamFunction;
    private final PostgresqlConnectionConfiguration configuration;

    SingleHostConnectionFunction(ConnectionFunction upstreamFunction, PostgresqlConnectionConfiguration configuration) {
        this.upstreamFunction = upstreamFunction;
        this.configuration = configuration;
    }

    @Override
    public Mono<Client> connect(SocketAddress endpoint, ConnectionSettings settings) {
        return this.upstreamFunction.connect(endpoint, settings).delayUntil(client -> this.getCredentials().flatMapMany(credentials -> StartupMessageFlow.exchange(auth -> this.getAuthenticationHandler((AuthenticationMessage)auth, (UsernameAndPassword)credentials, client.getContext()), client, this.configuration.getDatabase(), credentials.getUsername(), SingleHostConnectionFunction.getParameterProvider(this.configuration, settings))).handle(ExceptionFactory.INSTANCE::handleErrorResponse));
    }

    private static PostgresStartupParameterProvider getParameterProvider(PostgresqlConnectionConfiguration configuration, ConnectionSettings settings) {
        return new PostgresStartupParameterProvider(configuration.getApplicationName(), configuration.getTimeZone(), settings);
    }

    protected AuthenticationHandler getAuthenticationHandler(AuthenticationMessage message, UsernameAndPassword usernameAndPassword, ConnectionContext context) {
        return AuthenticationHandler.getAuthenticationHandler(message, usernameAndPassword, context);
    }

    Mono<UsernameAndPassword> getCredentials() {
        return Mono.zip((Mono)Mono.from(this.configuration.getUsername()).single(), (Mono)Mono.from(this.configuration.getPassword()).singleOptional()).map(it -> new UsernameAndPassword((String)it.getT1(), ((Optional)it.getT2()).orElse(null)));
    }
}

